/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.daemon;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.refcodes.component.OpenException;
import org.refcodes.configuration.JavaProperties;
import org.refcodes.configuration.JavaPropertiesBuilder;
import org.refcodes.configuration.Properties;
import org.refcodes.configuration.ResourceProperties;
import org.refcodes.data.LatencySleepTime;
import org.refcodes.data.Scheme;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.BasicAuthCredentials;
import org.refcodes.net.BasicCredentials;
import org.refcodes.net.BasicCredentialsImpl;
import org.refcodes.net.HttpMediaType;
import org.refcodes.net.HttpResponseException;
import org.refcodes.net.HttpServerResponse;
import org.refcodes.net.HttpStatusException;
import org.refcodes.net.MediaType;
import org.refcodes.net.PortManagerSingleton;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.ResponseHeaderFields;
import org.refcodes.rest.HttpRestClientImpl;
import org.refcodes.rest.HttpRestServer;
import org.refcodes.rest.HttpRestServerImpl;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.textual.Case;
import org.refcodes.textual.CaseStyleBuilderImpl;

public abstract class AbstractDaemon {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    protected static final String CONFIGURATION_FILE = "application.conf";
    private static final String PROPERTY_PORT = "MANAGEMENT_PORT";
    private static final String PROPERTY_SHUTDOWN_PATH = "MANAGEMENT_SHUTDOWN_PATH";
    private static final String PROPERTY_USERNAME = "MANAGEMENT_USERNAME";
    private static final String PROPERTY_SECRET = "MANAGEMENT_SECRET";
    private static final String CONFIG_FILE_NAME = "application.conf";
    private static final String DEFAULT_SHUTDOWN_PATH = "/shutdown";
    protected static final int EXIT_CODE_OK = 0;
    protected static final int EXIT_CODE_ALREADY_STARTED = 1;
    protected static final int EXIT_CODE_NOT_RUNNING = 2;
    protected static final int EXIT_CANNOT_OPEN_MANAGEMENT_SERVER = 3;
    protected static final int EXIT_CANNOT_SAVE_RUNTIME_PROPERTIES = 4;
    protected static final int EXIT_CANNOT_LOAD_RUNTIME_PROPERTIES = 5;
    protected static final int EXIT_CODE_NOT_STARTED = 6;

    protected static void doRestart() {
        AbstractDaemon.doRestart("application.conf");
    }

    private static void doRestart(String configFileName) {
        AbstractDaemon.doShutdown(ShutDownMode.GRACEFUL);
        AbstractDaemon.doStartup(configFileName);
    }

    protected static void doStartup() {
        AbstractDaemon.doStartup("application.conf");
    }

    protected static void doStartup(String aConfigFileName) {
        int theMgmPort;
        File theRuntimeFile = AbstractDaemon.toRuntimePropertiesFile();
        if (theRuntimeFile.isFile()) {
            theMgmPort = -1;
            try {
                JavaProperties theRuntimeSettings = new JavaProperties(theRuntimeFile);
                theMgmPort = theRuntimeSettings.getInteger(PROPERTY_PORT);
                if (theMgmPort != -1 && !PortManagerSingleton.getInstance().isPortAvaialble(theMgmPort)) {
                    LOGGER.error("A server seems already to be running on port <" + theMgmPort + ">! You cannot start it more than once.");
                    System.exit(1);
                }
                LOGGER.error("A server seems already to be running! You cannot start it more than once.");
                System.exit(1);
            }
            catch (IOException | ParseException theRuntimeSettings) {
                // empty catch block
            }
        }
        theMgmPort = -1;
        String theUserName = null;
        String theSecret = null;
        String theShutdownLocator = null;
        try {
            Properties theConfiguration = AbstractDaemon.toConfigurationProperties(aConfigFileName);
            theUserName = (String)theConfiguration.get((Object)PROPERTY_USERNAME);
            theSecret = (String)theConfiguration.get((Object)PROPERTY_SECRET);
            theShutdownLocator = (String)theConfiguration.get((Object)PROPERTY_SHUTDOWN_PATH);
            try {
                theMgmPort = theConfiguration.getInteger(PROPERTY_PORT);
            }
            catch (Exception exception) {}
        }
        catch (IOException | ParseException e) {
            LOGGER.info("No configuration <" + aConfigFileName + "> provided, using default settings: " + ExceptionUtility.toMessage((Throwable)e));
        }
        theMgmPort = theMgmPort != -1 ? theMgmPort : PortManagerSingleton.getInstance().bindAnyPort();
        BasicCredentialsImpl theCredentials = theUserName != null || theSecret != null ? new BasicCredentialsImpl(theUserName, theSecret) : null;
        String theShutdownPath = theShutdownLocator != null ? theShutdownLocator : DEFAULT_SHUTDOWN_PATH;
        LOGGER.info("Starting daemon's management server with shutdown path <" + theShutdownPath + "> on port <" + theMgmPort + ">...");
        HttpRestServerImpl theRestServer = new HttpRestServerImpl();
        try {
            theRestServer.onGet(theShutdownPath, (arg_0, arg_1) -> AbstractDaemon.lambda$doStartup$1((BasicCredentials)theCredentials, (HttpRestServer)theRestServer, arg_0, arg_1)).open();
            theRestServer.open(theMgmPort);
        }
        catch (OpenException e) {
            LOGGER.error("Cannot open the management server on port <" + theMgmPort + ">, aborting: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            System.exit(3);
        }
        ResourceProperties.ResourcePropertiesBuilder theProperties = new JavaPropertiesBuilder().withPutInteger(PROPERTY_PORT, Integer.valueOf(theMgmPort)).withPut(PROPERTY_SHUTDOWN_PATH, theShutdownPath);
        theRuntimeFile.deleteOnExit();
        try {
            theProperties.saveTo(theRuntimeFile);
        }
        catch (IOException e) {
            LOGGER.error("Cannot save runtime properties to file <" + theRuntimeFile + ">, aborting: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            System.exit(4);
        }
    }

    protected static void doShutdown() {
        AbstractDaemon.doShutdown(ShutDownMode.STRICT);
    }

    protected static void doShutdown(ShutDownMode aShutDowenMode) {
        block10: {
            File theRuntimeFile = AbstractDaemon.toRuntimePropertiesFile();
            if (!theRuntimeFile.isFile() && aShutDowenMode == ShutDownMode.STRICT) {
                LOGGER.info("The server seems not to be running! You must start the server before shutting down.");
                System.exit(6);
            }
            try {
                JavaProperties theRuntimeSettings = new JavaProperties(theRuntimeFile);
                theRuntimeFile.deleteOnExit();
                String theShutdownPath = (String)theRuntimeSettings.get((Object)PROPERTY_SHUTDOWN_PATH);
                theShutdownPath = theShutdownPath != null ? theShutdownPath : DEFAULT_SHUTDOWN_PATH;
                LOGGER.info("Shutting down daemon with management server's shutdown path <" + theShutdownPath + "> on port <" + theRuntimeSettings.getInteger(PROPERTY_PORT) + "> ...");
                try {
                    new HttpRestClientImpl().doGet(Scheme.HTTP, "localhost", theRuntimeSettings.getInteger(PROPERTY_PORT).intValue(), theShutdownPath);
                }
                catch (HttpResponseException e) {
                    if (aShutDowenMode == ShutDownMode.STRICT) {
                        LOGGER.info("No daemon running with shutdown path <" + theShutdownPath + "> on port <" + (String)theRuntimeSettings.get((Object)PROPERTY_PORT) + ">, nothing to stop.");
                        System.exit(2);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Cannot shut down via shutdown path <" + theShutdownPath + "> on port <" + (String)theRuntimeSettings.get((Object)PROPERTY_PORT) + ">:" + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                    System.exit(5);
                }
                try {
                    Thread.sleep(LatencySleepTime.MIN.getMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (aShutDowenMode == ShutDownMode.STRICT) {
                    System.exit(0);
                }
            }
            catch (IOException | ParseException e) {
                if (aShutDowenMode != ShutDownMode.STRICT) break block10;
                LOGGER.error("Cannot load runtime properties from file <" + theRuntimeFile + ">, aborting: " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                System.exit(5);
            }
        }
    }

    protected static File toRuntimePropertiesFile() {
        String simpleName = RuntimeUtility.getMainClass().getSimpleName();
        String theFileName = new CaseStyleBuilderImpl().withCase(Case.LOWER).toKebabCase(simpleName).toLowerCase() + ".properties";
        return new File(RuntimeUtility.toLauncherDir(), theFileName);
    }

    protected static Properties toConfigurationProperties(String aConfigFileName) throws IOException, ParseException {
        JavaProperties theConfiguration = new JavaProperties(aConfigFileName);
        return theConfiguration;
    }

    private static /* synthetic */ void lambda$doStartup$1(BasicCredentials theCredentials, HttpRestServer theRestServer, RestRequestEvent aRequest, HttpServerResponse aResponse) throws HttpStatusException {
        if (theCredentials != null) {
            BasicAuthCredentials theAuthCredentials = ((RequestHeaderFields)aRequest.getHeaderFields()).getBasicAuthCredentials();
            theAuthCredentials.validate(theCredentials);
        }
        LOGGER.info("Shutting down ...");
        ((ResponseHeaderFields)aResponse.getHeaderFields()).putContentType((HttpMediaType)MediaType.APPLICATION_JSON);
        aResponse.setResponse((Object)"Shutting down ... bye!");
        theRestServer.closeIn(LatencySleepTime.MIN.getMillis());
        Executors.newSingleThreadScheduledExecutor().schedule(() -> System.exit(0), (long)LatencySleepTime.MIN.getMillis(), TimeUnit.MILLISECONDS);
    }

    private static enum ShutDownMode {
        STRICT,
        GRACEFUL;

    }
}

