package org.refcodes.data;

import org.refcodes.mixin.ValueAccessor;

/**
 * The Enum BitMask.
 */
public enum BitMask implements ValueAccessor<Long> {

	MASK_8(0xFFL), MASK_16(0xFFFFL), MASK_24(0xFFFFFFL), MASK_32(0xFFFFFFFFL), MASK_40(0xFFFFFFFFFFL), MASK_48(0xFFFFFFFFFFFFL), MASK_56(0xFFFFFFFFFFFFFFL), MASK_64(0xFFFFFFFFFFFFFFFFL);

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private long _value;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new bit mask.
	 *
	 * @param aValue the a value
	 */
	private BitMask( long aValue ) {
		_value = aValue;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Long getValue() {
		return _value;
	}
}
