// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.data;

import org.refcodes.mixin.CodeAccessor;

/**
 * The {@link Encoding} define values representing an encoding which are to be
 * passed as argument to according methods.
 */
public enum Encoding implements CodeAccessor<String> {

	/**
	 * Encoding identifying UTF-8 when working with {@link String} objects.
	 */
	UTF_8("UTF-8"),

	/**
	 * This encoding is especially useful when having to ensure a 1-to-1 mapping
	 * between bytes and characters.
	 */
	ISO_8859_1("ISO-8859-1"),

	/**
	 * MD5 hash encoding.
	 */
	MD5("MD5");

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _code;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new encoding.
	 *
	 * @param aCode the a code
	 */
	private Encoding( String aCode ) {
		_code = aCode;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getCode() {
		return _code;
	}
}
