// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.data;

/**
 * The {@link FileNameExtension} define values useful when working with files or
 * a file-system.
 */
public enum FileNameExtension {

	TEMP(".tmp"),

	BACKUP(".bak"),

	TAR(".tar"),

	GZIP(".gz"),

	TAR_GZIP(".tgz"),

	CSV(".csv"),

	JAR(".jar"),

	ZIP(".zip"),

	SH(".sh"),

	/**
	 * The file suffix used for files containing a single cipher version.
	 */
	CIPHER_VERSION(".cv");

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _extension;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new file name extension.
	 *
	 * @param aExtension the a extension
	 */
	private FileNameExtension( String aExtension ) {
		_extension = aExtension;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Gets the extension.
	 *
	 * @return the extension
	 */
	public String getExtension() {
		return _extension;
	}

}
