// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.data;

import org.refcodes.mixin.NameAccessor;

/**
 * The {@link Folder} define values useful when working with files or a
 * file-system.
 */
public enum Folder implements NameAccessor {

	// @formatter:off
	CONFIG("config"),
	
	ETC("etc"),
	
	SETTINGS("settings"),
	
	CACHE("cache"),
	
	REFCODES(".refcodes"),
	
	HIDDEN_CONFIG(".config"),
	
	HIDDEN_SETTINGS("settings"),
	
	TARGET("target"),
	
	CLASSES("classes"),
	
	TEST_CLASSES("test-classes");
	// @formatter: on

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _folderName;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new folder.
	 *
	 * @param aFolderName the a folder name
	 */
	private Folder( String aFolderName ) {
		_folderName = aFolderName;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return _folderName;
	}
}
