// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.data;

/**
 * Some values's literal ({@link String}) representation useful when parsing or
 * evaluating texts.
 */
public enum Literals {

	/**
	 * Strings representing a "true" boolean value.
	 */
	TRUE(new String[] {
			Literal.TRUE.getName(), Literal.YES.getName(), Literal.ON.getName(), "1"
	}),
	/**
	 * Strings representing a "false" boolean value.
	 */
	FALSE(new String[] {
			Literal.FALSE.getName(), Literal.NO.getName(), Literal.OFF.getName(), "0"
	});

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String[] _literalNames;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new literals.
	 *
	 * @param aLiteralNames the a literal names
	 */
	private Literals( String[] aLiteralNames ) {
		_literalNames = aLiteralNames;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * An array of the names representing the set of folder names.
	 * 
	 * @return The array of folder names representing this set.
	 */
	public String[] getNames() {
		return _literalNames;
	}

}
