// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.data;

import org.refcodes.mixin.PrefixAccessor;

/**
 * Commonly used characters needful for analyzing, parsing or truncating texts.
 */
public enum Prefix implements PrefixAccessor {

	// @formatter:off
	ENCRYPTED( "encrypted:" ),
	/**
	 * A command line argument (POSIX) short-option is prefixed with a single 
	 * hyphen-minus "-".
	 */
	SHORT_ARG_OPTION("-"),

	/**
	 * A command line argument (POSIX) long-option is prefixed with a double 
	 * hyphen-minus "--".
	 */
	LONG_ARG_OPTION( "--");
	// @formatter:on

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _prefix;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new prefix.
	 *
	 * @param aPrefix the a prefix
	 */
	private Prefix( String aPrefix ) {
		_prefix = aPrefix;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getPrefix() {
		return _prefix;
	}

}
