// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.data;

/**
 * Constant definitions used by the refcodes-console artifact.
 */
public enum Prefixes {

	/**
	 * All option prefixes as defines by this {@link Prefixes} interface; being
	 * the {@link Prefix#SHORT_ARG_OPTION} and the
	 * {@link Prefix#LONG_ARG_OPTION}.
	 */
	ARG_OPTION(new String[] {
			Prefix.SHORT_ARG_OPTION.getPrefix(), Prefix.LONG_ARG_OPTION.getPrefix()
	});

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String[] _prefixSet;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new prefixes.
	 *
	 * @param aPrefixSet the a prefix set
	 */
	private Prefixes( String[] aPrefixSet ) {
		_prefixSet = aPrefixSet;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Gets the prefixes.
	 *
	 * @return the prefixes
	 */
	public String[] getPrefixes() {
		return _prefixSet;
	}

}
