/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.refcodes.data.Delimiter;
import org.refcodes.data.FileNameExtension;
import org.refcodes.data.Suffix;
import org.refcodes.mixin.NameAccessor;

public enum Protocol implements NameAccessor
{
    JAR("jar", FileNameExtension.JAR.getExtension() + Delimiter.JAR_URL_RESOURCE.getChar()),
    ZIP("zip", FileNameExtension.ZIP.getExtension() + Delimiter.JAR_URL_RESOURCE.getChar()),
    SH("sh", FileNameExtension.SH.getExtension() + Delimiter.JAR_URL_RESOURCE.getChar()),
    FILE("file", "file" + Suffix.PROTOCOL.getSuffix() + Delimiter.PATH.getChar()),
    HTTP("http", "http" + Suffix.PROTOCOL.getSuffix() + Delimiter.PATH.getChar() + Delimiter.PATH.getChar()),
    HTTPS("https", "https" + Suffix.PROTOCOL.getSuffix() + Delimiter.PATH.getChar() + Delimiter.PATH.getChar()),
    SOCKS("socks", "socks" + Suffix.PROTOCOL.getSuffix() + Delimiter.PATH.getChar() + Delimiter.PATH.getChar()),
    SOCKS4("socks4", "socks4" + Suffix.PROTOCOL.getSuffix() + Delimiter.PATH.getChar() + Delimiter.PATH.getChar()),
    SOCKS5("socks4", "socks4" + Suffix.PROTOCOL.getSuffix() + Delimiter.PATH.getChar() + Delimiter.PATH.getChar());

    private String _name;
    private String _resourceLocatorPrefix;

    private Protocol(String aProtocolName, String aResourceLocatorPrefix) {
        this._name = aProtocolName;
        this._resourceLocatorPrefix = aResourceLocatorPrefix;
    }

    public String getName() {
        return this._name;
    }

    public String toPrefix() {
        return this._name + Suffix.PROTOCOL.getSuffix();
    }

    public String toResourceLocator(String aUrl, int aBeginIndex) {
        String theLocator = aUrl;
        int i = theLocator.indexOf(this._resourceLocatorPrefix, aBeginIndex);
        if (i != -1) {
            return theLocator.substring(0, i += this._resourceLocatorPrefix.length() - 1);
        }
        return null;
    }

    public String toResourceLocator(String aUrl) {
        return this.toResourceLocator(aUrl, 0);
    }

    public int nextResourceLocatorIndex(String aUrl, int aBeginIndex) {
        int i = aUrl.indexOf(this._resourceLocatorPrefix, aBeginIndex);
        if (i != -1) {
            i += this._resourceLocatorPrefix.length() - 1;
        }
        return i;
    }

    public int firstResourceLocatorIndex(String aUrl) {
        int i = aUrl.indexOf(this._resourceLocatorPrefix, 0);
        if (i != -1) {
            i += this._resourceLocatorPrefix.length() - 1;
        }
        return i;
    }

    public String getResourceLocatorPrefix() {
        return this._resourceLocatorPrefix;
    }

    public static Protocol fromName(String aName) {
        for (Protocol eElement : Protocol.values()) {
            if (!eElement.getName().equalsIgnoreCase(aName)) continue;
            return eElement;
        }
        return null;
    }
}

