// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.data;

/**
 * This enumeration groups {@link CommandArgPrefix} by platform.
 */
public enum CommandArgPrefixes {

	/**
	 * Prefixes for command line arguments commonly used on Windows based
	 * systems.
	 */
	WINDOWS(CommandArgPrefix.WINDOWS_OPTION),

	/**
	 * Prefixes for command line arguments commonly used on POSIX conforming
	 * systems.
	 */
	POSIX(CommandArgPrefix.POSIX_SHORT_OPTION, CommandArgPrefix.POSIX_LONG_OPTION);

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private CommandArgPrefix[] _prefixes;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	private CommandArgPrefixes( CommandArgPrefix... aPrefixes ) {
		_prefixes = aPrefixes;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Returns the related {@link CommandArgPrefix} elements.
	 * 
	 * @return The according {@link CommandArgPrefix} elements.
	 */
	public CommandArgPrefix[] getCommandArgPrefixes() {
		return _prefixes;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Returns an array with all {@link String} prefixes as of
	 * {@link CommandArgPrefix#getPrefix()} defined by this enumeration.
	 * 
	 * @return The array with the according prefixes.
	 */
	public String[] toPrefixes() {
		String[] theResult = new String[_prefixes.length];
		for ( int i = 0; i < _prefixes.length; i++ ) {
			theResult[i] = _prefixes[i].getPrefix();
		}
		return theResult;
	}
}
