/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.refcodes.mixin.EnabledAccessor;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.ValueAccessor;

public enum SystemProperty implements KeyAccessor<String>,
ValueAccessor.ValueProperty<String>,
EnabledAccessor.EnabledProperty
{
    GRAALVM_IMAGE_CODE_KEY("org.graalvm.nativeimage.imagecode"),
    JAVA_AWT_HEADLESS("java.awt.headless"),
    HTTP_PROXY_HOST("http.proxyHost"),
    HTTP_PROXY_PORT("http.proxyPort"),
    HTTPS_PROXY_HOST("https.proxyHost"),
    HTTPS_PROXY_PORT("https.proxyPort"),
    SOCKS_PROXY_HOST("socksProxyHost"),
    SOCKS_PROXY_PORT("socksProxyPort"),
    HOST_SEED("host.seed"),
    HTTP_NON_PROXY_HOSTS("http.nonProxyHosts"),
    HTTPS_NON_PROXY_HOSTS("https.nonProxyHosts"),
    OS_ARCH("os.arch"),
    OS_NAME("os.name"),
    CONFIG_DIR("config.dir"),
    FILE_SEPARATOR("file.separator"),
    TEMP_DIR("java.io.tmpdir"),
    PROCESS_ID("PID"),
    LINE_SEPARATOR("line.separator"),
    OPERATING_SYSTEM_NAME("os.name"),
    OPERATING_SYSTEM_VERSION("os.version"),
    LAUNCHER_DIR("launcher.dir"),
    CONSOLE_HEIGHT("console.height"),
    CONSOLE_WIDTH("console.width"),
    CONSOLE_ANSI("console.ansi"),
    CONSOLE_LINE_BREAK("console.lineBreak"),
    LOGGER_LAYOUT("logger.layout"),
    LOGGER_STYLE("logger.style"),
    USER_HOME("user.home"),
    USER_NAME("user.name"),
    USER_LANGUAGE("user.language"),
    USER_COUNTRY("user.country"),
    USER_DIR("user.dir"),
    KEY_STORE_FILE("javax.net.ssl.keyStore"),
    KEY_STORE_PASSWORD("javax.net.ssl.keyStorePassword"),
    KEY_STORE_TYPE("javax.net.ssl.keyStoreType"),
    TRUST_STORE_FILE("javax.net.ssl.trustStore"),
    TRUST_STORE_PASSWORD("javax.net.ssl.trustStorePassword"),
    TRUST_STORE_TYPE("javax.net.ssl.trustStoreType");

    private String _systemPropertyName;

    private SystemProperty(String aSystemPropertyName) {
        this._systemPropertyName = aSystemPropertyName;
    }

    public String getKey() {
        return this._systemPropertyName;
    }

    public String getValue() {
        return System.getProperty(this._systemPropertyName);
    }

    public void setValue(String aValue) {
        System.setProperty(this._systemPropertyName, aValue);
    }

    public boolean isEnabled() {
        return Boolean.getBoolean(this._systemPropertyName);
    }

    public void setEnabled(boolean isEnabled) {
        this.setValue(Boolean.toString(isEnabled));
    }
}

