/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.AnsiEscapeCode;

public class AnsiEscapeCodeTest {
    private static final boolean IS_LOG_TEST_ENABLED = Boolean.getBoolean("log.test");

    @Test
    public void testBrightRedForegroundBold() {
        AnsiEscapeCode[] theCodes = new AnsiEscapeCode[]{AnsiEscapeCode.FG_BRIGHT_RED, AnsiEscapeCode.BOLD};
        String theSequence = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])theCodes);
        theSequence = AnsiEscapeCode.toEscapedSequence((String)theSequence);
        if (IS_LOG_TEST_ENABLED) {
            for (int i = 0; i < theCodes.length; ++i) {
                AnsiEscapeCode eCode = theCodes[i];
                System.out.print(eCode);
                if (i >= theCodes.length - 1) continue;
                System.out.print("+");
            }
            System.out.println("=" + theSequence);
        }
        Assertions.assertEquals((Object)"u001B[91;1m", (Object)theSequence);
    }

    @Test
    public void testBrightWhiteForegroundBrightRedBackground() {
        AnsiEscapeCode[] theCodes = new AnsiEscapeCode[]{AnsiEscapeCode.FG_BRIGHT_WHITE, AnsiEscapeCode.BG_BRIGHT_RED};
        String theSequence = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])theCodes);
        theSequence = AnsiEscapeCode.toEscapedSequence((String)theSequence);
        if (IS_LOG_TEST_ENABLED) {
            for (int i = 0; i < theCodes.length; ++i) {
                AnsiEscapeCode eCode = theCodes[i];
                System.out.print(eCode);
                if (i >= theCodes.length - 1) continue;
                System.out.print("+");
            }
            System.out.println("=" + theSequence);
        }
        Assertions.assertEquals((Object)"u001B[97;101m", (Object)theSequence);
    }

    @Test
    public void testReset() {
        AnsiEscapeCode[] theCodes = new AnsiEscapeCode[]{AnsiEscapeCode.RESET};
        String theSequence = AnsiEscapeCode.toEscapeSequence((AnsiEscapeCode[])theCodes);
        theSequence = AnsiEscapeCode.toEscapedSequence((String)theSequence);
        if (IS_LOG_TEST_ENABLED) {
            for (int i = 0; i < theCodes.length; ++i) {
                AnsiEscapeCode eCode = theCodes[i];
                System.out.print(eCode);
                if (i >= theCodes.length - 1) continue;
                System.out.print("+");
            }
            System.out.println("=" + theSequence);
        }
        Assertions.assertEquals((Object)"u001B[0m", (Object)theSequence);
    }
}

