/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.date.impls;

import java.text.AttributedCharacterIterator;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class ConcurrentDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 1L;
    private FastDateFormat _fastDateFormat;
    private String[] _parsePatterns;

    public ConcurrentDateFormat() {
        this._fastDateFormat = FastDateFormat.getInstance();
    }

    public ConcurrentDateFormat(String pattern, Locale locale) {
        super(pattern, locale);
        this._fastDateFormat = FastDateFormat.getInstance((String)pattern, (Locale)locale);
        this._parsePatterns = new String[]{pattern};
    }

    public ConcurrentDateFormat(String pattern) {
        super(pattern);
        this._fastDateFormat = FastDateFormat.getInstance((String)pattern);
        this._parsePatterns = new String[]{pattern};
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this._fastDateFormat.format((Object)date, toAppendTo, fieldPosition);
    }

    public String toString(Date aDate) {
        return this._fastDateFormat.format(aDate);
    }

    @Override
    public Date parse(String source) throws ParseException {
        return DateUtils.parseDate((String)source, (String[])this._parsePatterns);
    }

    @Override
    @Deprecated
    public synchronized Date parse(String text, ParsePosition pos) {
        return super.parse(text, pos);
    }

    @Override
    @Deprecated
    public void set2DigitYearStart(Date startDate) {
        super.set2DigitYearStart(startDate);
    }

    @Override
    @Deprecated
    public Date get2DigitYearStart() {
        return super.get2DigitYearStart();
    }

    @Override
    @Deprecated
    public AttributedCharacterIterator formatToCharacterIterator(Object obj) {
        return super.formatToCharacterIterator(obj);
    }

    @Override
    @Deprecated
    public void applyPattern(String pattern) {
        super.applyPattern(pattern);
        this._fastDateFormat = FastDateFormat.getInstance((String)pattern);
        this._parsePatterns = new String[]{pattern};
    }

    @Override
    @Deprecated
    public void applyLocalizedPattern(String pattern) {
        super.applyLocalizedPattern(pattern);
        this._fastDateFormat = FastDateFormat.getInstance((String)pattern);
        this._parsePatterns = new String[]{pattern};
    }

    @Override
    @Deprecated
    public DateFormatSymbols getDateFormatSymbols() {
        return super.getDateFormatSymbols();
    }

    @Override
    @Deprecated
    public void setDateFormatSymbols(DateFormatSymbols newFormatSymbols) {
        super.setDateFormatSymbols(newFormatSymbols);
    }

    @Override
    @Deprecated
    public Object parseObject(String source, ParsePosition pos) {
        return super.parseObject(source, pos);
    }

    @Override
    @Deprecated
    public void setCalendar(Calendar newCalendar) {
        super.setCalendar(newCalendar);
    }

    @Override
    @Deprecated
    public Calendar getCalendar() {
        return super.getCalendar();
    }

    @Override
    @Deprecated
    public void setNumberFormat(NumberFormat newNumberFormat) {
        super.setNumberFormat(newNumberFormat);
    }

    @Override
    @Deprecated
    public NumberFormat getNumberFormat() {
        return super.getNumberFormat();
    }

    @Override
    @Deprecated
    public void setTimeZone(TimeZone zone) {
        super.setTimeZone(zone);
    }

    @Override
    @Deprecated
    public TimeZone getTimeZone() {
        return super.getTimeZone();
    }

    @Override
    @Deprecated
    public void setLenient(boolean lenient) {
        super.setLenient(lenient);
    }

    @Override
    @Deprecated
    public boolean isLenient() {
        return super.isLenient();
    }

    @Override
    @Deprecated
    public Object parseObject(String source) throws ParseException {
        return super.parseObject(source);
    }
}

