/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.util.Objects;
import org.refcodes.decoupling.Dependency;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.TypeAccessor;

public class Claim
implements AliasAccessor,
TypeAccessor,
Comparable<Claim> {
    protected String _alias;
    protected Class<?> _type;

    protected Claim() {
    }

    public Claim(Class<?> aType) {
        this(aType, null);
    }

    public Claim(String aAlias) {
        this(null, aAlias);
    }

    public Claim(Class<?> aType, String aAlias) {
        this._alias = aAlias;
        this._type = aType;
    }

    public String getAlias() {
        return this._alias;
    }

    public Class getType() {
        return this._type;
    }

    public boolean isClaim(Dependency<?> aDependency) {
        if (this._alias != null && !this._alias.equalsIgnoreCase(aDependency.getAlias())) {
            return false;
        }
        return this._type == null || this._type.isAssignableFrom(aDependency.getType());
    }

    @Override
    public int compareTo(Claim aClaim) {
        String thisAlias = this._alias != null ? this._alias : "";
        String thatAlias = aClaim != null && aClaim.getAlias() != null ? aClaim.getAlias() : "";
        return thisAlias.compareTo(thatAlias);
    }

    public int hashCode() {
        return Objects.hash(this._alias, this._type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Claim other = (Claim)obj;
        return Objects.equals(this._alias, other._alias) && Objects.equals(this._type, other._type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", type=" + this._type + "]";
    }

    void setAlias(String aAlias) {
        this._alias = aAlias;
    }

    void setType(Class<?> aType) {
        this._type = aType;
    }
}

