/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.refcodes.decoupling.Claim;
import org.refcodes.decoupling.DependencyBuilder;
import org.refcodes.decoupling.DependencyImpl;
import org.refcodes.decoupling.Factory;
import org.refcodes.decoupling.InstanceMetrics;
import org.refcodes.decoupling.InstanceMode;
import org.refcodes.decoupling.Setup;
import org.refcodes.textual.CaseStyleBuilder;

public class DependencyBuilderImpl<T>
extends DependencyImpl<T>
implements DependencyBuilder<T> {
    protected DependencyBuilderImpl() {
    }

    public DependencyBuilderImpl(Class<T> aType) {
        super(aType);
    }

    public DependencyBuilderImpl(T aInstance) {
        super(aInstance);
    }

    public T getInstance() {
        return this._instances.size() != 0 ? (T)this._instances.iterator().next() : null;
    }

    @Override
    public boolean addClaim(String aAlias) {
        return this._claims.add(new Claim(aAlias));
    }

    @Override
    public boolean addClaim(Claim aClaim) {
        return this._claims.add(aClaim);
    }

    @Override
    public boolean addClaim(Class<?> aType) {
        return this._claims.add(new Claim(aType));
    }

    @Override
    public boolean addClaim(Class<?> aType, String aAlias) {
        return this._claims.add(new Claim(aType, aAlias));
    }

    @Override
    public boolean addProfile(Object aProfile) {
        return this._profiles.add(aProfile);
    }

    @Override
    public boolean addTag(Object aTag) {
        return this._tags.add(aTag);
    }

    @Override
    public <D> void setSetup(Setup<D, T> aSetup) {
        this._setup = aSetup;
    }

    @Override
    public <D> void setSetup(Class<D> aDependency, BiFunction<T, D, T> aInitializer) {
        this._setup = new Setup<D, T>(aDependency, aInitializer);
    }

    @Override
    public <D> void setSetup(Class<D> aDependency, BiFunction<T, D, T> aInitializer, String aAlias) {
        this._setup = new Setup<D, T>(aDependency, aInitializer, aAlias);
    }

    @Override
    public <D> void setFactory(Factory<D, T> aFactory) {
        this._factory = aFactory;
    }

    @Override
    public <D> void setFactory(Class<D> aDependency, Function<D, T> aFactory) {
        this._factory = new Factory<D, T>(aDependency, aFactory);
    }

    @Override
    public <D> void setFactory(Class<D> aDependency, Function<D, T> aFactory, String aAlias) {
        this._factory = new Factory<D, T>(aDependency, aFactory, aAlias);
    }

    public void setAlias(String aAlias) {
        this._alias = aAlias;
    }

    @Override
    public void setInstance(T aInstance) {
        super.setInstance(aInstance);
    }

    @Override
    public void setInstanceMetrics(InstanceMetrics aInstanceMetrics) {
        this._instanceMetrics = aInstanceMetrics;
    }

    @Override
    public void setInstanceMetrics(InstanceMode aInstanceMode) {
        this._instanceMetrics = aInstanceMode;
    }

    @Override
    public void setProfiles(Object[] aProfiles) {
        aProfiles = aProfiles != null ? aProfiles : new Object[]{};
        this._profiles = new HashSet<Object>(Arrays.asList(aProfiles));
    }

    @Override
    public void setProfiles(Collection<?> aProfiles) {
        this._profiles = new HashSet(aProfiles);
    }

    @Override
    public void setTags(Object[] aTags) {
        aTags = aTags != null ? aTags : new Object[]{};
        this._tags = new HashSet<Object>(Arrays.asList(aTags));
    }

    @Override
    public void setTags(Collection<?> aTags) {
        this._tags = new HashSet(aTags);
    }

    @Override
    public void setClaims(Claim[] aClaims) {
        aClaims = aClaims != null ? aClaims : new Claim[]{};
        this._claims = new HashSet<Claim>(Arrays.asList(aClaims));
    }

    @Override
    public void setClaims(Collection<Claim> aClaims) {
        this._claims = new HashSet<Claim>(aClaims);
    }

    public void setType(Class<T> aType) {
        if (aType == null) {
            throw new IllegalArgumentException("The provided type must not(!) be null!");
        }
        this._type = aType;
        if (this._alias == null && this._alias.length() == 0) {
            this._alias = CaseStyleBuilder.asCamelCase((String)this._type.getSimpleName());
        }
    }

    @Override
    public DependencyBuilder<T> withAddClaim(Claim aClaim) {
        this.addClaim(aClaim);
        return this;
    }

    @Override
    public DependencyBuilder<T> withAddClaim(String aAlias) {
        this.addClaim(new Claim(aAlias));
        return this;
    }

    @Override
    public DependencyBuilder<T> withAddClaim(Class<?> aType) {
        this.addClaim(new Claim(aType));
        return this;
    }

    @Override
    public DependencyBuilder<T> withAddClaim(Class<?> aType, String aAlias) {
        this.addClaim(new Claim(aType, aAlias));
        return this;
    }

    @Override
    public DependencyBuilder<T> withAddProfile(Object aProfile) {
        this._profiles.add(aProfile);
        return this;
    }

    @Override
    public DependencyBuilder<T> withAddTag(Object aTag) {
        this._tags.add(aTag);
        return this;
    }

    public DependencyBuilder<T> withAlias(String aAlias) {
        this.setAlias(aAlias);
        return this;
    }

    public DependencyBuilder<T> withInstance(T aInstance) {
        this.setInstance(aInstance);
        return this;
    }

    @Override
    public DependencyBuilder<T> withInstanceMetrics(InstanceMetrics aInstanceMetrics) {
        this.setInstanceMetrics(aInstanceMetrics);
        return this;
    }

    @Override
    public DependencyBuilder<T> withInstanceMetrics(InstanceMode aInstanceMode) {
        this.setInstanceMetrics(aInstanceMode);
        return this;
    }

    @Override
    public DependencyBuilder<T> withProfiles(Collection<?> aProfiles) {
        this.setProfiles(aProfiles);
        return this;
    }

    @Override
    public DependencyBuilder<T> withProfiles(Object ... aProfiles) {
        this.setProfiles(aProfiles);
        return this;
    }

    @Override
    public DependencyBuilder<T> withTags(Collection<?> aTags) {
        this.setTags(aTags);
        return this;
    }

    @Override
    public DependencyBuilder<T> withTags(Object ... aTags) {
        this.setTags(aTags);
        return this;
    }

    @Override
    public DependencyBuilder<T> withClaims(Collection<Claim> aClaims) {
        this.setClaims(aClaims);
        return this;
    }

    @Override
    public DependencyBuilder<T> withClaims(Claim ... aClaims) {
        this.setClaims(aClaims);
        return this;
    }

    public DependencyBuilder<T> withType(Class<T> aType) {
        this.setType(aType);
        return this;
    }

    @Override
    public <D> DependencyBuilder<T> withSetup(Setup<D, T> aSetup) {
        this.setSetup(aSetup);
        return this;
    }

    @Override
    public <D> DependencyBuilder<T> withSetup(Class<D> aDependency, BiFunction<T, D, T> aInitializer) {
        this.setSetup(aDependency, aInitializer);
        return this;
    }

    @Override
    public <D> DependencyBuilder<T> withSetup(Class<D> aDependency, BiFunction<T, D, T> aInitializer, String aAlias) {
        this.setSetup(aDependency, aInitializer, aAlias);
        return this;
    }

    @Override
    public <D> DependencyBuilder<T> withFactory(Factory<D, T> aFactory) {
        this.setFactory(aFactory);
        return this;
    }

    @Override
    public <D> DependencyBuilder<T> withFactory(Class<D> aDependency, Function<D, T> aFactory) {
        this.setFactory(aDependency, aFactory);
        return this;
    }

    @Override
    public <D> DependencyBuilder<T> withFactory(Class<D> aDependency, Function<D, T> aFactory, String aAlias) {
        this.setFactory(aDependency, aFactory, aAlias);
        return this;
    }
}

