/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.data.Delimiter;
import org.refcodes.decoupling.Alias;
import org.refcodes.decoupling.AmbigousClaimException;
import org.refcodes.decoupling.AmbigousDependencyException;
import org.refcodes.decoupling.AmbigousFactoryException;
import org.refcodes.decoupling.AmbigousSetupException;
import org.refcodes.decoupling.CircularDependencyException;
import org.refcodes.decoupling.Claim;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencyBuilder;
import org.refcodes.decoupling.DependencyInstanciationException;
import org.refcodes.decoupling.DependencySchema;
import org.refcodes.decoupling.Factory;
import org.refcodes.decoupling.InstallDependencyException;
import org.refcodes.decoupling.InstanceMetrics;
import org.refcodes.decoupling.InstanceMode;
import org.refcodes.decoupling.Setup;
import org.refcodes.decoupling.UnsatisfiedDependencyException;
import org.refcodes.mixin.Schema;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class DependencyImpl<T>
implements Dependency<T> {
    private static final InstanceMetrics DEFAULT_INSTANCE_MODE = InstanceMode.SINGLETON_IS_MANDATORY;
    private static Logger LOGGER = Logger.getLogger(Dependency.class.getName());
    private Constructor<?> _constructor;
    private T _dangling;
    private boolean _isSetupSingletonFromInstance = false;
    protected T _singleton = null;
    protected String _alias;
    protected Set<Claim> _claims = new HashSet<Claim>();
    protected Dependency<?>[] _dependencies;
    protected InstanceMetrics _instanceMetrics;
    protected Set<T> _instances = new HashSet<T>();
    protected Set<Object> _profiles;
    protected Set<Object> _tags;
    protected Class<T> _type;
    protected Setup<?, T> _setup;
    protected Factory<?, T> _factory;

    protected DependencyImpl() {
    }

    DependencyImpl(DependencyBuilder<T> aDependency) {
        this(aDependency.getType(), aDependency.getInstance(), aDependency.getInstanceMetrics(), aDependency.getAlias(), aDependency.getTags(), aDependency.getProfiles(), aDependency.getClaims(), aDependency.getSetup(), aDependency.getFactory());
    }

    DependencyImpl(Class<T> aType) {
        this(aType, null, null, (String)null, (Collection<Object>)null, (Collection<Object>)null, null, (Setup)null, (Factory)null);
    }

    DependencyImpl(T aInstance) {
        this((Class)null, aInstance, (InstanceMetrics)null, (String)null, (Collection<Object>)null, (Collection<Object>)null, null, (Setup)null, (Factory)null);
    }

    private DependencyImpl(Class<T> aType, T aInstance, InstanceMetrics aInstanceMetrics, String aAlias, Object[] aTags, Object[] aProfiles, Claim[] aClaims, Setup<?, T> aSetup, Factory<?, T> aFactory) {
        this(aType, aInstance, aInstanceMetrics, aAlias, aTags != null && aTags.length != 0 ? Arrays.asList(aTags) : null, aProfiles != null && aProfiles.length != 0 ? Arrays.asList(aProfiles) : null, aClaims != null && aClaims.length != 0 ? Arrays.asList(aClaims) : null, aSetup, aFactory);
    }

    private DependencyImpl(Class<T> aType, T aInstance, InstanceMetrics aInstanceMetrics, String aAlias, Collection<Object> aTags, Collection<Object> aProfiles, Collection<Claim> aClaims, Setup<?, T> aSetup, Factory<?, T> aFactory) {
        this._type = aInstance != null && aType == null ? aInstance.getClass() : aType;
        this._alias = aAlias == null || aAlias.length() == 0 ? CaseStyleBuilder.asCamelCase((String)DependencyImpl.toAlias(this._type)) : aAlias;
        this._tags = aTags != null && aTags.size() != 0 ? new HashSet<Object>(aTags) : new HashSet<Object>();
        this._profiles = aProfiles != null && aProfiles.size() != 0 ? new HashSet<Object>(aProfiles) : new HashSet<Object>();
        this._instanceMetrics = aInstanceMetrics != null ? aInstanceMetrics : DEFAULT_INSTANCE_MODE;
        this._claims = aClaims != null && aClaims.size() != 0 ? new HashSet<Claim>(aClaims) : new HashSet<Claim>();
        this._setup = aSetup;
        this._factory = aFactory;
        if (aInstance == null && aType == null) {
            throw new IllegalArgumentException("At least an <instance> or a <type> must be provided, but neither a <type> nor  an <instance> has been provided!");
        }
        if (aInstance != null && aFactory != null) {
            throw new IllegalArgumentException("Either an <instance> or a <factory> must be provided, but not an instance <" + aInstance + "> and a factory <" + aFactory + "> at the same time!");
        }
        if (aInstance != null) {
            this._instances.add(aInstance);
            if (this._instanceMetrics.isSingleton() && this._instanceMetrics.isMandatory()) {
                this._singleton = aInstance;
                this._isSetupSingletonFromInstance = true;
            } else {
                throw new IllegalArgumentException("The instance <" + aInstance + "> may only be provided in case the dependency <" + this + "> instance metrics denotes singleton!");
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyImpl other = (DependencyImpl)obj;
        return Objects.equals(this._alias, other._alias) && Objects.equals(this._profiles, other._profiles) && Objects.equals(this._tags, other._tags) && Objects.equals(this._type, other._type);
    }

    public String getAlias() {
        return this._alias;
    }

    @Override
    public Claim[] getClaims() {
        return this._claims.toArray(new Claim[this._claims.size()]);
    }

    @Override
    public Setup<?, T> getSetup() {
        return this._setup;
    }

    @Override
    public Factory<?, T> getFactory() {
        return this._factory;
    }

    @Override
    public InstanceMetrics getInstanceMetrics() {
        return this._instanceMetrics;
    }

    @Override
    public T[] getInstances() {
        return this._instances.toArray((Object[])Array.newInstance(this._type, this._instances.size()));
    }

    @Override
    public Object[] getProfiles() {
        return this._profiles.toArray();
    }

    @Override
    public Object[] getTags() {
        if (this._tags == null) {
            this._tags = new HashSet<Object>();
        }
        return this._tags.toArray();
    }

    public Class<T> getType() {
        return this._type;
    }

    public int hashCode() {
        return Objects.hash(this._alias, this._profiles, this._tags, this._type);
    }

    @Override
    public boolean hasInstance() {
        return !this._instances.isEmpty();
    }

    @Override
    public T toInstance() throws DependencyInstanciationException {
        if (this._singleton != null) {
            return this._singleton;
        }
        Object[] theArgs = new Object[this._dependencies.length];
        for (int i = 0; i < this._dependencies.length; ++i) {
            theArgs[i] = this._dependencies[i].toInstance();
        }
        try {
            Object theInstance = this._constructor.newInstance(theArgs);
            if (this._instanceMetrics.isSingleton()) {
                this._singleton = theInstance;
                this._isSetupSingletonFromInstance = true;
            }
            this._instances.add(theInstance);
            return (T)theInstance;
        }
        catch (Exception e) {
            throw new DependencyInstanciationException(this, this._dependencies, "Cannot instanciate dependency <" + this + "> using provided dependencies <" + VerboseTextBuilder.asString((Object[])this._dependencies) + ">: " + e.getMessage(), e);
        }
    }

    @Override
    public DependencySchema toSchema() {
        DependencySchema[] theSchemas = null;
        if (this._dependencies != null && this._dependencies.length != 0) {
            theSchemas = new DependencySchema[this._dependencies.length];
            for (int i = 0; i < theSchemas.length; ++i) {
                theSchemas[i] = this._dependencies[i].toSchema();
            }
        }
        Object theDescription = "";
        theDescription = this._instanceMetrics != null ? (this._instanceMetrics.isSingleton() ? (String)theDescription + "Singleton" : (String)theDescription + "Non-Singleton") : (String)theDescription + "Undefined";
        theDescription = (String)theDescription + " dependency";
        theDescription = this._type != null ? (String)theDescription + " of type <" + DependencyImpl.toAlias(this._type) + ">" : (String)theDescription + " of unspecified type";
        theDescription = (String)theDescription + ".";
        return new DependencySchema(this, (String)theDescription, (Schema[])theSchemas);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", tags=" + this._tags + ", profiles=" + this._profiles + ", type=" + this._type + ", instances=" + this._instances + ", instanceMetrics=" + this._instanceMetrics + "]";
    }

    protected void setInstance(T aInstance) {
        if (aInstance == null) {
            throw new IllegalArgumentException("The provided instance must not(!) be null!");
        }
        this._singleton = null;
        this._instances.clear();
        if (aInstance != null) {
            this._instances.add(aInstance);
        }
        if (this._instanceMetrics.isSingleton()) {
            this._singleton = aInstance;
            this._isSetupSingletonFromInstance = true;
        }
        if (this._type == null) {
            this._type = aInstance.getClass();
        }
        if (this._alias == null && this._alias.length() == 0) {
            this._alias = CaseStyleBuilder.asCamelCase((String)DependencyImpl.toAlias(this._type));
        }
    }

    protected T toInstance(Dependency<?>[] aDependencies) throws CircularDependencyException, AmbigousDependencyException, UnsatisfiedDependencyException, AmbigousClaimException, AmbigousSetupException, AmbigousFactoryException, InstallDependencyException {
        return this.toInstance(aDependencies, new HashSet());
    }

    protected T toInstance(Dependency<?>[] aDependencies, Set<Dependency<?>> aVistedDependencies) throws CircularDependencyException, AmbigousDependencyException, UnsatisfiedDependencyException, AmbigousClaimException, AmbigousSetupException, AmbigousFactoryException, InstallDependencyException {
        DependencyImpl theDependency;
        Object theInstance;
        block19: {
            if (!aVistedDependencies.add(this) && this._instances.isEmpty()) {
                throw new CircularDependencyException(this, aVistedDependencies.toArray(new Dependency[aVistedDependencies.size()]), "A circular dependency between this dependency <" + this + "> and one or more dependencies <" + VerboseTextBuilder.asString(aVistedDependencies) + "> has been detected, unable to resolve conflict (you may contribute and add some proxy mechanism here)!");
            }
            if (this._dangling != null) {
                return this._dangling;
            }
            theInstance = null;
            if (this._singleton != null) {
                if (!this._isSetupSingletonFromInstance) {
                    return this._singleton;
                }
                theInstance = this._singleton;
            } else if (this._factory != null) {
                theDependency = (DependencyImpl)this.toMatchingDependencyByClaim(this._factory, aDependencies);
                T theFactory = theDependency.toInstance(aDependencies, aVistedDependencies);
                theInstance = this._factory.toInstance(theFactory);
            } else {
                Dependency<?>[] theDependencies = this.toMatchingDependenciesByClaims(aDependencies);
                Constructor<?>[] theCtors = this.toSuitableConstructors(theDependencies);
                ArrayList<DependencyImpl> eCtorDependencies = new ArrayList<DependencyImpl>();
                ArrayList<T> eCtorArgs = new ArrayList<T>();
                CircularDependencyException theCircularDependencyException = null;
                InstallDependencyException theInstallDependencyException = null;
                for (Constructor<?> eCtor : theCtors) {
                    try {
                        for (Parameter eParam : eCtor.getParameters()) {
                            DependencyImpl eParamDependency = (DependencyImpl)this.toDependencyMatch(eParam.getType(), this.toParamAlias(eParam), theDependencies);
                            eCtorArgs.add(eParamDependency.toInstance(aDependencies, aVistedDependencies));
                            eCtorDependencies.add(eParamDependency);
                        }
                        theInstance = eCtor.newInstance(eCtorArgs.toArray());
                        theInstance = this.toPostProcessed(theInstance);
                        for (DependencyImpl eDependency : eCtorDependencies) {
                            eDependency._dangling = null;
                        }
                        this._dependencies = eCtorDependencies.toArray(new Dependency[eCtorDependencies.size()]);
                        this._constructor = eCtor;
                        break block19;
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException | CircularDependencyException e) {
                        if (e instanceof CircularDependencyException) {
                            theCircularDependencyException = (CircularDependencyException)e;
                        } else {
                            theInstallDependencyException = new InstallDependencyException(this, "Cannot install dependency <" + this + "> as of: " + ((Throwable)e).getMessage(), (Throwable)e);
                        }
                        LOGGER.log(Level.INFO, "Skipping dependnecy's <" + this + "> constructor with parameters <" + VerboseTextBuilder.asString((Object[])eCtor.getParameters()) + "> as of: " + ((Throwable)e).getMessage());
                        eCtorDependencies.clear();
                        eCtorArgs.clear();
                    }
                }
                if (theCircularDependencyException != null) {
                    throw theCircularDependencyException;
                }
                if (theInstallDependencyException != null) {
                    throw theInstallDependencyException;
                }
                throw new UnsatisfiedDependencyException(this, aDependencies, "Cannot satisfy all required dependencies for dependency <" + this + "> for its constructors!");
            }
        }
        if (!this._instanceMetrics.isSingleton()) {
            this._dangling = theInstance;
        }
        if (this._setup != null && (this._singleton == null || this._isSetupSingletonFromInstance)) {
            theDependency = (DependencyImpl)this.toMatchingDependencyByClaim(this._setup, aDependencies);
            T theSetup = theDependency.toInstance(aDependencies, aVistedDependencies);
            theInstance = this._setup.toInstance(theSetup, theInstance);
            this._isSetupSingletonFromInstance = false;
        }
        if (this._instanceMetrics.isSingleton() && this._singleton == null) {
            this._singleton = theInstance;
        }
        this._instances.add(theInstance);
        return theInstance;
    }

    protected T toPostProcessed(T aInstance) {
        return aInstance;
    }

    Constructor<?>[] toSuitableConstructors(Dependency<?>[] aDependencies) throws AmbigousDependencyException, UnsatisfiedDependencyException {
        Constructor<?>[] aConstructors = this.getType().getConstructors();
        ArrayList theCtors = new ArrayList();
        block0: for (Constructor<?> eCtr : aConstructors) {
            for (Parameter eParam : eCtr.getParameters()) {
                if (!this.hasDependencyMatch(eParam.getType(), this.toParamAlias(eParam), aDependencies)) continue block0;
            }
            theCtors.add(eCtr);
        }
        if (theCtors.size() == 0) {
            throw new UnsatisfiedDependencyException(this, aDependencies, "Cannot find suitable constructor for dependency <" + this + "> as none constructor matches the provided dependencies <" + VerboseTextBuilder.asString((Object[])aDependencies) + ">!");
        }
        return this.toOrderedConstructors(theCtors);
    }

    private boolean hasDependencyMatch(Class<?> aType, String aAlias, Dependency<?>[] aDependencies) throws AmbigousDependencyException {
        Set<Dependency<?>> theDependencies = this.toMatchingDependencies(aType, aAlias, aDependencies);
        if (theDependencies.size() > 1) {
            throw new AmbigousDependencyException(this, theDependencies.toArray(new Dependency[theDependencies.size()]), "There are <" + theDependencies.size() + "> dependencies matching the type <" + aType.getName() + "> required by the dependency<" + this + ">: " + VerboseTextBuilder.asString(theDependencies));
        }
        return theDependencies.size() == 1;
    }

    private boolean hasTagMatchWithDependency(Dependency<?> aDependency) {
        Object[] theTagsA = this.getTags();
        Object[] theTagsB = aDependency.getTags();
        if (!(theTagsA != null && theTagsA.length != 0 || theTagsB != null && theTagsB.length != 0)) {
            return true;
        }
        if (theTagsA != null && theTagsA.length != 0 && (theTagsB == null || theTagsB.length == 0)) {
            return false;
        }
        if ((theTagsA == null || theTagsA.length == 0) && theTagsB != null && theTagsB.length != 0) {
            return false;
        }
        for (Object eObjA : theTagsA) {
            for (Object eObjB : theTagsB) {
                if (!eObjA.toString().equalsIgnoreCase(eObjB.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private Dependency<?> toDependencyMatch(Class<?> aType, String aAlias, Dependency<?>[] aDependencies) throws AmbigousDependencyException, UnsatisfiedDependencyException {
        Set<Dependency<?>> theDependencies = this.toMatchingDependencies(aType, aAlias, aDependencies);
        if (theDependencies.size() > 1) {
            throw new AmbigousDependencyException(this, theDependencies.toArray(new Dependency[theDependencies.size()]), "There are <" + theDependencies.size() + "> dependencies matching the type <" + aType.getName() + "> required by the dependency<" + this + ">: " + VerboseTextBuilder.asString(theDependencies));
        }
        if (theDependencies.isEmpty()) {
            throw new UnsatisfiedDependencyException(this, aDependencies, "There are no dependencies matching the type <" + aType.getName() + "> required by the dependency<" + this + ">: " + VerboseTextBuilder.asString((Object[])aDependencies));
        }
        return theDependencies.iterator().next();
    }

    private Set<Dependency<?>> toMatchingAmbigousDependenciesByAlias(Set<Dependency<?>> aDependencies, String aAlias) {
        if (aAlias == null || aAlias.length() == 0) {
            return aDependencies;
        }
        HashSet theAmbigousDependencies = new HashSet(aDependencies);
        Iterator<Dependency<?>> e = aDependencies.iterator();
        while (e.hasNext()) {
            if (e.next().getAlias().equalsIgnoreCase(aAlias)) continue;
            e.remove();
        }
        if (aDependencies.size() == 0) {
            return theAmbigousDependencies;
        }
        return aDependencies;
    }

    private Dependency<?> toMatchingDependencyByClaim(Claim aClaim, Dependency<?>[] aDependencies) throws AmbigousSetupException, AmbigousFactoryException, AmbigousClaimException {
        Dependency<?> theClaim = null;
        if (aClaim != null) {
            for (Dependency<?> eDependency : aDependencies) {
                if (!aClaim.isClaim(eDependency)) continue;
                if (theClaim != null) {
                    if (aClaim instanceof Setup) {
                        throw new AmbigousSetupException(this, (Setup)aClaim, aDependencies, "The setup (claim) <" + aClaim + "> can be satisfied by more than one <" + theClaim + "> dependency <" + eDependency + ">: " + VerboseTextBuilder.asString((Object[])aDependencies));
                    }
                    if (aClaim instanceof Factory) {
                        throw new AmbigousFactoryException(this, (Factory)aClaim, aDependencies, "The factory (claim) <" + aClaim + "> can be satisfied by more than one <" + theClaim + "> dependency <" + eDependency + ">: " + VerboseTextBuilder.asString((Object[])aDependencies));
                    }
                    throw new AmbigousClaimException(this, aClaim, aDependencies, "The claim <" + aClaim + "> can be satisfied by more than one <" + theClaim + "> dependency <" + eDependency + ">: " + VerboseTextBuilder.asString((Object[])aDependencies));
                }
                theClaim = eDependency;
            }
        }
        return theClaim;
    }

    private Dependency<?>[] toMatchingDependenciesByClaims(Dependency<?>[] aDependencies) throws AmbigousClaimException {
        HashSet theClaims = new HashSet();
        for (Claim eClaim : this._claims) {
            boolean hasClaim = false;
            for (Dependency<?> eDependency : aDependencies) {
                if (!eClaim.isClaim(eDependency)) continue;
                if (hasClaim) {
                    throw new AmbigousClaimException(this, eClaim, aDependencies, "The claim <" + eClaim + "> can be satisfied by more than one <" + eClaim + "> dependency <" + eDependency + ">: " + VerboseTextBuilder.asString((Object[])aDependencies));
                }
                theClaims.add(eDependency);
                hasClaim = true;
            }
        }
        HashSet theDependencies = new HashSet(Arrays.asList(aDependencies));
        Iterator e = theDependencies.iterator();
        while (e.hasNext()) {
            Dependency eDependency = (Dependency)e.next();
            for (Dependency dependency : theClaims) {
                if (dependency == eDependency || !dependency.getType().isAssignableFrom(eDependency.getType())) continue;
                e.remove();
            }
        }
        return theDependencies.toArray(new Dependency[theDependencies.size()]);
    }

    private Set<Dependency<?>> toMatchingAmbigousDependenciesByTag(Set<Dependency<?>> aDependencies) {
        HashSet theAmbigousDependencies = new HashSet(aDependencies);
        Iterator<Dependency<?>> e = aDependencies.iterator();
        while (e.hasNext()) {
            if (this.hasTagMatchWithDependency(e.next())) continue;
            e.remove();
        }
        if (aDependencies.size() == 0) {
            return theAmbigousDependencies;
        }
        return aDependencies;
    }

    private Set<Dependency<?>> toMatchingDependencies(Class<?> aType, String aAlias, Dependency<?>[] aDependencies) {
        Set<Dependency<?>> theDependencies = this.toMatchingDependenciesByType(aType, aDependencies);
        if (theDependencies.size() > 1) {
            theDependencies = this.toMatchingAmbigousDependenciesByTag(theDependencies);
        }
        if (theDependencies.size() > 1) {
            theDependencies = this.toMatchingAmbigousDependenciesByAlias(theDependencies, aAlias);
        }
        return theDependencies;
    }

    private Set<Dependency<?>> toMatchingDependenciesByType(Class<?> aType, Dependency<?>[] aDependencies) {
        HashSet theDependencies = new HashSet();
        for (Dependency<?> eDependency : aDependencies) {
            if (eDependency == this || !aType.isAssignableFrom(eDependency.getType())) continue;
            theDependencies.add(eDependency);
        }
        return theDependencies;
    }

    private Constructor<?>[] toOrderedConstructors(List<Constructor<?>> aCtors) {
        Constructor[] theResult = new Constructor[aCtors.size()];
        for (int i = 0; i < theResult.length; ++i) {
            Constructor<?> maxCtor = null;
            for (Constructor<?> eCtor : aCtors) {
                if (maxCtor != null && maxCtor.getParameters().length >= eCtor.getParameters().length) continue;
                maxCtor = eCtor;
            }
            aCtors.remove(maxCtor);
            theResult[i] = maxCtor;
        }
        return theResult;
    }

    private String toParamAlias(Parameter aParam) {
        Alias theAlias = aParam.getAnnotation(Alias.class);
        if (theAlias != null) {
            return theAlias.value();
        }
        return aParam.getName();
    }

    private static String toAlias(Class<?> aType) {
        Object theAlias = null;
        if (aType != null) {
            theAlias = aType.getSimpleName();
            while ((aType = aType.getEnclosingClass()) != null) {
                theAlias = aType.getSimpleName() + Delimiter.INNER_CLASS.getChar() + (String)theAlias;
            }
        }
        return theAlias;
    }
}

