/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import org.refcodes.decoupling.Dependency;
import org.refcodes.mixin.AbstractSchema;
import org.refcodes.mixin.CommentAccessor;
import org.refcodes.mixin.Schema;
import org.refcodes.mixin.SizeAccessor;

public class DependencySchema
extends AbstractSchema
implements CommentAccessor,
SizeAccessor {
    private static final long serialVersionUID = 1L;
    public static final String MANDATORY = "MANDATORY";
    public static final String SINGLETON = "SINGLETON";
    public static final String TAGS = "TAGS";
    public static final String PROFILES = "PROFILES";
    public static final String SETUP = "SETUP";
    public static final String FACTORY = "FACTORY";
    public static final String INSTANCES = "INSTANCES";
    public static final String COMMENT = "COMMENT";
    public static final String DEPENDENCY = "DEPENDENCY";
    public static final String SIZE = "SIZE";

    public DependencySchema(Class<?> aType, String aDescription, Schema ... aChildren) {
        super(aType, aDescription, aChildren);
    }

    public DependencySchema(String aAlias, Class<?> aType, String aDescription, Schema ... aChildren) {
        super(aAlias, aType, aDescription, aChildren);
    }

    public DependencySchema(Dependency<?> aDependency, String aDescription, Schema ... aChildren) {
        super(aDependency.getAlias(), aDependency.getClass(), aDescription, aChildren);
        int i;
        if (aDependency.getInstanceMetrics() != null) {
            this.put(MANDATORY, aDependency.getInstanceMetrics().isMandatory());
            this.put(SINGLETON, aDependency.getInstanceMetrics().isSingleton());
        }
        if (aDependency.getTags() != null && aDependency.getTags().length != 0) {
            String[] theTags = new String[aDependency.getTags().length];
            for (i = 0; i < aDependency.getTags().length; ++i) {
                theTags[i] = aDependency.getTags()[i] != null ? aDependency.getTags()[i].toString() : null;
            }
            this.put(TAGS, theTags);
        }
        if (aDependency.getProfiles() != null && aDependency.getProfiles().length != 0) {
            String[] theProfiles = new String[aDependency.getProfiles().length];
            for (i = 0; i < aDependency.getProfiles().length; ++i) {
                theProfiles[i] = aDependency.getProfiles()[i] != null ? aDependency.getProfiles()[i].toString() : null;
            }
            this.put(PROFILES, theProfiles);
        }
        if (aDependency.getInstances() != null && aDependency.getInstances().length != 0) {
            String[] theInstances = new String[aDependency.getInstances().length];
            for (i = 0; i < aDependency.getInstances().length; ++i) {
                theInstances[i] = aDependency.getInstances()[i] != null ? aDependency.getInstances()[i].toString() : null;
            }
            this.put(INSTANCES, theInstances);
        }
        if (aDependency.getFactory() != null) {
            this.put(FACTORY, aDependency.getFactory());
        }
        if (aDependency.getSetup() != null) {
            this.put(SETUP, aDependency.getSetup());
        }
        this.put(SIZE, aDependency.getInstances().length);
        this.put(DEPENDENCY, aDependency.getType());
        this.put(COMMENT, aDependency.toString());
    }

    public String getComment() {
        return (String)this.get(COMMENT);
    }

    public int getSize() {
        Integer theSize = (Integer)this.get(SIZE);
        return theSize != null ? theSize : -1;
    }
}

