/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.decoupling.AmbigousClaimException;
import org.refcodes.decoupling.AmbigousDependencyException;
import org.refcodes.decoupling.AmbigousFactoryException;
import org.refcodes.decoupling.AmbigousSetupException;
import org.refcodes.decoupling.CircularDependencyException;
import org.refcodes.decoupling.Claim;
import org.refcodes.decoupling.Context;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencyBuilder;
import org.refcodes.decoupling.DependencyBuilderImpl;
import org.refcodes.decoupling.DependencyImpl;
import org.refcodes.decoupling.DuplicateClaimException;
import org.refcodes.decoupling.DuplicateDependencyException;
import org.refcodes.decoupling.Factory;
import org.refcodes.decoupling.InstallDependencyException;
import org.refcodes.decoupling.InstanceMode;
import org.refcodes.decoupling.Setup;
import org.refcodes.decoupling.UnsatisfiedClaimException;
import org.refcodes.decoupling.UnsatisfiedDependencyException;
import org.refcodes.decoupling.UnsatisfiedFactoryException;
import org.refcodes.decoupling.UnsatisfiedSetupException;
import org.refcodes.textual.VerboseTextBuilder;

public class Reactor {
    protected List<DependencyBuilder<?>> _dependencies = new ArrayList();

    public <T> DependencyBuilder<T> addDependency(Class<T> aType) {
        DependencyBuilderImpl<Class<T>> theBuilder = new DependencyBuilderImpl<Class<T>>(aType);
        this._dependencies.add(theBuilder);
        return theBuilder;
    }

    public <T> DependencyBuilder<T> addDependency(T aInstance) {
        DependencyBuilder<T> theBuilder = new DependencyBuilderImpl<T>(aInstance).withInstanceMetrics(InstanceMode.SINGLETON_IS_MANDATORY);
        this._dependencies.add(theBuilder);
        return theBuilder;
    }

    public Context createContext() throws AmbigousDependencyException, UnsatisfiedDependencyException, CircularDependencyException, DuplicateDependencyException, DuplicateClaimException, UnsatisfiedClaimException, AmbigousClaimException, AmbigousSetupException, UnsatisfiedSetupException, AmbigousFactoryException, UnsatisfiedFactoryException, InstallDependencyException {
        return this.createContext(new Object[0]);
    }

    public Context createContext(String ... aProfiles) throws AmbigousDependencyException, UnsatisfiedDependencyException, CircularDependencyException, DuplicateDependencyException, DuplicateClaimException, UnsatisfiedClaimException, AmbigousClaimException, AmbigousSetupException, UnsatisfiedSetupException, AmbigousFactoryException, UnsatisfiedFactoryException, InstallDependencyException {
        return this.createContext((Object[])aProfiles);
    }

    public Context createContext(Object ... aProfiles) throws AmbigousDependencyException, UnsatisfiedDependencyException, CircularDependencyException, DuplicateDependencyException, DuplicateClaimException, UnsatisfiedClaimException, AmbigousClaimException, AmbigousSetupException, UnsatisfiedSetupException, AmbigousFactoryException, UnsatisfiedFactoryException, InstallDependencyException {
        Context theCtx = this.toContext(aProfiles);
        Object[] theDependencies = this.toDependencies(aProfiles);
        for (int i = 0; i < theDependencies.length; ++i) {
            Claim[] eClaims = theDependencies[i].getClaims();
            if (theDependencies[i].getSetup() != null) {
                eClaims = Arrays.copyOf(eClaims, eClaims.length + 1);
                eClaims[eClaims.length - 1] = theDependencies[i].getSetup();
            }
            if (theDependencies[i].getFactory() != null) {
                eClaims = Arrays.copyOf(eClaims, eClaims.length + 1);
                eClaims[eClaims.length - 1] = theDependencies[i].getFactory();
            }
            block4: for (int a = 0; a < eClaims.length; ++a) {
                for (int b = a + 1; b < eClaims.length; ++b) {
                    if (b == a || !eClaims[b].equals(eClaims[a])) continue;
                    throw new DuplicateClaimException(theDependencies[i], eClaims[a], eClaims, "An identical claim for type <" + eClaims[a].getType().getSimpleName() + "> in dependency <" + theDependencies[i] + "> already exists (" + eClaims[a] + ")!");
                }
                for (DependencyImpl<?> dependencyImpl : theDependencies) {
                    if (dependencyImpl != theDependencies[i] && eClaims[a].isClaim(dependencyImpl)) continue block4;
                }
                if (eClaims[a] instanceof Setup) {
                    throw new UnsatisfiedSetupException((Dependency<?>)theDependencies[i], (Setup<?, ?>)((Setup)eClaims[a]), (Dependency<?>[])theDependencies, "The setup <" + eClaims[a] + "> for dependency <" + theDependencies[i] + "> cannot be satisfied by any of the provided dependencies: " + VerboseTextBuilder.asString((Object[])theDependencies));
                }
                if (eClaims[a] instanceof Factory) {
                    throw new UnsatisfiedFactoryException((Dependency<?>)theDependencies[i], (Factory<?, ?>)((Factory)eClaims[a]), (Dependency<?>[])theDependencies, "The factory <" + eClaims[a] + "> for dependency <" + (DependencyImpl)theDependencies[i] + "> cannot be satisfied by any of the provided dependencies: " + VerboseTextBuilder.asString((Object[])theDependencies));
                }
                throw new UnsatisfiedClaimException((Dependency<?>)theDependencies[i], eClaims[a], (Dependency<?>[])theDependencies, "The claim <" + eClaims[a] + "> for dependency <" + (DependencyImpl)theDependencies[i] + "> cannot be satisfied by any of the provided dependencies: " + VerboseTextBuilder.asString((Object[])theDependencies));
            }
            for (int j = i + 1; j < theDependencies.length; ++j) {
                if (!theDependencies[j].equals(theDependencies[i])) continue;
                throw new DuplicateDependencyException((Dependency<?>)theDependencies[i], (Dependency<?>[])theDependencies, "An identical dependency for type <" + theDependencies[i].getType().getSimpleName() + "> and alias <" + theDependencies[i].getAlias() + "> already exists (" + theDependencies[j] + ")!");
            }
        }
        for (DependencyImpl<?> dependencyImpl : theDependencies) {
            try {
                if (!dependencyImpl.getInstanceMetrics().isMandatory()) continue;
                dependencyImpl.toInstance((Dependency<?>[])theDependencies);
            }
            catch (AmbigousDependencyException e) {
                throw new AmbigousDependencyException(e.getDependency(), e.getDependencies(), e.getMessage(), (Throwable)((Object)e));
            }
            catch (UnsatisfiedDependencyException e) {
                throw new UnsatisfiedDependencyException(e.getDependency(), e.getDependencies(), e.getMessage(), (Throwable)((Object)e));
            }
        }
        theCtx.initialize((Dependency<?>[])theDependencies);
        return theCtx;
    }

    protected Context toContext(Object[] aProfiles) {
        return new Context(aProfiles);
    }

    DependencyImpl<?>[] toDependencies(Object ... aProfiles) {
        ArrayList theDependencies = new ArrayList();
        for (DependencyBuilder<?> eDependency : this._dependencies) {
            if (!this.hasProfile(eDependency, aProfiles)) continue;
            theDependencies.add(new DependencyImpl(eDependency));
        }
        return theDependencies.toArray(new DependencyImpl[theDependencies.size()]);
    }

    boolean hasProfile(Dependency<?> aDependency, Object ... aProfiles) {
        if (aDependency.getProfiles() == null || aDependency.getProfiles().length == 0) {
            return true;
        }
        if (aProfiles == null || aProfiles.length == 0) {
            return false;
        }
        for (Object eProfile : aProfiles) {
            for (Object eDependencyProfile : aDependency.getProfiles()) {
                if (!eProfile.toString().equalsIgnoreCase(eDependencyProfile.toString())) continue;
                return true;
            }
        }
        return false;
    }
}

