// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

import org.refcodes.decoupling.DependencyException.ClaimDependenciesException;

/**
 * The {@link AmbigousClaimException} is thrown in case one {@link Claim}
 * instance can be matched by multiple dependencies.
 */
public class AmbigousClaimException extends ClaimDependenciesException {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	public AmbigousClaimException( String aMessage, Claim aClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, String aErrorCode ) {
		super( aMessage, aClaim, aDependency, aDependencies, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public AmbigousClaimException( String aMessage, Claim aClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause, String aErrorCode ) {
		super( aMessage, aClaim, aDependency, aDependencies, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public AmbigousClaimException( String aMessage, Claim aClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause ) {
		super( aMessage, aClaim, aDependency, aDependencies, aCause );
	}

	/**
	 * {@inheritDoc}
	 */
	public AmbigousClaimException( String aMessage, Claim aClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies ) {
		super( aMessage, aClaim, aDependency, aDependencies );
	}

	/**
	 * {@inheritDoc}
	 */
	public AmbigousClaimException( Claim aClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause, String aErrorCode ) {
		super( aClaim, aDependency, aDependencies, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public AmbigousClaimException( Claim aClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause ) {
		super( aClaim, aDependency, aDependencies, aCause );
	}
}
