// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

/**
 * The {@link CircularDependencyException} is thrown in case there is some
 * (transitive) circular dependency between two {@link Dependency} declarations.
 */
public class CircularDependencyException extends DependencyInstanciationException {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	public CircularDependencyException( String aMessage, Dependency<?> aDependency, Dependency<?>[] aDependencies, String aErrorCode ) {
		super( aMessage, aDependency, aDependencies, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public CircularDependencyException( String aMessage, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause, String aErrorCode ) {
		super( aMessage, aDependency, aDependencies, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public CircularDependencyException( String aMessage, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause ) {
		super( aMessage, aDependency, aDependencies, aCause );
	}

	/**
	 * {@inheritDoc}
	 */
	public CircularDependencyException( String aMessage, Dependency<?> aDependency, Dependency<?>[] aDependencies ) {
		super( aMessage, aDependency, aDependencies );
	}

	/**
	 * {@inheritDoc}
	 */
	public CircularDependencyException( Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause, String aErrorCode ) {
		super( aDependency, aDependencies, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public CircularDependencyException( Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause ) {
		super( aDependency, aDependencies, aCause );
	}
}
