// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

/**
 * The {@link DependencyInterceptor} is a {@link FunctionalInterface} used to
 * hook into the process of creating instances from a {@link Dependency}
 * declaration: The instance being created can be decorated or enriched with
 * functionality providing means to implement a proxy mechanism or a decorator.
 * A {@link DependencyInterceptor} is registered with a {@link Reactor}.
 */
@FunctionalInterface
public interface DependencyInterceptor {

	/**
	 * Called by the {@link Reactor} for all registered
	 * {@link DependencyInterceptor} instances upon invoking the
	 * {@link Reactor#createContext() } (or the like) methods (this is the
	 * moment when the {@link Reactor} created the {@link Dependency}
	 * declarations' types). Any instance being created is passed through this
	 * method.
	 * 
	 * @param aInstance The instance created by the {@link Dependency}
	 *        declaration.
	 * @param aDependency The {@link Dependency} declaration used for crating
	 *        instances.
	 * 
	 * @return The dependency as of this {@link #intercept(Object, Dependency)}
	 *         method's processing.
	 */
	Object intercept( Object aInstance, Dependency<?> aDependency );

}
