// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

import org.refcodes.decoupling.DependencyException.DependencyClaimException;

/**
 * The {@link DuplicateClaimException} is thrown in case there are multiple
 * identical claims declared by a {@link Dependency}.
 */
public class DuplicateClaimException extends DependencyClaimException {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	public DuplicateClaimException( String aMessage, Claim aClaim, Claim[] aClaims, Dependency<?> aDependency, String aErrorCode ) {
		super( aMessage, aClaim, aClaims, aDependency, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public DuplicateClaimException( String aMessage, Claim aClaim, Claim[] aClaims, Dependency<?> aDependency, Throwable aCause, String aErrorCode ) {
		super( aMessage, aClaim, aClaims, aDependency, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public DuplicateClaimException( String aMessage, Claim aClaim, Claim[] aClaims, Dependency<?> aDependency, Throwable aCause ) {
		super( aMessage, aClaim, aClaims, aDependency, aCause );
	}

	/**
	 * {@inheritDoc}
	 */
	public DuplicateClaimException( String aMessage, Claim aClaim, Claim[] aClaims, Dependency<?> aDependency ) {
		super( aMessage, aClaim, aClaims, aDependency );
	}

	/**
	 * {@inheritDoc}
	 */
	public DuplicateClaimException( Claim aClaim, Claim[] aClaims, Dependency<?> aDependency, Throwable aCause, String aErrorCode ) {
		super( aClaim, aClaims, aDependency, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public DuplicateClaimException( Claim aClaim, Claim[] aClaims, Dependency<?> aDependency, Throwable aCause ) {
		super( aClaim, aClaims, aDependency, aCause );
	}
}
