// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

/**
 * This exception is thrown when trying to install a {@link Dependency} into the
 * {@link Context}, though installing failed due to the dependency throwing an
 * exception during the process of installing (e.g. instantiation).
 */
public class InstallDependencyException extends DependencyException {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	public InstallDependencyException( String aMessage, Dependency<?> aDependency, String aErrorCode ) {
		super( aMessage, aDependency, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public InstallDependencyException( String aMessage, Dependency<?> aDependency, Throwable aCause, String aErrorCode ) {
		super( aMessage, aDependency, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public InstallDependencyException( String aMessage, Dependency<?> aDependency, Throwable aCause ) {
		super( aMessage, aDependency, aCause );
	}

	/**
	 * {@inheritDoc}
	 */
	public InstallDependencyException( String aMessage, Dependency<?> aDependency ) {
		super( aMessage, aDependency );
	}

	/**
	 * {@inheritDoc}
	 */
	public InstallDependencyException( Dependency<?> aDependency, Throwable aCause, String aErrorCode ) {
		super( aDependency, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public InstallDependencyException( Dependency<?> aDependency, Throwable aCause ) {
		super( aDependency, aCause );
	}
}
