// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany, distributed
// on an "AS IS" BASIS WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, and licen-
// sed under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

/**
 * Provides an accessor for a profiles property.
 */
public interface ProfilesAccessor {

	/**
	 * Retrieves the profiles from the profiles property.
	 * 
	 * @return The profiles stored by the profiles property.
	 */
	Object[] getProfiles();

	/**
	 * Provides a mutator for a profiles property.
	 */
	public interface ProfilesMutator {

		/**
		 * Sets the profiles for the profiles property.
		 * 
		 * @param aProfiles The profiles to be stored by the profiles property.
		 */
		void setProfiles( Object[] aProfiles );
	}

	/**
	 * Provides a builder method for a profiles property returning the builder
	 * for applying multiple build operations.
	 * 
	 * @param <B> The builder to return in order to be able to apply multiple
	 *        build operations.
	 */
	public interface ProfilesBuilder<B extends ProfilesBuilder<B>> {

		/**
		 * Sets the profiles for the profiles property.
		 * 
		 * @param aProfiles The profiles to be stored by the profiles property.
		 * 
		 * @return The builder for applying multiple build operations.
		 */
		B withProfiles( Object... aProfiles );
	}

	/**
	 * Provides a profiles property.
	 */
	public interface ProfilesProperty extends ProfilesAccessor, ProfilesMutator {

		/**
		 * This method stores and passes through the given argument, which is
		 * very useful for builder APIs: Sets the given {@link Object[]}
		 * (setter) as of {@link #setProfiles(Object[])} and returns the very
		 * same value (getter).
		 * 
		 * @param aProfiles The {@link Object[]} to set (via
		 *        {@link #setProfiles(Object[])}).
		 * 
		 * @return Returns the value passed for it to be used in conclusive
		 *         processing steps.
		 */
		default Object[] letProfiles( Object[] aProfiles ) {
			setProfiles( aProfiles );
			return aProfiles;
		}
	}
}
