///////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
///////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
///////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

import org.refcodes.decoupling.DependencyException.FactoryDependenciesException;

/**
 * The {@link UnsatisfiedFactoryException} is thrown in case a
 * {@link FactoryClaim} instance cannot be satisfied by any known
 * {@link Dependency} declaration.
 */
public class UnsatisfiedFactoryException extends FactoryDependenciesException {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedFactoryException( String aMessage, FactoryClaim<?, ?> aFactory, Dependency<?> aDependency, Dependency<?>[] aDependencies, String aErrorCode ) {
		super( aMessage, aFactory, aDependency, aDependencies, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedFactoryException( String aMessage, FactoryClaim<?, ?> aFactory, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause, String aErrorCode ) {
		super( aMessage, aFactory, aDependency, aDependencies, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedFactoryException( String aMessage, FactoryClaim<?, ?> aFactory, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause ) {
		super( aMessage, aFactory, aDependency, aDependencies, aCause );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedFactoryException( String aMessage, FactoryClaim<?, ?> aFactory, Dependency<?> aDependency, Dependency<?>[] aDependencies ) {
		super( aMessage, aFactory, aDependency, aDependencies );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedFactoryException( FactoryClaim<?, ?> aFactory, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause, String aErrorCode ) {
		super( aFactory, aDependency, aDependencies, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedFactoryException( FactoryClaim<?, ?> aFactory, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause ) {
		super( aFactory, aDependency, aDependencies, aCause );
	}
}
