///////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
///////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
///////////////////////////////////////////////////////////////////////////////

package org.refcodes.decoupling;

import org.refcodes.decoupling.DependencyException.InitializerDependenciesException;

/**
 * The {@link UnsatisfiedInitializerException} is thrown in case a
 * {@link InitializerClaim} instance cannot be satisfied by any known
 * {@link Dependency} declaration.
 */
public class UnsatisfiedInitializerException extends InitializerDependenciesException {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedInitializerException( String aMessage, InitializerClaim<?, ?> aInitializerClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, String aErrorCode ) {
		super( aMessage, aInitializerClaim, aDependency, aDependencies, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedInitializerException( String aMessage, InitializerClaim<?, ?> aInitializerClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause, String aErrorCode ) {
		super( aMessage, aInitializerClaim, aDependency, aDependencies, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedInitializerException( String aMessage, InitializerClaim<?, ?> aInitializerClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause ) {
		super( aMessage, aInitializerClaim, aDependency, aDependencies, aCause );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedInitializerException( String aMessage, InitializerClaim<?, ?> aInitializerClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies ) {
		super( aMessage, aInitializerClaim, aDependency, aDependencies );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedInitializerException( InitializerClaim<?, ?> aInitializerClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause, String aErrorCode ) {
		super( aInitializerClaim, aDependency, aDependencies, aCause, aErrorCode );
	}

	/**
	 * {@inheritDoc}
	 */
	public UnsatisfiedInitializerException( InitializerClaim<?, ?> aInitializerClaim, Dependency<?> aDependency, Dependency<?>[] aDependencies, Throwable aCause ) {
		super( aInitializerClaim, aDependency, aDependencies, aCause );
	}
}
