// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

/**
 * This artifact provides a {@link org.refcodes.decoupling.Reactor} for breaking
 * up dependencies between a Java software system's components or modules, which
 * enables them to be developed and tested independently (dependency injection
 * and inversion of control). The {@link org.refcodes.decoupling.Reactor} wires
 * components or modules together to form an interacting application. The
 * {@link org.refcodes.decoupling.Reactor} uses dependency injection and
 * inversion of control, which are two techniques that help achieve decoupling
 * by allowing components to depend on abstractions instead of concrete
 * implementations.
 * 
 * The {@link org.refcodes.decoupling.Reactor} is configured with
 * {@link org.refcodes.decoupling.Dependency} definitions to create a
 * {@link org.refcodes.decoupling.Context} representing the wired dependencies.
 * 
 * <p style="font-style: plain; font-weight: normal; background-color: #f8f8ff;
 * padding: 1.5rem; border-style: solid; border-width: 1pt; border-radius: 10pt;
 * border-color: #cccccc;text-align: center;">
 * Please refer to the <a href=
 * "https://www.metacodes.pro/refcodes/refcodes-decoupling"><strong>refcodes-decoupling:
 * Breaking up dependencies between components</strong></a> documentation for an
 * up-to-date and detailed description on the usage of this artifact.
 * </p>
 */
package org.refcodes.decoupling;
