/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.refcodes.decoupling.DependenciesAccessor;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencySchema;
import org.refcodes.schema.Schemable;

public class Context
implements Schemable,
DependenciesAccessor {
    private Dependency<?>[] _dependencies;
    private final Object[] _profiles;

    protected Context(Object[] aProfiles) {
        this._profiles = aProfiles;
    }

    public Context(Dependency<?>[] aDependencies, Object[] aProfiles) {
        this._dependencies = aDependencies;
        this._profiles = aProfiles;
    }

    public Object[] getProfiles() {
        return this._profiles;
    }

    public Dependency<?>[] getDependencies() {
        return this._dependencies;
    }

    public Dependency<?> getDependencyByInstance(Object aInstance) {
        for (Dependency<?> eDepenendency : this._dependencies) {
            if (!eDepenendency.hasInstance(aInstance)) continue;
            return eDepenendency;
        }
        return null;
    }

    public Dependency<?> getDependencyByAlias(String aAlias) {
        if (aAlias != null) {
            for (Dependency<?> eDependency : this._dependencies) {
                if (!aAlias.equals(eDependency.getAlias())) continue;
                return eDependency;
            }
        }
        return null;
    }

    public <T> Dependency<T>[] getDependenciesByType(Class<T> aType) {
        ArrayList theDependnecies = new ArrayList();
        for (Dependency<?> eDependency : this._dependencies) {
            if (!aType.isAssignableFrom(eDependency.getType())) continue;
            theDependnecies.add(eDependency);
        }
        return theDependnecies.toArray((Dependency[])Array.newInstance(Dependency.class, theDependnecies.size()));
    }

    public Dependency<?>[] getDependenciesByTags(Object ... aTags) {
        ArrayList theDependencies = new ArrayList();
        block0: for (Dependency<?> eDependency : this._dependencies) {
            for (Object eTag : aTags) {
                for (Object eDependencyTag : eDependency.getTags()) {
                    if (!eTag.toString().equalsIgnoreCase(eDependencyTag.toString())) continue;
                    theDependencies.add(eDependency);
                    continue block0;
                }
            }
        }
        return theDependencies.toArray(new Dependency[theDependencies.size()]);
    }

    public Dependency<?>[] getDependenciesByProfiles(Object ... aProfiles) {
        ArrayList theDependencies = new ArrayList();
        block0: for (Dependency<?> eDependency : this._dependencies) {
            for (Object eProfile : aProfiles) {
                for (Object eDependencyProfile : eDependency.getProfiles()) {
                    if (!eProfile.toString().equalsIgnoreCase(eDependencyProfile.toString())) continue;
                    theDependencies.add(eDependency);
                    continue block0;
                }
            }
        }
        return theDependencies.toArray(new Dependency[theDependencies.size()]);
    }

    public Object[] getInstances() {
        ArrayList theInstances = new ArrayList();
        for (Dependency<?> eDependency : this._dependencies) {
            theInstances.addAll(Arrays.asList(eDependency.getInstances()));
        }
        return theInstances.toArray();
    }

    public Object getSingletonByAlias(String aAlias) {
        if (aAlias != null) {
            for (Dependency<?> eDependency : this._dependencies) {
                if (!aAlias.equals(eDependency.getAlias()) || !eDependency.getInstanceMetrics().isSingleton()) continue;
                return eDependency.getInstances() != null && eDependency.getInstances().length != 0 ? eDependency.getInstances()[0] : null;
            }
        }
        return null;
    }

    public <T> T getSingletonByAlias(String aAlias, Class<T> aType) {
        if (aAlias != null) {
            for (Dependency<T> eDependency : this.getDependenciesByType(aType)) {
                if (!aAlias.equals(eDependency.getAlias()) || !eDependency.getInstanceMetrics().isSingleton()) continue;
                return eDependency.getInstances() != null && eDependency.getInstances().length != 0 ? (T)eDependency.getInstances()[0] : null;
            }
        }
        return null;
    }

    public Object[] getInstancesByAlias(String aAlias) {
        if (aAlias != null) {
            for (Dependency<?> eDependency : this._dependencies) {
                if (!aAlias.equals(eDependency.getAlias())) continue;
                return eDependency.getInstances();
            }
        }
        return null;
    }

    public <T> T[] getInstancesByType(Class<T> aType) {
        ArrayList theInstances = new ArrayList();
        for (Dependency<?> eDependency : this._dependencies) {
            if (!aType.isAssignableFrom(eDependency.getType())) continue;
            theInstances.addAll(Arrays.asList(eDependency.getInstances()));
        }
        return theInstances.toArray((Object[])Array.newInstance(aType, theInstances.size()));
    }

    public <T> T getFirstByType(Class<T> aType) {
        T[] theInstances = this.getInstancesByType(aType);
        return theInstances.length > 0 ? (T)theInstances[0] : null;
    }

    public Object[] getInstancesByTags(Object ... aTags) {
        ArrayList theInstances = new ArrayList();
        block0: for (Dependency<?> eDependency : this._dependencies) {
            for (Object eTag : aTags) {
                for (Object eDependencyTag : eDependency.getTags()) {
                    if (!eTag.toString().equalsIgnoreCase(eDependencyTag.toString())) continue;
                    theInstances.addAll(Arrays.asList(eDependency.getInstances()));
                    continue block0;
                }
            }
        }
        return theInstances.toArray();
    }

    public Object[] getInstancesByProfiles(Object ... aProfiles) {
        ArrayList theInstances = new ArrayList();
        block0: for (Dependency<?> eDependency : this._dependencies) {
            for (Object eProfile : aProfiles) {
                for (Object eDependencyProfile : eDependency.getProfiles()) {
                    if (!eProfile.toString().equalsIgnoreCase(eDependencyProfile.toString())) continue;
                    theInstances.addAll(Arrays.asList(eDependency.getInstances()));
                    continue block0;
                }
            }
        }
        return theInstances.toArray();
    }

    public DependencySchema toSchema() {
        DependencySchema[] theSchemas = null;
        if (this._dependencies != null && this._dependencies.length != 0) {
            HashSet theDependnecies = new HashSet();
            LinkedHashSet<DependencySchema> theSet = new LinkedHashSet<DependencySchema>();
            for (Dependency<?> eDependency : this._dependencies) {
                Dependency<?> eFactory;
                if ((eDependency.getInstanceMetrics() != null && eDependency.getInstanceMetrics().isMandatory() || !eDependency.hasInstances()) && theDependnecies.add(eDependency)) {
                    theSet.add(eDependency.toSchema());
                }
                if (eDependency.getFactory() == null || eDependency.getFactory().getAlias() == null || (eFactory = this.getDependencyByAlias(eDependency.getFactory().getAlias())) == null || !theDependnecies.add(eFactory)) continue;
                theSet.add(eFactory.toSchema());
            }
            theSchemas = theSet.toArray(new DependencySchema[theSet.size()]);
        }
        return new DependencySchema(this.getClass(), "Context managing dependencies between modules.", theSchemas);
    }

    void initialize(Dependency<?>[] aDependencies) {
        this._dependencies = aDependencies;
    }
}

