/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.data.Delimiter;
import org.refcodes.decoupling.Alias;
import org.refcodes.decoupling.AmbigousClaimException;
import org.refcodes.decoupling.AmbigousDependencyException;
import org.refcodes.decoupling.AmbigousFactoryException;
import org.refcodes.decoupling.AmbigousInitializerException;
import org.refcodes.decoupling.CircularDependencyException;
import org.refcodes.decoupling.Claim;
import org.refcodes.decoupling.ClaimsAccessor;
import org.refcodes.decoupling.DependencyBuilder;
import org.refcodes.decoupling.DependencyInstanciationException;
import org.refcodes.decoupling.DependencySchema;
import org.refcodes.decoupling.FactoryClaim;
import org.refcodes.decoupling.InitializerClaim;
import org.refcodes.decoupling.InstallDependencyException;
import org.refcodes.decoupling.InstanceMetrics;
import org.refcodes.decoupling.InstanceMetricsAccessor;
import org.refcodes.decoupling.InstanceMode;
import org.refcodes.decoupling.ProfilesAccessor;
import org.refcodes.decoupling.Reactor;
import org.refcodes.decoupling.TagsAccessor;
import org.refcodes.decoupling.UnsatisfiedDependencyException;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.schema.Schema;
import org.refcodes.schema.Schemable;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class Dependency<T>
implements Schemable,
AliasAccessor,
TypeAccessor<T>,
ProfilesAccessor,
TagsAccessor,
InstanceMetricsAccessor,
ClaimsAccessor,
Comparable<Dependency<T>> {
    private static final InstanceMetrics DEFAULT_INSTANCE_MODE = InstanceMode.SINGLETON_IS_MANDATORY;
    private static final Logger LOGGER = Logger.getLogger(Dependency.class.getName());
    private Constructor<?> _constructor;
    private T _dangling;
    private boolean _isSetupSingletonFromInstance = false;
    protected T _singleton = null;
    protected String _alias;
    protected Set<Claim> _claims = new HashSet<Claim>();
    protected Dependency<?>[] _dependencies;
    protected InstanceMetrics _instanceMetrics;
    protected Set<T> _instances = new HashSet<T>();
    protected Set<Object> _profiles;
    protected Set<Object> _tags;
    protected Class<T> _type;
    protected InitializerClaim<?, T> _initializer;
    protected FactoryClaim<?, T> _factory;
    protected Reactor _reactor;

    protected Dependency() {
    }

    Dependency(DependencyBuilder<T> aDependency, Reactor aReactor) {
        this(aDependency.getType(), aDependency.getInstance(), aDependency.getInstanceMetrics(), aDependency.getAlias(), aDependency.getTags(), aDependency.getProfiles(), aDependency.getClaims(), aDependency.getSetup(), aDependency.getFactory(), aReactor);
    }

    Dependency(Class<T> aType) {
        this(aType, null, null, (String)null, (Collection<Object>)null, (Collection<Object>)null, null, (InitializerClaim)null, (FactoryClaim)null, null);
    }

    Dependency(T aInstance) {
        this((Class)null, aInstance, (InstanceMetrics)null, (String)null, (Collection<Object>)null, (Collection<Object>)null, null, (InitializerClaim)null, (FactoryClaim)null, null);
    }

    private Dependency(Class<T> aType, T aInstance, InstanceMetrics aInstanceMetrics, String aAlias, Object[] aTags, Object[] aProfiles, Claim[] aClaims, InitializerClaim<?, T> aInitializerClaim, FactoryClaim<?, T> aFactory, Reactor aReactor) {
        this(aType, aInstance, aInstanceMetrics, aAlias, aTags != null && aTags.length != 0 ? Arrays.asList(aTags) : null, aProfiles != null && aProfiles.length != 0 ? Arrays.asList(aProfiles) : null, aClaims != null && aClaims.length != 0 ? Arrays.asList(aClaims) : null, aInitializerClaim, aFactory, aReactor);
    }

    private Dependency(Class<T> aType, T aInstance, InstanceMetrics aInstanceMetrics, String aAlias, Collection<Object> aTags, Collection<Object> aProfiles, Collection<Claim> aClaims, InitializerClaim<?, T> aInitializerClaim, FactoryClaim<?, T> aFactory, Reactor aReactor) {
        this._type = aInstance != null && aType == null ? aInstance.getClass() : aType;
        this._alias = aAlias == null || aAlias.isEmpty() ? CaseStyleBuilder.asCamelCase((String)Dependency.toAlias(this._type)) : aAlias;
        this._tags = aTags != null && aTags.size() != 0 ? new HashSet<Object>(aTags) : new HashSet<Object>();
        this._profiles = aProfiles != null && aProfiles.size() != 0 ? new HashSet<Object>(aProfiles) : new HashSet<Object>();
        this._instanceMetrics = aInstanceMetrics != null ? aInstanceMetrics : DEFAULT_INSTANCE_MODE;
        this._claims = aClaims != null && aClaims.size() != 0 ? new HashSet<Claim>(aClaims) : new HashSet<Claim>();
        this._initializer = aInitializerClaim;
        this._factory = aFactory;
        this._reactor = aReactor;
        if (aInstance == null && aType == null) {
            throw new IllegalArgumentException("At least an <instance> or a <type> must be provided, but neither a <type> nor  an <instance> has been provided!");
        }
        if (aInstance != null && aFactory != null) {
            throw new IllegalArgumentException("Either an <instance> or a <factory> must be provided, but not an instance <" + aInstance + "> and a factory <" + aFactory + "> at the same time!");
        }
        if (aInstance != null) {
            this._instances.add(aInstance);
            if (this._instanceMetrics.isSingleton() && this._instanceMetrics.isMandatory()) {
                this._singleton = aInstance;
                this._isSetupSingletonFromInstance = true;
            } else {
                throw new IllegalArgumentException("The instance <" + aInstance + "> may only be provided in case the dependency <" + this + "> instance metrics denotes singleton (we only have that single instance) and mandatory (as it has already been created)!");
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dependency other = (Dependency)obj;
        return Objects.equals(this._alias, other._alias) && Objects.equals(this._profiles, other._profiles) && Objects.equals(this._tags, other._tags) && Objects.equals(this._type, other._type);
    }

    public String getAlias() {
        return this._alias;
    }

    @Override
    public Claim[] getClaims() {
        return this._claims.toArray(new Claim[this._claims.size()]);
    }

    public InitializerClaim<?, T> getSetup() {
        return this._initializer;
    }

    public FactoryClaim<?, T> getFactory() {
        return this._factory;
    }

    @Override
    public InstanceMetrics getInstanceMetrics() {
        return this._instanceMetrics;
    }

    public T[] getInstances() {
        return this._instances.toArray((Object[])Array.newInstance(this._type, this._instances.size()));
    }

    @Override
    public Object[] getProfiles() {
        return this._profiles.toArray();
    }

    @Override
    public Object[] getTags() {
        if (this._tags == null) {
            this._tags = new HashSet<Object>();
        }
        return this._tags.toArray();
    }

    public Class<T> getType() {
        return this._type;
    }

    public int hashCode() {
        return Objects.hash(this._alias, this._profiles, this._tags, this._type);
    }

    public boolean hasInstances() {
        return !this._instances.isEmpty();
    }

    public boolean hasInstance(Object aInstance) {
        for (T eInnstance : this.getInstances()) {
            if (eInnstance != aInstance) continue;
            return true;
        }
        return false;
    }

    public boolean hasProfile(Object ... aProfiles) {
        if (this._profiles == null || this._profiles.size() == 0) {
            return true;
        }
        if (aProfiles == null || aProfiles.length == 0) {
            return false;
        }
        for (Object eProfile : aProfiles) {
            for (Object eDependencyProfile : this._profiles) {
                if (!eProfile.toString().equalsIgnoreCase(eDependencyProfile.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public T toInstance() throws DependencyInstanciationException {
        if (this._singleton != null) {
            return this._singleton;
        }
        Object[] theArgs = new Object[this._dependencies.length];
        for (int i = 0; i < this._dependencies.length; ++i) {
            theArgs[i] = this._dependencies[i].toInstance();
        }
        try {
            Object theInstance = this._constructor.newInstance(theArgs);
            if (this._instanceMetrics.isSingleton()) {
                this._singleton = theInstance;
                this._isSetupSingletonFromInstance = true;
            }
            this._instances.add(theInstance);
            return (T)theInstance;
        }
        catch (Exception e) {
            throw new DependencyInstanciationException("Cannot instanciate dependency <{0}> using provided dependencies <{1}>!", this, this._dependencies, e);
        }
    }

    public DependencySchema toSchema() {
        Schema[] theSchemas = null;
        if (this._dependencies != null && this._dependencies.length != 0) {
            theSchemas = new DependencySchema[this._dependencies.length];
            for (int i = 0; i < theSchemas.length; ++i) {
                theSchemas[i] = this._dependencies[i].toSchema();
            }
        }
        if (this.getFactory() != null) {
            theSchemas = theSchemas == null ? new DependencySchema[1] : Arrays.copyOf(theSchemas, theSchemas.length + 1);
            theSchemas[theSchemas.length - 1] = this.getFactory().toSchema();
        }
        if (this.getSetup() != null) {
            theSchemas = theSchemas == null ? new DependencySchema[1] : (DependencySchema[])Arrays.copyOf(theSchemas, theSchemas.length + 1);
            theSchemas[theSchemas.length - 1] = this.getSetup().toSchema();
        }
        return new DependencySchema(this, theSchemas);
    }

    @Override
    public int compareTo(Dependency<T> aDependency) {
        String thisAlias = this.getAlias() != null ? this.getAlias() : "";
        String thatAlias = aDependency != null && aDependency.getAlias() != null ? aDependency.getAlias() : "";
        return thisAlias.compareTo(thatAlias);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [alias=" + this._alias + ", tags=" + this._tags + ", profiles=" + this._profiles + ", type=" + this._type + ", instances=" + this._instances + ", instanceMetrics=" + this._instanceMetrics + "]";
    }

    protected void setInstance(T aInstance) {
        if (aInstance == null) {
            throw new IllegalArgumentException("The provided instance must not(!) be null!");
        }
        this._singleton = null;
        this._instances.clear();
        if (aInstance != null) {
            this._instances.add(aInstance);
        }
        if (this._instanceMetrics.isSingleton()) {
            this._singleton = aInstance;
            this._isSetupSingletonFromInstance = true;
        }
        if (this._type == null) {
            this._type = aInstance.getClass();
        }
        if (this._alias == null && this._alias.isEmpty()) {
            this._alias = CaseStyleBuilder.asCamelCase((String)Dependency.toAlias(this._type));
        }
    }

    protected T toInstance(Dependency<?>[] aDependencies, Object ... aProfiles) throws CircularDependencyException, AmbigousDependencyException, UnsatisfiedDependencyException, AmbigousClaimException, AmbigousInitializerException, AmbigousFactoryException, InstallDependencyException {
        return this.toInstance(aDependencies, new HashSet(), aProfiles);
    }

    protected T toInstance(Dependency<?>[] aDependencies, Set<Dependency<?>> aVistedDependencies, Object ... aProfiles) throws CircularDependencyException, AmbigousDependencyException, UnsatisfiedDependencyException, AmbigousClaimException, AmbigousInitializerException, AmbigousFactoryException, InstallDependencyException {
        Dependency<?> theDependency;
        Object theInstance;
        block19: {
            if (!aVistedDependencies.add(this) && this._instances.isEmpty()) {
                throw new CircularDependencyException("A circular dependency between this dependency <{0}> and one or more dependencies <{1}> has been detected, unable to resolve conflict (you may contribute and add some proxy mechanism here)!", this, aVistedDependencies.toArray(new Dependency[aVistedDependencies.size()]));
            }
            if (this._dangling != null) {
                return this._dangling;
            }
            theInstance = null;
            if (this._singleton != null) {
                if (!this._isSetupSingletonFromInstance) {
                    return this._singleton;
                }
                theInstance = this._singleton;
            } else if (this._factory != null) {
                theDependency = this.toMatchingDependencyByClaim(aDependencies, this._factory);
                Object theFactory = theDependency.toInstance(aDependencies, aVistedDependencies, aProfiles);
                theInstance = this._factory.toInstance(theFactory);
            } else {
                Dependency<?>[] theDependencies = this.toMatchingDependenciesByClaims(aDependencies);
                Constructor<?>[] theCtors = this.toSuitableConstructors(theDependencies, aProfiles);
                ArrayList eCtorDependencies = new ArrayList();
                ArrayList eCtorArgs = new ArrayList();
                CircularDependencyException theCircularDependencyException = null;
                InstallDependencyException theInstallDependencyException = null;
                for (Constructor<?> eCtor : theCtors) {
                    try {
                        for (Parameter eParam : eCtor.getParameters()) {
                            Dependency<?> eParamDependency = this.toDependencyMatch(theDependencies, eParam.getType(), this.toParamAlias(eParam), aProfiles);
                            eCtorArgs.add(eParamDependency.toInstance(aDependencies, aVistedDependencies, aProfiles));
                            eCtorDependencies.add(eParamDependency);
                        }
                        theInstance = eCtor.newInstance(eCtorArgs.toArray());
                        theInstance = this.intercept(theInstance);
                        for (Dependency dependency : eCtorDependencies) {
                            dependency._dangling = null;
                        }
                        this._dependencies = eCtorDependencies.toArray(new Dependency[eCtorDependencies.size()]);
                        this._constructor = eCtor;
                        break block19;
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException | CircularDependencyException e) {
                        if (e instanceof CircularDependencyException) {
                            theCircularDependencyException = (CircularDependencyException)e;
                        } else {
                            theInstallDependencyException = new InstallDependencyException("Cannot install dependency <" + this + ">!", this, (Throwable)e);
                        }
                        LOGGER.log(Level.INFO, "Skipping dependnecy's <" + this + "> constructor with parameters <" + VerboseTextBuilder.asString((Object[])eCtor.getParameters()) + "> as of: " + ((Throwable)e).getMessage());
                        eCtorDependencies.clear();
                        eCtorArgs.clear();
                    }
                }
                if (theCircularDependencyException != null) {
                    throw theCircularDependencyException;
                }
                if (theInstallDependencyException != null) {
                    throw theInstallDependencyException;
                }
                throw new UnsatisfiedDependencyException("Cannot satisfy all required dependencies for dependency <{0}> for its constructors!", this, aDependencies);
            }
        }
        if (!this._instanceMetrics.isSingleton()) {
            this._dangling = theInstance;
        }
        if (this._initializer != null && (this._singleton == null || this._isSetupSingletonFromInstance)) {
            theDependency = this.toMatchingDependencyByClaim(aDependencies, this._initializer);
            Object theSetup = theDependency.toInstance(aDependencies, aVistedDependencies, aProfiles);
            theInstance = this._initializer.toInstance(theSetup, theInstance);
            this._isSetupSingletonFromInstance = false;
        }
        if (this._instanceMetrics.isSingleton() && this._singleton == null) {
            this._singleton = theInstance;
        }
        this._instances.add(theInstance);
        return theInstance;
    }

    protected T intercept(T aInstance) {
        if (this._reactor != null) {
            aInstance = this._reactor.intercept(aInstance, this);
        }
        return aInstance;
    }

    Constructor<?>[] toSuitableConstructors(Dependency<?>[] aDependencies, Object ... aProfiles) throws AmbigousDependencyException, UnsatisfiedDependencyException {
        Constructor<?>[] aConstructors = this.getType().getConstructors();
        ArrayList theCtors = new ArrayList();
        block0: for (Constructor<?> eCtr : aConstructors) {
            for (Parameter eParam : eCtr.getParameters()) {
                if (!this.hasDependencyMatch(aDependencies, eParam.getType(), this.toParamAlias(eParam), aProfiles)) continue block0;
            }
            theCtors.add(eCtr);
        }
        if (theCtors.size() == 0) {
            throw new UnsatisfiedDependencyException("Cannot find suitable constructor for dependency <" + this + "> as none constructor matches the provided dependencies <" + VerboseTextBuilder.asString((Object[])aDependencies) + ">!", this, aDependencies);
        }
        return this.toOrderedConstructors(theCtors);
    }

    private boolean hasDependencyMatch(Dependency<?>[] aDependencies, Class<?> aType, String aAlias, Object ... aProfiles) throws AmbigousDependencyException {
        Set<Dependency<?>> theDependencies = this.toMatchingDependencies(aDependencies, aType, aAlias, aProfiles);
        if (theDependencies.size() > 1) {
            throw new AmbigousDependencyException("There are <" + theDependencies.size() + "> dependencies matching the type <" + aType.getName() + "> required by the dependency<" + this + ">: " + VerboseTextBuilder.asString(theDependencies), this, theDependencies.toArray(new Dependency[theDependencies.size()]));
        }
        return theDependencies.size() == 1;
    }

    private boolean hasTagMatchWithDependency(Dependency<?> aDependency) {
        Object[] theTagsA = this.getTags();
        Object[] theTagsB = aDependency.getTags();
        if (!(theTagsA != null && theTagsA.length != 0 || theTagsB != null && theTagsB.length != 0)) {
            return true;
        }
        if (theTagsA != null && theTagsA.length != 0 && (theTagsB == null || theTagsB.length == 0)) {
            return false;
        }
        if ((theTagsA == null || theTagsA.length == 0) && theTagsB != null && theTagsB.length != 0) {
            return false;
        }
        for (Object eObjA : theTagsA) {
            for (Object eObjB : theTagsB) {
                if (!eObjA.toString().equalsIgnoreCase(eObjB.toString())) continue;
                return true;
            }
        }
        return false;
    }

    private Dependency<?> toDependencyMatch(Dependency<?>[] aDependencies, Class<?> aType, String aAlias, Object ... aProfiles) throws AmbigousDependencyException, UnsatisfiedDependencyException {
        Set<Dependency<?>> theDependencies = this.toMatchingDependencies(aDependencies, aType, aAlias, aProfiles);
        if (theDependencies.size() > 1) {
            throw new AmbigousDependencyException("There are <" + theDependencies.size() + "> dependencies matching the type <" + aType.getName() + "> required by the dependency<" + this + ">: " + VerboseTextBuilder.asString(theDependencies), this, theDependencies.toArray(new Dependency[theDependencies.size()]));
        }
        if (theDependencies.isEmpty()) {
            throw new UnsatisfiedDependencyException("There are no dependencies matching the type <" + aType.getName() + "> required by the dependency<" + this + ">: " + VerboseTextBuilder.asString((Object[])aDependencies), this, aDependencies);
        }
        return theDependencies.iterator().next();
    }

    private Set<Dependency<?>> toMatchingAmbigousDependenciesByAlias(Set<Dependency<?>> aDependencies, String aAlias) {
        if (aAlias == null || aAlias.isEmpty()) {
            return aDependencies;
        }
        HashSet theAmbigousDependencies = new HashSet(aDependencies);
        Iterator<Dependency<?>> e = aDependencies.iterator();
        while (e.hasNext()) {
            if (e.next().getAlias().equalsIgnoreCase(aAlias)) continue;
            e.remove();
        }
        if (aDependencies.size() == 0) {
            return theAmbigousDependencies;
        }
        return aDependencies;
    }

    private Set<Dependency<?>> toMatchingAmbigousDependenciesByProfiles(Set<Dependency<?>> aDependencies, Object[] aProfiles) {
        if (aProfiles == null || aProfiles.length == 0) {
            return aDependencies;
        }
        HashSet theAmbigousDependencies = new HashSet(aDependencies);
        Iterator<Dependency<?>> e = aDependencies.iterator();
        while (e.hasNext()) {
            Dependency<?> eNext = e.next();
            if (eNext.hasProfile(aProfiles) && eNext.getProfiles() != null && eNext.getProfiles().length != 0) continue;
            e.remove();
        }
        if (aDependencies.size() == 0) {
            return theAmbigousDependencies;
        }
        return aDependencies;
    }

    private Dependency<?> toMatchingDependencyByClaim(Dependency<?>[] aDependencies, Claim aClaim) throws AmbigousInitializerException, AmbigousFactoryException, AmbigousClaimException {
        Dependency<?> theClaim = null;
        if (aClaim != null) {
            for (Dependency<?> eDependency : aDependencies) {
                if (!aClaim.isClaim(eDependency)) continue;
                if (theClaim != null) {
                    if (aClaim instanceof InitializerClaim) {
                        throw new AmbigousInitializerException("The setup (claim) <" + aClaim + "> can be satisfied by more than one <" + theClaim + "> dependency <" + eDependency + ">: " + VerboseTextBuilder.asString((Object[])aDependencies), (InitializerClaim)aClaim, this, aDependencies);
                    }
                    if (aClaim instanceof FactoryClaim) {
                        throw new AmbigousFactoryException("The factory (claim) <" + aClaim + "> can be satisfied by more than one <" + theClaim + "> dependency <" + eDependency + ">: " + VerboseTextBuilder.asString((Object[])aDependencies), (FactoryClaim)aClaim, this, aDependencies);
                    }
                    throw new AmbigousClaimException("The claim <" + aClaim + "> can be satisfied by more than one <" + theClaim + "> dependency <" + eDependency + ">: " + VerboseTextBuilder.asString((Object[])aDependencies), aClaim, this, aDependencies);
                }
                theClaim = eDependency;
            }
        }
        return theClaim;
    }

    private Dependency<?>[] toMatchingDependenciesByClaims(Dependency<?>[] aDependencies) throws AmbigousClaimException {
        HashSet theClaims = new HashSet();
        for (Claim eClaim : this._claims) {
            boolean hasClaim = false;
            for (Dependency<?> eDependency : aDependencies) {
                if (!eClaim.isClaim(eDependency)) continue;
                if (hasClaim) {
                    throw new AmbigousClaimException("The claim <" + eClaim + "> can be satisfied by more than one <" + eClaim + "> dependency <" + eDependency + ">: " + VerboseTextBuilder.asString((Object[])aDependencies), eClaim, this, aDependencies);
                }
                theClaims.add(eDependency);
                hasClaim = true;
            }
        }
        HashSet theDependencies = new HashSet(Arrays.asList(aDependencies));
        Iterator e = theDependencies.iterator();
        while (e.hasNext()) {
            Dependency eDependency = (Dependency)e.next();
            for (Dependency dependency : theClaims) {
                if (dependency == eDependency || !dependency.getType().isAssignableFrom(eDependency.getType())) continue;
                e.remove();
            }
        }
        return theDependencies.toArray(new Dependency[theDependencies.size()]);
    }

    private Set<Dependency<?>> toMatchingAmbigousDependenciesByTag(Set<Dependency<?>> aDependencies) {
        HashSet theAmbigousDependencies = new HashSet(aDependencies);
        Iterator<Dependency<?>> e = aDependencies.iterator();
        while (e.hasNext()) {
            if (this.hasTagMatchWithDependency(e.next())) continue;
            e.remove();
        }
        if (aDependencies.size() == 0) {
            return theAmbigousDependencies;
        }
        return aDependencies;
    }

    private Set<Dependency<?>> toMatchingDependencies(Dependency<?>[] aDependencies, Class<?> aType, String aAlias, Object ... aProfiles) {
        Set<Dependency<?>> theDependencies = this.toMatchingDependenciesByType(aDependencies, aType);
        if (theDependencies.size() > 1) {
            theDependencies = this.toMatchingAmbigousDependenciesByTag(theDependencies);
        }
        if (theDependencies.size() > 1) {
            theDependencies = this.toMatchingAmbigousDependenciesByAlias(theDependencies, aAlias);
        }
        if (theDependencies.size() > 1) {
            theDependencies = this.toMatchingAmbigousDependenciesByProfiles(theDependencies, aProfiles);
        }
        return theDependencies;
    }

    private Set<Dependency<?>> toMatchingDependenciesByType(Dependency<?>[] aDependencies, Class<?> aType) {
        HashSet theDependencies = new HashSet();
        for (Dependency<?> eDependency : aDependencies) {
            if (eDependency == this || !aType.isAssignableFrom(eDependency.getType())) continue;
            theDependencies.add(eDependency);
        }
        return theDependencies;
    }

    private Constructor<?>[] toOrderedConstructors(List<Constructor<?>> aCtors) {
        Constructor[] theResult = new Constructor[aCtors.size()];
        for (int i = 0; i < theResult.length; ++i) {
            Constructor<?> maxCtor = null;
            for (Constructor<?> eCtor : aCtors) {
                if (maxCtor != null && maxCtor.getParameters().length >= eCtor.getParameters().length) continue;
                maxCtor = eCtor;
            }
            aCtors.remove(maxCtor);
            theResult[i] = maxCtor;
        }
        return theResult;
    }

    private String toParamAlias(Parameter aParam) {
        Alias theAlias = aParam.getAnnotation(Alias.class);
        return theAlias != null ? theAlias.value() : aParam.getName();
    }

    private static String toAlias(Class<?> aType) {
        Object theAlias = null;
        if (aType != null) {
            theAlias = aType.getSimpleName();
            while ((aType = aType.getEnclosingClass()) != null) {
                theAlias = aType.getSimpleName() + Delimiter.INNER_CLASS.getChar() + (String)theAlias;
            }
        }
        return theAlias;
    }
}

