/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.util.HashSet;
import org.refcodes.decoupling.InstanceMetrics;

public enum InstanceMode implements InstanceMetrics
{
    SINGLETON_BY_DEFAULT(true, true),
    SINGLETON_IS_MANDATORY(true, true),
    INSTANCE_IS_MANDATORY(false, true),
    SINGLETON_ON_DEMAND(true, false),
    INSTANCE_ON_DEMAND(false, false);

    private boolean _isSingleton;
    private boolean _isMandatory;

    private InstanceMode(boolean isSingleton, boolean isMandatory) {
        this._isSingleton = isSingleton;
        this._isMandatory = isMandatory;
    }

    @Override
    public boolean isSingleton() {
        return this._isSingleton;
    }

    @Override
    public boolean isMandatory() {
        return this._isMandatory;
    }

    public static InstanceMetrics[] toSingletonModes() {
        HashSet<InstanceMode> theModes = new HashSet<InstanceMode>();
        for (InstanceMode eMode : InstanceMode.values()) {
            if (!eMode.isSingleton()) continue;
            theModes.add(eMode);
        }
        return theModes.toArray(new InstanceMode[theModes.size()]);
    }

    public static InstanceMetrics[] toRequiredModes() {
        HashSet<InstanceMode> theModes = new HashSet<InstanceMode>();
        for (InstanceMode eMode : InstanceMode.values()) {
            if (!eMode.isMandatory()) continue;
            theModes.add(eMode);
        }
        return theModes.toArray(new InstanceMode[theModes.size()]);
    }
}

