/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.refcodes.decoupling.AmbigousClaimException;
import org.refcodes.decoupling.AmbigousDependencyException;
import org.refcodes.decoupling.AmbigousFactoryException;
import org.refcodes.decoupling.AmbigousInitializerException;
import org.refcodes.decoupling.CircularDependencyException;
import org.refcodes.decoupling.Claim;
import org.refcodes.decoupling.Context;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencyBuilder;
import org.refcodes.decoupling.DependencyInterceptor;
import org.refcodes.decoupling.DuplicateClaimException;
import org.refcodes.decoupling.DuplicateDependencyException;
import org.refcodes.decoupling.FactoryClaim;
import org.refcodes.decoupling.InitializerClaim;
import org.refcodes.decoupling.InstallDependencyException;
import org.refcodes.decoupling.InstanceMetrics;
import org.refcodes.decoupling.InstanceMode;
import org.refcodes.decoupling.UnsatisfiedClaimException;
import org.refcodes.decoupling.UnsatisfiedDependencyException;
import org.refcodes.decoupling.UnsatisfiedFactoryException;
import org.refcodes.decoupling.UnsatisfiedInitializerException;
import org.refcodes.factory.Factory;
import org.refcodes.mixin.AliasAccessor;

public class Reactor {
    protected List<DependencyBuilder<?>> _dependencies = new ArrayList();
    protected List<DependencyInterceptor> _interceptors = new ArrayList<DependencyInterceptor>();

    public <T> DependencyBuilder<T> addDependency(Class<T> aType) {
        DependencyBuilder<Class<T>> theBuilder = new DependencyBuilder<Class<T>>(aType);
        this._dependencies.add(theBuilder);
        return theBuilder;
    }

    public <T> DependencyBuilder<T> addDependency(T aInstance) {
        DependencyBuilder<T> theBuilder = new DependencyBuilder<T>(aInstance).withInstanceMetrics(InstanceMode.SINGLETON_IS_MANDATORY);
        this._dependencies.add(theBuilder);
        return theBuilder;
    }

    public <F extends Factory<T>, T> DependencyBuilder<T> addDependency(Class<T> aType, F aFactory) {
        AliasAccessor.AliasBuilder theContext = new DependencyBuilder<F>(aFactory).withAlias(UUID.randomUUID().toString());
        this._dependencies.add((DependencyBuilder<?>)theContext);
        DependencyBuilder<Object> theFactory = new DependencyBuilder<Class<Object>>((Class<Object>)aType).withFactory(theContext.getType(), f -> aFactory.create(), theContext.getAlias());
        this._dependencies.add(theFactory);
        return theFactory;
    }

    public <F extends Factory<T>, T> DependencyBuilder<T> addDependency(Class<T> aType, Class<F> aFactory) {
        return this.addDependency(aType, aFactory, Factory::create);
    }

    public <F, T> DependencyBuilder<T> addDependency(Class<T> aType, Class<F> aDependency, Function<F, T> aFactory) {
        AliasAccessor.AliasBuilder theContext = new DependencyBuilder<Class<F>>(aDependency).withAlias(UUID.randomUUID().toString());
        this._dependencies.add((DependencyBuilder<?>)theContext);
        DependencyBuilder<Object> theFactory = new DependencyBuilderFactory<Object>((Class<Object>)aType, (DependencyBuilder<?>)theContext).withFactory(theContext.getType(), aFactory::apply, theContext.getAlias());
        this._dependencies.add(theFactory);
        return theFactory;
    }

    public boolean hasInterceptor(DependencyInterceptor aInterceptor) {
        return this._interceptors.contains(aInterceptor);
    }

    public boolean addInterceptor(DependencyInterceptor aInterceptor) {
        if (!this._interceptors.contains(aInterceptor)) {
            return this._interceptors.add(aInterceptor);
        }
        return false;
    }

    public boolean removeInterceptor(DependencyInterceptor aInterceptor) {
        return this._interceptors.remove(aInterceptor);
    }

    public Context createContext() throws AmbigousDependencyException, UnsatisfiedDependencyException, CircularDependencyException, DuplicateDependencyException, DuplicateClaimException, UnsatisfiedClaimException, AmbigousClaimException, AmbigousInitializerException, UnsatisfiedInitializerException, AmbigousFactoryException, UnsatisfiedFactoryException, InstallDependencyException {
        return this.createContext(new Object[0]);
    }

    public Context createContext(String ... aProfiles) throws AmbigousDependencyException, UnsatisfiedDependencyException, CircularDependencyException, DuplicateDependencyException, DuplicateClaimException, UnsatisfiedClaimException, AmbigousClaimException, AmbigousInitializerException, UnsatisfiedInitializerException, AmbigousFactoryException, UnsatisfiedFactoryException, InstallDependencyException {
        return this.createContext((Object[])aProfiles);
    }

    public Context createContext(Object ... aProfiles) throws AmbigousDependencyException, UnsatisfiedDependencyException, CircularDependencyException, DuplicateDependencyException, DuplicateClaimException, UnsatisfiedClaimException, AmbigousClaimException, AmbigousInitializerException, UnsatisfiedInitializerException, AmbigousFactoryException, UnsatisfiedFactoryException, InstallDependencyException {
        Context theCtx = this.toContext(aProfiles);
        Dependency<?>[] theDependencies = this.toDependencies(aProfiles);
        this.toDependencies(theDependencies);
        for (Dependency<?> eDependency : theDependencies) {
            try {
                if (!eDependency.getInstanceMetrics().isMandatory()) continue;
                eDependency.toInstance(theDependencies, aProfiles);
            }
            catch (AmbigousDependencyException e) {
                throw new AmbigousDependencyException("Cannot create context as of an ambiguous <{0}> dependency!", e.getDependency(), e.getDependencies(), (Throwable)((Object)e));
            }
            catch (UnsatisfiedDependencyException e) {
                throw new UnsatisfiedDependencyException("Cannot create context as of an unsatisfied <{0}> dependency!", e.getDependency(), e.getDependencies(), (Throwable)((Object)e));
            }
        }
        theCtx.initialize(theDependencies);
        return theCtx;
    }

    protected Context toContext(Object[] aProfiles) {
        return new Context(aProfiles);
    }

    protected <T> T intercept(T aInstance, Dependency<T> aDependency) {
        if (aInstance == null) {
            throw new NullPointerException("The provided instance must not be <null>!");
        }
        for (DependencyInterceptor eInterceptor : this._interceptors) {
            aInstance = eInterceptor.intercept(aInstance, aDependency);
            if (aInstance != null) continue;
            throw new NullPointerException("The intercepted work piece must not be <null>!");
        }
        return aInstance;
    }

    Dependency<?>[] toDependencies(Object ... aProfiles) {
        ArrayList theDependencies = new ArrayList();
        for (DependencyBuilder<?> eDependency : this._dependencies) {
            if (!eDependency.hasProfile(aProfiles)) continue;
            theDependencies.add(new Dependency(eDependency, this));
        }
        return theDependencies.toArray(new Dependency[theDependencies.size()]);
    }

    private void toDependencies(Dependency<?>[] theDependencies) throws DuplicateClaimException, UnsatisfiedInitializerException, UnsatisfiedFactoryException, UnsatisfiedClaimException, DuplicateDependencyException {
        for (int i = 0; i < theDependencies.length; ++i) {
            Claim[] eClaims = theDependencies[i].getClaims();
            if (theDependencies[i].getSetup() != null) {
                eClaims = Arrays.copyOf(eClaims, eClaims.length + 1);
                eClaims[eClaims.length - 1] = theDependencies[i].getSetup();
            }
            if (theDependencies[i].getFactory() != null) {
                eClaims = Arrays.copyOf(eClaims, eClaims.length + 1);
                eClaims[eClaims.length - 1] = theDependencies[i].getFactory();
            }
            block1: for (int a = 0; a < eClaims.length; ++a) {
                for (int b = a + 1; b < eClaims.length; ++b) {
                    if (b == a || !eClaims[b].equals(eClaims[a])) continue;
                    throw new DuplicateClaimException("An identical claim <{0}> for dependency <{2}> already exists!", eClaims[a], eClaims, theDependencies[i]);
                }
                for (Dependency<?> eDependency : theDependencies) {
                    if (eDependency != theDependencies[i] && eClaims[a].isClaim(eDependency)) continue block1;
                }
                if (eClaims[a] instanceof InitializerClaim) {
                    throw new UnsatisfiedInitializerException("The initializer <{0}> for dependency <{1}> cannot be satisfied by any of the provided dependencies <{2}>!", (InitializerClaim)eClaims[a], theDependencies[i], theDependencies);
                }
                if (eClaims[a] instanceof FactoryClaim) {
                    throw new UnsatisfiedFactoryException("The initializer <{0}> for dependency <{1}> cannot be satisfied by any of the provided dependencies <{2}>!", (FactoryClaim)eClaims[a], theDependencies[i], theDependencies);
                }
                throw new UnsatisfiedClaimException("The initializer <{0}> for dependency <{1}> cannot be satisfied by any of the provided dependencies <{2}>!", eClaims[a], theDependencies[i], theDependencies);
            }
            for (int j = i + 1; j < theDependencies.length; ++j) {
                if (!theDependencies[j].equals(theDependencies[i])) continue;
                throw new DuplicateDependencyException("An identical dependency <{0}> already exists as of the provided dependencies <{1}>!", theDependencies[i], theDependencies);
            }
        }
    }

    private static class DependencyBuilderFactory<T>
    extends DependencyBuilder<T> {
        private final DependencyBuilder<?> _dependencyBuilder;

        DependencyBuilderFactory(Class<T> aType, DependencyBuilder<?> aDependencyBuilder) {
            super(aType);
            this._dependencyBuilder = aDependencyBuilder;
        }

        @Override
        public void setInstanceMetrics(InstanceMetrics aInstanceMetrics) {
            this._dependencyBuilder.setInstanceMetrics(this.toInstanceMetrics(aInstanceMetrics));
            super.setInstanceMetrics(aInstanceMetrics);
        }

        @Override
        public void setInstanceMetrics(InstanceMode aInstanceMode) {
            this._dependencyBuilder.setInstanceMetrics(this.toInstanceMetrics(aInstanceMode));
            super.setInstanceMetrics(aInstanceMode);
        }

        @Override
        public DependencyBuilder<T> withInstanceMetrics(InstanceMetrics aInstanceMetrics) {
            this._dependencyBuilder.setInstanceMetrics(this.toInstanceMetrics(aInstanceMetrics));
            return super.withInstanceMetrics(aInstanceMetrics);
        }

        @Override
        public DependencyBuilder<T> withInstanceMetrics(InstanceMode aInstanceMode) {
            this._dependencyBuilder.setInstanceMetrics(this.toInstanceMetrics(aInstanceMode));
            return super.withInstanceMetrics(aInstanceMode);
        }

        private InstanceMetrics toInstanceMetrics(final InstanceMetrics aInstanceMode) {
            return aInstanceMode.isSingleton() ? aInstanceMode : new InstanceMetrics(){

                @Override
                public boolean isSingleton() {
                    return aInstanceMode.isSingleton();
                }

                @Override
                public boolean isMandatory() {
                    return false;
                }
            };
        }
    }
}

