/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.decoupling.Claim;
import org.refcodes.decoupling.ComponentA;
import org.refcodes.decoupling.ComponentA1;
import org.refcodes.decoupling.ComponentA2;
import org.refcodes.decoupling.ComponentQ;
import org.refcodes.decoupling.ComponentQ1;
import org.refcodes.decoupling.ComponentQ2;
import org.refcodes.decoupling.Context;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencyBuilder;
import org.refcodes.decoupling.DependencyException;
import org.refcodes.decoupling.Reactor;
import org.refcodes.decoupling.UnsatisfiedClaimException;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class ClaimTest {
    @Test
    public void testClaims1() throws DependencyException {
        Reactor theReactor = new Reactor();
        DependencyBuilder theA = theReactor.addDependency(ComponentA.class).withAlias("A").withAddClaim(ComponentA1.class, "A1");
        theReactor.addDependency(ComponentA1.class).withAlias("A1");
        theReactor.addDependency(ComponentA2.class).withAlias("A2");
        Claim[] theClaims = theA.getClaims();
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("################################################################################");
            for (Claim eClaim : theClaims) {
                System.out.println(eClaim);
            }
        }
        Assertions.assertEquals((int)1, (int)theClaims.length);
        Assertions.assertEquals((Object)"A1", (Object)theClaims[0].getAlias());
        Assertions.assertEquals(ComponentA1.class, (Object)theClaims[0].getType());
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        theA = theCtx.getDependencyByAlias("A");
        Assertions.assertEquals((int)1, (int)theA.getClaims().length);
        Assertions.assertEquals((Object)"A1", (Object)theA.getClaims()[0].getAlias());
        Assertions.assertEquals(ComponentA1.class, (Object)theA.getClaims()[0].getType());
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testClaims2() throws DependencyException {
        Reactor theReactor = new Reactor();
        DependencyBuilder theA = theReactor.addDependency(ComponentA.class).withAlias("A").withAddClaim(ComponentA1.class, "A1").withAddClaim(ComponentA2.class, "A2");
        theReactor.addDependency(ComponentA1.class).withAlias("A1");
        theReactor.addDependency(ComponentA2.class).withAlias("A2");
        Object[] theClaims = theA.getClaims();
        Arrays.sort(theClaims);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("################################################################################");
            for (Object eClaim : theClaims) {
                System.out.println(eClaim);
            }
        }
        Assertions.assertEquals((int)2, (int)theClaims.length);
        Assertions.assertEquals((Object)"A1", (Object)theClaims[0].getAlias());
        Assertions.assertEquals(ComponentA1.class, (Object)theClaims[0].getType());
        Assertions.assertEquals((Object)"A2", (Object)theClaims[1].getAlias());
        Assertions.assertEquals(ComponentA2.class, (Object)theClaims[1].getType());
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        theA = theCtx.getDependencyByAlias("A");
        Assertions.assertEquals((int)2, (int)theA.getClaims().length);
        theClaims = theA.getClaims();
        Arrays.sort(theClaims);
        Assertions.assertEquals((Object)"A1", (Object)theClaims[0].getAlias());
        Assertions.assertEquals(ComponentA1.class, (Object)theClaims[0].getType());
        Assertions.assertEquals((Object)"A2", (Object)theClaims[1].getAlias());
        Assertions.assertEquals(ComponentA2.class, (Object)theClaims[1].getType());
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testMatchingClaims1() throws DependencyException {
        Reactor theReactor = new Reactor();
        DependencyBuilder theQ = theReactor.addDependency(ComponentQ.class).withAlias("Q").withAddClaim(ComponentQ1.class, "Q1");
        theReactor.addDependency((Object)new ComponentQ1("Q1, take this one")).withAlias("Q1");
        theReactor.addDependency((Object)new ComponentQ1("Another Q1, don't pick it"));
        theReactor.addDependency((Object)new ComponentQ2("Q2"));
        Claim[] theClaims = theQ.getClaims();
        System.out.println("################################################################################");
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            for (Claim eClaim : theClaims) {
                System.out.println(eClaim);
            }
        }
        Assertions.assertEquals((int)1, (int)theClaims.length);
        Assertions.assertEquals((Object)"Q1", (Object)theClaims[0].getAlias());
        Assertions.assertEquals(ComponentQ1.class, (Object)theClaims[0].getType());
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        theQ = theCtx.getDependencyByAlias("Q");
        Assertions.assertEquals((int)1, (int)theQ.getClaims().length);
        Assertions.assertEquals((Object)"Q1", (Object)theQ.getClaims()[0].getAlias());
        Assertions.assertEquals(ComponentQ1.class, (Object)theQ.getClaims()[0].getType());
        ComponentQ theComponentQ = (ComponentQ)theCtx.getSingletonByAlias("Q", ComponentQ.class);
        Assertions.assertEquals((Object)"Q1, take this one", (Object)theComponentQ.getQ1().getAlias());
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testUnsatisfiedClaimException1() throws DependencyException {
        block5: {
            Reactor theReactor = new Reactor();
            DependencyBuilder theQ = theReactor.addDependency(ComponentQ.class).withAlias("Q").withAddClaim(ComponentQ1.class, "Q1");
            theReactor.addDependency((Object)new ComponentQ1("Alias=Q1"));
            theReactor.addDependency((Object)new ComponentQ2("Alias=Q2"));
            Claim[] theClaims = theQ.getClaims();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("################################################################################");
                for (Claim eClaim : theClaims) {
                    System.out.println(eClaim);
                }
            }
            Assertions.assertEquals((int)1, (int)theClaims.length);
            Assertions.assertEquals((Object)"Q1", (Object)theClaims[0].getAlias());
            Assertions.assertEquals(ComponentQ1.class, (Object)theClaims[0].getType());
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + UnsatisfiedClaimException.class.getName() + ">!"));
            }
            catch (UnsatisfiedClaimException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block5;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    private void log(Context aCtx) {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("################################################################################");
            System.out.println("PROFILES = " + VerboseTextBuilder.asString((Object[])aCtx.getProfiles()));
            System.out.println("################################################################################");
            for (Dependency eDependency : aCtx.getDependencies()) {
                System.out.println("DEPENDENCY: " + String.valueOf(eDependency));
            }
            System.out.println("--------------------------------------------------------------------------------");
            boolean hasDependency = false;
            for (Dependency eDependency : aCtx.getDependencies()) {
                for (Object eObj : eDependency.getInstances()) {
                    hasDependency = true;
                    System.out.println(String.valueOf(eDependency.getInstanceMetrics()) + ": " + String.valueOf(eObj));
                }
            }
            if (!hasDependency) {
                System.out.println("(no dependencies)");
            }
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println(aCtx.toSchema());
        }
    }
}

