/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.decoupling.AmbigousDependencyException;
import org.refcodes.decoupling.CircularDependencyException;
import org.refcodes.decoupling.ComponentA;
import org.refcodes.decoupling.ComponentA1;
import org.refcodes.decoupling.ComponentA2;
import org.refcodes.decoupling.ComponentB;
import org.refcodes.decoupling.ComponentB1;
import org.refcodes.decoupling.ComponentB2;
import org.refcodes.decoupling.ComponentExtendsA2;
import org.refcodes.decoupling.ComponentX;
import org.refcodes.decoupling.ComponentY;
import org.refcodes.decoupling.Context;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencyException;
import org.refcodes.decoupling.DuplicateDependencyException;
import org.refcodes.decoupling.From1To2;
import org.refcodes.decoupling.From1To2To3;
import org.refcodes.decoupling.From2To1;
import org.refcodes.decoupling.From2To3To1;
import org.refcodes.decoupling.From3To1To2;
import org.refcodes.decoupling.InstanceMode;
import org.refcodes.decoupling.Reactor;
import org.refcodes.decoupling.UnsatisfiedDependencyException;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class ContextTest {
    @Test
    public void testAmbigousDependencyException1() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAlias("A1.1");
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAlias("A1.2");
            theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + AmbigousDependencyException.class.getName() + ">!"));
            }
            catch (AmbigousDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousDependencyException2() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY).withAddTag((Object)"test");
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAlias("A1.1");
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAlias("A1.2");
            theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + AmbigousDependencyException.class.getName() + ">!"));
            }
            catch (AmbigousDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousDependencyException3() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY).withAddTag((Object)"test");
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddTag((Object)"production");
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + AmbigousDependencyException.class.getName() + ">!"));
            }
            catch (AmbigousDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousDependencyException4() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY).withAddTag((Object)"test");
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddTag((Object)"test").withAlias("A1.1");
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddTag((Object)"test").withAlias("A1.2");
            theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + AmbigousDependencyException.class.getName() + ">!"));
            }
            catch (AmbigousDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousDependencyOnDemand() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)0, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousSubClassDependency1() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentA.class);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentExtendsA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddProfile((Object)"EXTENSIONS");
        Context theCtx = theReactor.createContext(new String[]{"EXTENSIONS"});
        this.log(theCtx);
        Assertions.assertEquals((int)3, (int)theCtx.getInstances().length);
        ComponentA2 theA2 = (ComponentA2)theCtx.getFirstByType(ComponentA2.class);
        Assertions.assertTrue((boolean)(theA2 instanceof ComponentExtendsA2));
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(((ComponentExtendsA2)theA2).whoAmI());
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousSubClassDependency2() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentA.class);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddProfile((Object)"EXTENSIONS");
        theReactor.addDependency(ComponentExtendsA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext(new String[]{"EXTENSIONS"});
        this.log(theCtx);
        Assertions.assertEquals((int)3, (int)theCtx.getInstances().length);
        ComponentA2 theA2 = (ComponentA2)theCtx.getFirstByType(ComponentA2.class);
        Assertions.assertFalse((boolean)(theA2 instanceof ComponentExtendsA2));
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousDependencyByAlias() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAlias("a1");
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)3, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousDependencyWithProfile() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY).withAddProfile((Object)"test");
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddProfile((Object)"prod");
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddProfile((Object)"test");
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddProfile((Object)"test");
        Context theCtx = theReactor.createContext(new String[]{"test"});
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)3, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousDependencyWithTag1() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY).withAddTag((Object)"test");
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddTag((Object)"test");
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddTag((Object)"test");
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)3, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testAmbigousDependencyWithTag2() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY).withAddTag((Object)"test");
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND).withAddTag((Object)"test");
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)3, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testCircularDependency1() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(From1To2To3.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(From2To3To1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(From3To1To2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((From1To2To3[])theCtx.getInstancesByType(From1To2To3.class)).length);
        Assertions.assertEquals((int)1, (int)((From2To3To1[])theCtx.getInstancesByType(From2To3To1.class)).length);
        Assertions.assertEquals((int)1, (int)((From3To1To2[])theCtx.getInstancesByType(From3To1To2.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)4, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testCircularDependencyException1() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(From1To2.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
            theReactor.addDependency(From2To1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + CircularDependencyException.class.getName() + ">!"));
            }
            catch (CircularDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testCircularDependencyException2() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(From1To2To3.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
            theReactor.addDependency(From2To3To1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            theReactor.addDependency(From3To1To2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + CircularDependencyException.class.getName() + ">!"));
            }
            catch (CircularDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testContext1() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentX.class);
        theReactor.addDependency(ComponentA.class);
        theReactor.addDependency(ComponentB.class);
        theReactor.addDependency(ComponentA1.class);
        theReactor.addDependency(ComponentA2.class);
        theReactor.addDependency(ComponentB1.class);
        theReactor.addDependency(ComponentB2.class);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentX[])theCtx.getInstancesByType(ComponentX.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentB[])theCtx.getInstancesByType(ComponentB.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentB1[])theCtx.getInstancesByType(ComponentB1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentB2[])theCtx.getInstancesByType(ComponentB2.class)).length);
        Assertions.assertEquals((int)7, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testContext2() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentX.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.SINGLETON_ON_DEMAND);
        theReactor.addDependency(ComponentB.class).withInstanceMetrics(InstanceMode.SINGLETON_ON_DEMAND);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.SINGLETON_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.SINGLETON_ON_DEMAND);
        theReactor.addDependency(ComponentB1.class).withInstanceMetrics(InstanceMode.SINGLETON_ON_DEMAND);
        theReactor.addDependency(ComponentB2.class).withInstanceMetrics(InstanceMode.SINGLETON_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentX[])theCtx.getInstancesByType(ComponentX.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentB[])theCtx.getInstancesByType(ComponentB.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentB1[])theCtx.getInstancesByType(ComponentB1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentB2[])theCtx.getInstancesByType(ComponentB2.class)).length);
        Assertions.assertEquals((int)7, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testContext3() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentX.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentB.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentB1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentB2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentX[])theCtx.getInstancesByType(ComponentX.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentB[])theCtx.getInstancesByType(ComponentB.class)).length);
        Assertions.assertEquals((int)2, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)2, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)2, (int)((ComponentB1[])theCtx.getInstancesByType(ComponentB1.class)).length);
        Assertions.assertEquals((int)2, (int)((ComponentB2[])theCtx.getInstancesByType(ComponentB2.class)).length);
        Assertions.assertEquals((int)11, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testContext4() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentX.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(ComponentY.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentB.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentB1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentB2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentX[])theCtx.getInstancesByType(ComponentX.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentY[])theCtx.getInstancesByType(ComponentY.class)).length);
        Assertions.assertEquals((int)2, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)2, (int)((ComponentB[])theCtx.getInstancesByType(ComponentB.class)).length);
        Assertions.assertEquals((int)4, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)4, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)4, (int)((ComponentB1[])theCtx.getInstancesByType(ComponentB1.class)).length);
        Assertions.assertEquals((int)4, (int)((ComponentB2[])theCtx.getInstancesByType(ComponentB2.class)).length);
        Assertions.assertEquals((int)22, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testContext5() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentX.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(ComponentY.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentB.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.SINGLETON_ON_DEMAND);
        theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentB1.class).withInstanceMetrics(InstanceMode.SINGLETON_ON_DEMAND);
        theReactor.addDependency(ComponentB2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        Assertions.assertEquals((int)1, (int)((ComponentX[])theCtx.getInstancesByType(ComponentX.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentY[])theCtx.getInstancesByType(ComponentY.class)).length);
        Assertions.assertEquals((int)2, (int)((ComponentA[])theCtx.getInstancesByType(ComponentA.class)).length);
        Assertions.assertEquals((int)2, (int)((ComponentB[])theCtx.getInstancesByType(ComponentB.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentA1[])theCtx.getInstancesByType(ComponentA1.class)).length);
        Assertions.assertEquals((int)4, (int)((ComponentA2[])theCtx.getInstancesByType(ComponentA2.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentB1[])theCtx.getInstancesByType(ComponentB1.class)).length);
        Assertions.assertEquals((int)4, (int)((ComponentB2[])theCtx.getInstancesByType(ComponentB2.class)).length);
        Assertions.assertEquals((int)16, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testDuplicateDependencyException1() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            theReactor.addDependency(ComponentA1.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            theReactor.addDependency(ComponentA2.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + DuplicateDependencyException.class.getName() + ">!"));
            }
            catch (DuplicateDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testUnsatisfiedDependenciesException1() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentX.class);
            theReactor.addDependency(ComponentA.class);
            theReactor.addDependency(ComponentB.class);
            theReactor.addDependency(ComponentA1.class);
            theReactor.addDependency(ComponentB1.class);
            theReactor.addDependency(ComponentB2.class);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + UnsatisfiedDependencyException.class.getName() + ">!"));
            }
            catch (UnsatisfiedDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testUnsatisfiedDependenciesException2() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + UnsatisfiedDependencyException.class.getName() + ">!"));
            }
            catch (UnsatisfiedDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testUnsatisfiedDependenciesOnDemand() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentA.class).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    private void log(Context aCtx) {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("################################################################################");
            System.out.println("PROFILES = " + VerboseTextBuilder.asString((Object[])aCtx.getProfiles()));
            System.out.println("################################################################################");
            for (Dependency eDependency : aCtx.getDependencies()) {
                System.out.println("DEPENDENCY: " + String.valueOf(eDependency));
            }
            System.out.println("--------------------------------------------------------------------------------");
            boolean hasDependency = false;
            for (Dependency eDependency : aCtx.getDependencies()) {
                for (Object eObj : eDependency.getInstances()) {
                    hasDependency = true;
                    System.out.println(String.valueOf(eDependency.getInstanceMetrics()) + ": " + String.valueOf(eObj));
                }
            }
            if (!hasDependency) {
                System.out.println("(no dependencies)");
            }
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println(aCtx.toSchema());
        }
    }
}

