/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.decoupling.ComponentQ;
import org.refcodes.decoupling.ComponentQ1;
import org.refcodes.decoupling.ComponentQ2;
import org.refcodes.decoupling.Context;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencyException;
import org.refcodes.decoupling.InstanceMode;
import org.refcodes.decoupling.QFactory;
import org.refcodes.decoupling.Reactor;
import org.refcodes.decoupling.UnsatisfiedFactoryException;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class FactoryTest {
    @Test
    public void testFactoryClaim() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class).withAlias("Q").withAddClaim(ComponentQ1.class, "Q1").withAddClaim(ComponentQ2.class, "Q2");
        theReactor.addDependency(ComponentQ1.class).withAlias("Q1").withFactory(ComponentQ2.class, d -> new ComponentQ1("Hello " + d.getAlias()));
        theReactor.addDependency((Object)new ComponentQ2("ComponentQ2")).withAlias("Q2");
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        ComponentQ1 theQ1 = (ComponentQ1)theCtx.getFirstByType(ComponentQ1.class);
        Assertions.assertEquals((Object)"Hello ComponentQ2", (Object)theQ1.getAlias());
    }

    @Test
    public void testUnsatisfiedFactoryException() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentQ.class).withAlias("Q").withAddClaim(ComponentQ1.class, "Q1").withAddClaim(ComponentQ2.class, "Q2");
            theReactor.addDependency(ComponentQ1.class).withAlias("Q1").withFactory(ComponentQ2.class, d -> new ComponentQ1("Hello " + d.getAlias()), "XYZ");
            theReactor.addDependency((Object)new ComponentQ2("ComponentQ2")).withAlias("Q2");
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + UnsatisfiedFactoryException.class.getName() + ">!"));
            }
            catch (UnsatisfiedFactoryException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    @Test
    public void testFactoryFromDependency1() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class, QFactory.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency((Object)new ComponentQ1("Q1"));
        theReactor.addDependency((Object)new ComponentQ2("Q2"));
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        ComponentQ theQ = (ComponentQ)theCtx.getFirstByType(ComponentQ.class);
        Assertions.assertEquals((Object)"Q1+Q2", (Object)theQ.getAlias());
        Assertions.assertNull((Object)theQ.getQ1());
        Assertions.assertNull((Object)theQ.getQ2());
    }

    @Test
    public void testFactoryFromDependency2() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class, QFactory.class, QFactory::fabricateQ).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency((Object)new ComponentQ1("Q1"));
        theReactor.addDependency((Object)new ComponentQ2("Q2"));
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        ComponentQ theQ = (ComponentQ)theCtx.getFirstByType(ComponentQ.class);
        Assertions.assertEquals((Object)"Q1+Q2", (Object)theQ.getAlias());
        Assertions.assertNull((Object)theQ.getQ1());
        Assertions.assertNull((Object)theQ.getQ2());
    }

    @Test
    public void testFactoryFromDependencyFacty() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class, QFactory.class).withInstanceMetrics(InstanceMode.INSTANCE_IS_MANDATORY);
        theReactor.addDependency(ComponentQ1.class, () -> new ComponentQ1("Q1")).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        theReactor.addDependency(ComponentQ2.class, () -> new ComponentQ2("Q2")).withInstanceMetrics(InstanceMode.INSTANCE_ON_DEMAND);
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        ComponentQ theQ = (ComponentQ)theCtx.getFirstByType(ComponentQ.class);
        Assertions.assertEquals((Object)"Q1+Q2", (Object)theQ.getAlias());
        Assertions.assertNull((Object)theQ.getQ1());
        Assertions.assertNull((Object)theQ.getQ2());
    }

    private void log(Context aCtx) {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("################################################################################");
            System.out.println("PROFILES = " + VerboseTextBuilder.asString((Object[])aCtx.getProfiles()));
            System.out.println("################################################################################");
            for (Dependency eDependency : aCtx.getDependencies()) {
                System.out.println("DEPENDENCY: " + String.valueOf(eDependency));
            }
            System.out.println("--------------------------------------------------------------------------------");
            boolean hasDependency = false;
            for (Dependency eDependency : aCtx.getDependencies()) {
                for (Object eObj : eDependency.getInstances()) {
                    hasDependency = true;
                    System.out.println(String.valueOf(eDependency.getInstanceMetrics()) + ": " + String.valueOf(eObj));
                }
            }
            if (!hasDependency) {
                System.out.println("(no dependencies)");
            }
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println(aCtx.toSchema());
        }
    }
}

