/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.decoupling.ComponentQ;
import org.refcodes.decoupling.ComponentQ1;
import org.refcodes.decoupling.ComponentQ2;
import org.refcodes.decoupling.Context;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencyException;
import org.refcodes.decoupling.Reactor;
import org.refcodes.decoupling.UnsatisfiedInitializerException;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class InitializerTest {
    @Test
    public void testInitializer1() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class);
        theReactor.addDependency(ComponentQ1.class).withInitializer(ComponentQ2.class);
        theReactor.addDependency((Object)new ComponentQ2("ComponentQ2"));
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        ComponentQ1 theQ1 = (ComponentQ1)theCtx.getFirstByType(ComponentQ1.class);
        Assertions.assertEquals((Object)"Hello ComponentQ2", (Object)theQ1.getAlias());
    }

    @Test
    public void testInitializer2() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class);
        theReactor.addDependency(ComponentQ1.class).withInitializer(ComponentQ2.class, (t, d) -> {
            t.setAlias("Hello " + d.getAlias());
            return t;
        });
        theReactor.addDependency((Object)new ComponentQ2("ComponentQ2"));
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        ComponentQ1 theQ1 = (ComponentQ1)theCtx.getFirstByType(ComponentQ1.class);
        Assertions.assertEquals((Object)"Hello ComponentQ2", (Object)theQ1.getAlias());
    }

    @Test
    public void testInitializer3() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class).withAlias("Q").withAddClaim(ComponentQ1.class, "Q1").withAddClaim(ComponentQ2.class, "Q2");
        theReactor.addDependency(ComponentQ1.class).withAlias("Q1").withInitializer(ComponentQ2.class, (t, d) -> {
            t.setAlias("Hello " + d.getAlias());
            return t;
        }, "Q2");
        theReactor.addDependency((Object)new ComponentQ2("ComponentQ2")).withAlias("Q2");
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        ComponentQ1 theQ1 = (ComponentQ1)theCtx.getFirstByType(ComponentQ1.class);
        Assertions.assertEquals((Object)"Hello ComponentQ2", (Object)theQ1.getAlias());
    }

    @Test
    public void testInitializer4() throws DependencyException {
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class).withAlias("Q").withAddClaim(ComponentQ1.class, "Q1").withAddClaim(ComponentQ2.class, "Q2");
        theReactor.addDependency((Object)new ComponentQ1("ComponentQ1")).withAlias("Q1").withInitializer(ComponentQ2.class, (t, c) -> {
            t.setAlias("Hello " + c.getAlias());
            return t;
        });
        theReactor.addDependency((Object)new ComponentQ2("ComponentQ2")).withAlias("Q2");
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
        ComponentQ1 theQ1 = (ComponentQ1)theCtx.getFirstByType(ComponentQ1.class);
        Assertions.assertEquals((Object)"Hello ComponentQ2", (Object)theQ1.getAlias());
    }

    @Test
    public void testUnsatisfiedInitializerException2() throws DependencyException {
        block3: {
            Reactor theReactor = new Reactor();
            theReactor.addDependency(ComponentQ.class).withAlias("Q").withAddClaim(ComponentQ1.class, "Q1").withAddClaim(ComponentQ2.class, "Q2");
            theReactor.addDependency(ComponentQ1.class).withAlias("Q1").withInitializer(ComponentQ2.class, (t, d) -> {
                t.setAlias("Hello " + d.getAlias());
                return t;
            }, "XYZ");
            theReactor.addDependency((Object)new ComponentQ2("ComponentQ2")).withAlias("Q2");
            try {
                Context theCtx = theReactor.createContext();
                this.log(theCtx);
                Assertions.fail((String)("Expecting an exception of type <" + UnsatisfiedInitializerException.class.getName() + ">!"));
            }
            catch (UnsatisfiedInitializerException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block3;
                System.out.println("################################################################################");
                System.out.println("EXPECTED: " + e.getMessage());
                System.out.println("################################################################################");
            }
        }
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    private void log(Context aCtx) {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("################################################################################");
            System.out.println("PROFILES = " + VerboseTextBuilder.asString((Object[])aCtx.getProfiles()));
            System.out.println("################################################################################");
            for (Dependency eDependency : aCtx.getDependencies()) {
                System.out.println("DEPENDENCY: " + String.valueOf(eDependency));
            }
            System.out.println("--------------------------------------------------------------------------------");
            boolean hasDependency = false;
            for (Dependency eDependency : aCtx.getDependencies()) {
                for (Object eObj : eDependency.getInstances()) {
                    hasDependency = true;
                    System.out.println(String.valueOf(eDependency.getInstanceMetrics()) + ": " + String.valueOf(eObj));
                }
            }
            if (!hasDependency) {
                System.out.println("(no dependencies)");
            }
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println(aCtx.toSchema());
        }
    }
}

