/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.decoupling.ComponentQ;
import org.refcodes.decoupling.ComponentQ1;
import org.refcodes.decoupling.ComponentQ2;
import org.refcodes.decoupling.Context;
import org.refcodes.decoupling.Dependency;
import org.refcodes.decoupling.DependencyException;
import org.refcodes.decoupling.Reactor;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;

public class InterceptorTest {
    @Test
    public void testInterceptors() throws DependencyException {
        int[] count = new int[]{0, 0};
        String theQ2Alias = "Interceptor's alias!";
        Reactor theReactor = new Reactor();
        theReactor.addDependency(ComponentQ.class);
        theReactor.addDependency(ComponentQ1.class);
        theReactor.addDependency(ComponentQ2.class);
        theReactor.addInterceptor((t, d) -> {
            count[0] = count[0] + 1;
            return t;
        });
        theReactor.addInterceptor((t, d) -> {
            count[1] = count[1] + 1;
            if (t instanceof ComponentQ2) {
                ComponentQ2 q2 = (ComponentQ2)t;
                q2.setAlias("Interceptor's alias!");
            }
            return t;
        });
        Context theCtx = theReactor.createContext();
        this.log(theCtx);
        ComponentQ2 theQ2 = (ComponentQ2)theCtx.getFirstByType(ComponentQ2.class);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Interceptor 1 invoked <" + count[0] + "> times ...");
            System.out.println("Interceptor 2 invoked <" + count[1] + "> times ...");
            System.out.println("The Q2's alias = \"" + theQ2.getAlias() + "\" ...");
        }
        Assertions.assertEquals((Object)"Interceptor's alias!", (Object)theQ2.getAlias());
        Assertions.assertEquals((int)3, (int)count[0]);
        Assertions.assertEquals((int)3, (int)count[1]);
        Assertions.assertEquals((int)1, (int)((ComponentQ[])theCtx.getInstancesByType(ComponentQ.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentQ1[])theCtx.getInstancesByType(ComponentQ1.class)).length);
        Assertions.assertEquals((int)1, (int)((ComponentQ2[])theCtx.getInstancesByType(ComponentQ2.class)).length);
        Assertions.assertEquals((int)3, (int)theCtx.getInstances().length);
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println();
        }
    }

    private void log(Context aCtx) {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("################################################################################");
            System.out.println("PROFILES = " + VerboseTextBuilder.asString((Object[])aCtx.getProfiles()));
            System.out.println("################################################################################");
            for (Dependency eDependency : aCtx.getDependencies()) {
                System.out.println("DEPENDENCY: " + String.valueOf(eDependency));
            }
            System.out.println("--------------------------------------------------------------------------------");
            boolean hasDependency = false;
            for (Dependency eDependency : aCtx.getDependencies()) {
                for (Object eObj : eDependency.getInstances()) {
                    hasDependency = true;
                    System.out.println(String.valueOf(eDependency.getInstanceMetrics()) + ": " + String.valueOf(eObj));
                }
            }
            if (!hasDependency) {
                System.out.println("(no dependencies)");
            }
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println(aCtx.toSchema());
        }
    }
}

