/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import org.refcodes.decoupling.ComponentQ;
import org.refcodes.decoupling.ComponentQ1;
import org.refcodes.decoupling.ComponentQ2;
import org.refcodes.factory.Factory;

public class QFactory
implements Factory<ComponentQ> {
    private final ComponentQ1 q1;
    private final ComponentQ2 q2;

    public QFactory(ComponentQ1 q1, ComponentQ2 q2) {
        this.q1 = q1;
        this.q2 = q2;
    }

    public ComponentQ1 getQ1() {
        return this.q1;
    }

    public ComponentQ2 getQ2() {
        return this.q2;
    }

    public ComponentQ create() {
        return new ComponentQ(this.q1.getAlias() + "+" + this.q2.getAlias());
    }

    public ComponentQ fabricateQ() {
        return new ComponentQ(this.q1.getAlias() + "+" + this.q2.getAlias());
    }

    public String toString() {
        return super.toString().substring(super.toString().indexOf(64) + 1) + "@" + this.getClass().getSimpleName() + " [q1=" + String.valueOf(this.q1) + ", q2=" + String.valueOf(this.q2) + "]";
    }
}

