/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.decoupling;

import java.lang.reflect.Constructor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.decoupling.ComponentA;
import org.refcodes.decoupling.ComponentA1;
import org.refcodes.decoupling.ComponentA2;
import org.refcodes.decoupling.ComponentB;
import org.refcodes.decoupling.ComponentB1;
import org.refcodes.decoupling.ComponentB2;
import org.refcodes.decoupling.ComponentX;
import org.refcodes.decoupling.DependencyBuilder;
import org.refcodes.decoupling.DependencyException;
import org.refcodes.decoupling.Reactor;
import org.refcodes.decoupling.UnsatisfiedDependencyException;
import org.refcodes.runtime.SystemProperty;

public class ReactorTest {
    @Test
    public void testReactor1() throws DependencyException {
        Reactor theReactor = new Reactor();
        DependencyBuilder theX = theReactor.addDependency(ComponentX.class);
        theReactor.addDependency(ComponentA.class);
        theReactor.addDependency(ComponentB.class);
        theReactor.addDependency(ComponentA1.class);
        theReactor.addDependency(ComponentA2.class);
        theReactor.addDependency(ComponentB1.class);
        theReactor.addDependency(ComponentB2.class);
        DependencyBuilder theImpl = theX;
        Constructor[] theResult = theImpl.toSuitableConstructors(theReactor.toDependencies(new Object[0]), new Object[0]);
        Assertions.assertEquals(ComponentA.class, theResult[0].getParameters()[0].getType());
        Assertions.assertEquals(ComponentB.class, theResult[0].getParameters()[1].getType());
        Assertions.assertEquals(ComponentA1.class, theResult[0].getParameters()[2].getType());
        Assertions.assertEquals(ComponentA2.class, theResult[0].getParameters()[3].getType());
        Assertions.assertEquals(ComponentB1.class, theResult[0].getParameters()[4].getType());
        Assertions.assertEquals(ComponentB2.class, theResult[0].getParameters()[5].getType());
        Assertions.assertEquals((int)6, (int)theResult[0].getParameters().length);
        Assertions.assertEquals(ComponentB2.class, theResult[4].getParameters()[0].getType());
        Assertions.assertEquals((int)1, (int)theResult[4].getParameters().length);
    }

    @Test
    public void testReactor2() throws DependencyException {
        block2: {
            Reactor theReactor = new Reactor();
            DependencyBuilder theX = theReactor.addDependency(ComponentX.class);
            try {
                DependencyBuilder theImpl = theX;
                theImpl.toSuitableConstructors(theReactor.toDependencies(new Object[0]), new Object[0]);
            }
            catch (UnsatisfiedDependencyException e) {
                if (!SystemProperty.LOG_TESTS.isEnabled()) break block2;
                System.out.println("EXPECTED: " + e.getMessage());
            }
        }
    }

    @Test
    public void testProfiles1() {
        Reactor theReactor = new Reactor();
        DependencyBuilder theX = theReactor.addDependency(ComponentX.class).withProfiles(new Object[]{"test", "local"});
        boolean hasProfile = theX.hasProfile(new Object[]{"test"});
        Assertions.assertTrue((boolean)hasProfile);
    }

    @Test
    public void testProfiles2() {
        Reactor theReactor = new Reactor();
        DependencyBuilder theX = theReactor.addDependency(ComponentX.class).withProfiles(new Object[]{"test", "local"});
        boolean hasProfile = theX.hasProfile(new Object[]{"prod"});
        Assertions.assertFalse((boolean)hasProfile);
    }

    @Test
    public void testProfiles3() {
        Reactor theReactor = new Reactor();
        DependencyBuilder theX = theReactor.addDependency(ComponentX.class).withProfiles(new Object[]{"test", "local"});
        boolean hasProfile = theX.hasProfile(new Object[]{"prod", "test"});
        Assertions.assertTrue((boolean)hasProfile);
    }

    @Test
    public void testProfiles4() {
        Reactor theReactor = new Reactor();
        DependencyBuilder theX = theReactor.addDependency(ComponentX.class).withProfiles(new Object[]{"test", "local"});
        boolean hasProfile = theX.hasProfile(new Object[]{"prod", "int"});
        Assertions.assertFalse((boolean)hasProfile);
    }

    @Test
    public void testProfiles5() {
        Reactor theReactor = new Reactor();
        DependencyBuilder theX = theReactor.addDependency(ComponentX.class).withProfiles(new Object[]{"test", "local"});
        boolean hasProfile = theX.hasProfile(new Object[0]);
        Assertions.assertFalse((boolean)hasProfile);
    }

    @Test
    public void testProfiles6() {
        Reactor theReactor = new Reactor();
        DependencyBuilder theX = theReactor.addDependency(ComponentX.class);
        boolean hasProfile = theX.hasProfile(new Object[]{"test", "local"});
        Assertions.assertTrue((boolean)hasProfile);
    }
}

