/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.eventbus;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.component.HandleGenerator;
import org.refcodes.component.UnknownHandleRuntimeException;
import org.refcodes.eventbus.EventBusObservable;
import org.refcodes.eventbus.EventBusPublisher;
import org.refcodes.observer.Event;
import org.refcodes.observer.EventMatcher;
import org.refcodes.observer.Observer;
import org.refcodes.observer.ObserverDescriptor;
import org.refcodes.observer.ObserverDescriptorImpl;

public abstract class AbstractEventBus<E extends Event<?>, O extends Observer<E>, EM extends EventMatcher<E>, H>
implements EventBusObservable<E, O, EM, H>,
EventBusPublisher<E> {
    private Map<H, ObserverDescriptor<E, O, EM>> _handleToObserverDescriptors = new HashMap<H, ObserverDescriptor<E, O, EM>>();
    private HandleGenerator<H> _handleGenerator;

    public AbstractEventBus(HandleGenerator<H> aHandleGenerator) {
        assert (aHandleGenerator != null);
        this._handleGenerator = aHandleGenerator;
    }

    public void publishEvent(E aEvent) {
        Collection<ObserverDescriptor<E, O, EM>> theDescriptorList = this._handleToObserverDescriptors.values();
        for (ObserverDescriptor<E, O, EM> eEventListenerDescriptor : theDescriptorList) {
            eEventListenerDescriptor.onEvent(aEvent);
        }
    }

    public boolean isMatching(E aEvent) {
        Collection<ObserverDescriptor<E, O, EM>> theListenerList = this._handleToObserverDescriptors.values();
        for (ObserverDescriptor<E, O, EM> eEventListenerDescriptor : theListenerList) {
            if (!eEventListenerDescriptor.getEventMatcher().isMatching(aEvent)) continue;
            return true;
        }
        return false;
    }

    @Override
    public H subscribe(O aObserver, EM aEventMatcher) {
        Object theHandle = this._handleGenerator.next();
        this._handleToObserverDescriptors.put((H)theHandle, (ObserverDescriptor<E, O, EM>)new ObserverDescriptorImpl(aObserver, aEventMatcher));
        return (H)theHandle;
    }

    @Override
    public void unsubscribeAll(O aObserver) {
        Iterator<ObserverDescriptor<E, O, EM>> e = this._handleToObserverDescriptors.values().iterator();
        while (e.hasNext()) {
            ObserverDescriptor<E, O, EM> eReference = e.next();
            if (eReference.getObserver() != aObserver) continue;
            e.remove();
        }
    }

    public boolean hasHandle(H aHandle) {
        return this._handleToObserverDescriptors.containsKey(aHandle);
    }

    public O lookupHandle(H aHandle) throws UnknownHandleRuntimeException {
        ObserverDescriptor<E, O, EM> theReference = this._handleToObserverDescriptors.get(aHandle);
        if (theReference == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this system.");
        }
        return (O)theReference.getObserver();
    }

    public O removeHandle(H aHandle) throws UnknownHandleRuntimeException {
        ObserverDescriptor<E, O, EM> theReference = this._handleToObserverDescriptors.remove(aHandle);
        if (theReference == null) {
            throw new UnknownHandleRuntimeException(aHandle, "The given handle is not known by this system.");
        }
        return (O)theReference.getObserver();
    }
}

