/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.eventbus;

import org.refcodes.eventbus.EventBusMatcher;
import org.refcodes.matcher.Matcher;
import org.refcodes.matcher.MatcherSugar;
import org.refcodes.observer.EventMetaData;
import org.refcodes.observer.MetaDataActionEvent;
import org.refcodes.observer.MetaDataEvent;

public class EventBusMatcherSugar {
    public static EventBusMatcher isAssignableFrom(Class<?> aEventType) {
        Matcher theAssignableFrom = MatcherSugar.isAssignableFrom(aEventType);
        return new EventBusMatcherWrapper(theAssignableFrom);
    }

    public static <E extends MetaDataEvent<?>, PT> EventBusMatcher publisherIsAssignableFrom(Class<? extends PT> aPublisherType) {
        return new PublisherIsAssignableFromMatcherImpl(aPublisherType);
    }

    @SafeVarargs
    public static EventBusMatcher or(EventBusMatcher ... aEventMatchers) {
        return new EventBusMatcherWrapper(MatcherSugar.or((Matcher[])aEventMatchers));
    }

    @SafeVarargs
    public static EventBusMatcher and(EventBusMatcher ... aEventMatchers) {
        return new EventBusMatcherWrapper(MatcherSugar.and((Matcher[])aEventMatchers));
    }

    public static EventBusMatcher nameEqualWith(String aName) {
        return new NameEqualWithMatcherImpl(aName);
    }

    public static EventBusMatcher groupEqualWith(String aGroup) {
        return new GroupEqualWithMatcherImpl(aGroup);
    }

    public static EventBusMatcher channelEqualWith(String aChannel) {
        return new ChannelEqualWithMatcherImpl(aChannel);
    }

    public static EventBusMatcher universalIdEqualWith(String aUniversalId) {
        return new UniversalIdEqualWithMatcherImpl(aUniversalId);
    }

    public static <E extends MetaDataEvent<?>, A> EventBusMatcher actionEqualWith(A aAction) {
        return new ActionEqualWithMatcherImpl(aAction);
    }

    private static class ActionEqualWithMatcherImpl
    implements EventBusMatcher {
        private Object _action;

        public <A> ActionEqualWithMatcherImpl(A aAction) {
            this._action = aAction;
        }

        public boolean isMatching(MetaDataEvent<?> aEvent) {
            assert (aEvent != null);
            if (!(aEvent instanceof MetaDataActionEvent)) {
                return false;
            }
            MetaDataActionEvent theEvent = (MetaDataActionEvent)aEvent;
            if (this._action != null) {
                return this._action.equals(theEvent.getAction());
            }
            return theEvent.getAction() == null;
        }
    }

    private static class UniversalIdEqualWithMatcherImpl
    implements EventBusMatcher {
        private String _universalId;

        public UniversalIdEqualWithMatcherImpl(String aUniversalId) {
            this._universalId = aUniversalId;
        }

        public boolean isMatching(MetaDataEvent<?> aEvent) {
            assert (aEvent != null);
            if (this._universalId != null) {
                return this._universalId.equals(((EventMetaData)aEvent.getMetaData()).getUniversalId());
            }
            return ((EventMetaData)aEvent.getMetaData()).getUniversalId() == null;
        }
    }

    private static class ChannelEqualWithMatcherImpl
    implements EventBusMatcher {
        private String _channel;

        public ChannelEqualWithMatcherImpl(String aChannel) {
            this._channel = aChannel;
        }

        public boolean isMatching(MetaDataEvent<?> aEvent) {
            assert (aEvent != null);
            if (this._channel != null) {
                return this._channel.equals(((EventMetaData)aEvent.getMetaData()).getChannel());
            }
            return ((EventMetaData)aEvent.getMetaData()).getChannel() == null;
        }
    }

    private static class GroupEqualWithMatcherImpl
    implements EventBusMatcher {
        private String _group;

        public GroupEqualWithMatcherImpl(String aGroup) {
            this._group = aGroup;
        }

        public boolean isMatching(MetaDataEvent<?> aEvent) {
            assert (aEvent != null);
            if (this._group != null) {
                return this._group.equals(((EventMetaData)aEvent.getMetaData()).getGroup());
            }
            return ((EventMetaData)aEvent.getMetaData()).getGroup() == null;
        }
    }

    private static class NameEqualWithMatcherImpl
    implements EventBusMatcher {
        private String _name;

        public NameEqualWithMatcherImpl(String aName) {
            this._name = aName;
        }

        public boolean isMatching(MetaDataEvent<?> aEvent) {
            assert (aEvent != null);
            if (this._name != null) {
                return this._name.equals(((EventMetaData)aEvent.getMetaData()).getName());
            }
            return ((EventMetaData)aEvent.getMetaData()).getName() == null;
        }
    }

    private static class PublisherIsAssignableFromMatcherImpl<E extends MetaDataEvent<?>, PT>
    implements EventBusMatcher {
        private Class<? extends PT> _eventPublisherType;

        public PublisherIsAssignableFromMatcherImpl(Class<? extends PT> aEventPublisherType) {
            this._eventPublisherType = aEventPublisherType;
        }

        public boolean isMatching(MetaDataEvent<?> aEvent) {
            assert (aEvent != null);
            return this._eventPublisherType == null || ((EventMetaData)aEvent.getMetaData()).getPublisherType().isAssignableFrom(this._eventPublisherType);
        }
    }

    private static class EventBusMatcherWrapper
    implements EventBusMatcher {
        private Matcher<MetaDataEvent<?>> _eventMatcher;

        public EventBusMatcherWrapper(Matcher<MetaDataEvent<?>> aMatcher) {
            assert (aMatcher != null);
            this._eventMatcher = aMatcher;
        }

        public boolean isMatching(MetaDataEvent<?> aEvent) {
            return this._eventMatcher.isMatching(aEvent);
        }
    }
}

