/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.eventbus;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.eventbus.EventBusImpl;
import org.refcodes.eventbus.EventBusMatcher;
import org.refcodes.eventbus.EventBusMatcherSugar;
import org.refcodes.eventbus.EventBusObserver;
import org.refcodes.mixin.MessageAccessor;
import org.refcodes.observer.Event;
import org.refcodes.observer.EventMatcher;
import org.refcodes.observer.EventMetaData;
import org.refcodes.observer.MetaDataActionEvent;
import org.refcodes.observer.MetaDataActionEventImpl;
import org.refcodes.observer.MetaDataEvent;
import org.refcodes.observer.MetaDataEventImpl;
import org.refcodes.observer.Observer;

public class EventBusTest {
    private static Logger LOGGER = Logger.getLogger(EventBusTest.class);
    private EventBusImpl _eventBus = new EventBusImpl();

    @Test
    public void testChannel() {
        EventBusMatcher theSportsMatcher = EventBusMatcherSugar.or((EventBusMatcher[])new EventBusMatcher[]{EventBusMatcherSugar.channelEqualWith((String)"Soccer"), EventBusMatcherSugar.channelEqualWith((String)"Football")});
        EventBusMatcher thePoliticsMatcher = EventBusMatcherSugar.or((EventBusMatcher[])new EventBusMatcher[]{EventBusMatcherSugar.channelEqualWith((String)"War"), EventBusMatcherSugar.channelEqualWith((String)"Education")});
        EventBusObserver theSportsObserver = new EventBusObserver(){

            public void onEvent(MetaDataEvent<?> aEvent) {
                LOGGER.debug((Object)("Got a sports event on channel <" + ((EventMetaData)aEvent.getMetaData()).getChannel() + ">"));
            }
        };
        EventBusObserver thePoliticsObserver = new EventBusObserver(){

            public void onEvent(MetaDataEvent<?> aEvent) {
                LOGGER.debug((Object)("Got a politics event on channel <" + ((EventMetaData)aEvent.getMetaData()).getChannel() + ">"));
            }
        };
        EventBusImpl theEventBus = new EventBusImpl();
        theEventBus.subscribe((Observer)theSportsObserver, (EventMatcher)theSportsMatcher);
        theEventBus.subscribe((Observer)thePoliticsObserver, (EventMatcher)thePoliticsMatcher);
        theEventBus.publishEvent((Event)new MetaDataEventImpl("Soccer", (Object)this));
        theEventBus.publishEvent((Event)new MetaDataEventImpl("Education", (Object)this));
        theEventBus.publishEvent((Event)new MetaDataEventImpl("Football", (Object)this));
        theEventBus.publishEvent((Event)new MetaDataEventImpl("War", (Object)this));
        theEventBus.publishEvent((Event)new MetaDataEventImpl("Formular 1", (Object)this));
        theEventBus.publishEvent((Event)new MetaDataEventImpl("Top Secret", (Object)this));
        Assertions.assertFalse((boolean)theEventBus.isMatching((Event)new MetaDataEventImpl("Top Secret", (Object)this)));
        Assertions.assertTrue((boolean)theEventBus.isMatching((Event)new MetaDataEventImpl("Soccer", (Object)this)));
        Assertions.assertTrue((boolean)theEventBus.isMatching((Event)new MetaDataEventImpl("Education", (Object)this)));
    }

    @Test
    public void testEventBus() {
        EventBusMatcher theInitMatcher = EventBusMatcherSugar.and((EventBusMatcher[])new EventBusMatcher[]{EventBusMatcherSugar.nameEqualWith((String)"EventBusTest"), EventBusMatcherSugar.groupEqualWith((String)"org.refcodes.eventbus"), EventBusMatcherSugar.actionEqualWith((Object)((Object)Action.INIT))});
        TestActionObserverImpl theInitObserver = new TestActionObserverImpl(Action.INIT);
        String theInitHandle = (String)this._eventBus.subscribe((Observer)theInitObserver, (EventMatcher)theInitMatcher);
        EventBusMatcher theStartMatcher = EventBusMatcherSugar.and((EventBusMatcher[])new EventBusMatcher[]{EventBusMatcherSugar.nameEqualWith((String)"EventBusTest"), EventBusMatcherSugar.groupEqualWith((String)"org.refcodes.eventbus"), EventBusMatcherSugar.actionEqualWith((Object)((Object)Action.START))});
        TestActionObserverImpl theStartObserver = new TestActionObserverImpl(Action.START);
        String theStartHandle = (String)this._eventBus.subscribe((Observer)theStartObserver, (EventMatcher)theStartMatcher);
        EventBusMatcher theStopMatcher = EventBusMatcherSugar.and((EventBusMatcher[])new EventBusMatcher[]{EventBusMatcherSugar.nameEqualWith((String)"EventBusTest"), EventBusMatcherSugar.groupEqualWith((String)"org.refcodes.eventbus"), EventBusMatcherSugar.actionEqualWith((Object)((Object)Action.STOP))});
        TestActionObserverImpl theStopObserver = new TestActionObserverImpl(Action.STOP);
        String theStopHandle = (String)this._eventBus.subscribe((Observer)theStopObserver, (EventMatcher)theStopMatcher);
        EventBusMatcher theDestroyMatcher = EventBusMatcherSugar.and((EventBusMatcher[])new EventBusMatcher[]{EventBusMatcherSugar.nameEqualWith((String)"EventBusTest"), EventBusMatcherSugar.groupEqualWith((String)"org.refcodes.eventbus"), EventBusMatcherSugar.actionEqualWith((Object)((Object)Action.DESTROY))});
        TestActionObserverImpl theDestroyObserver = new TestActionObserverImpl(Action.DESTROY);
        String theDestroyHandle = (String)this._eventBus.subscribe((Observer)theDestroyObserver, (EventMatcher)theDestroyMatcher);
        EventBusMatcher theMessageMatcher = EventBusMatcherSugar.and((EventBusMatcher[])new EventBusMatcher[]{EventBusMatcherSugar.nameEqualWith((String)"TestMessageEventImpl"), EventBusMatcherSugar.groupEqualWith((String)"org.refcodes.eventbus"), EventBusMatcherSugar.isAssignableFrom(TestMessageEventImpl.class)});
        TestMessageObserverImpl theMessageObserver = new TestMessageObserverImpl();
        String theMessageHandle = (String)this._eventBus.subscribe((Observer)theMessageObserver, (EventMatcher)theMessageMatcher);
        this._eventBus.publishEvent((Event)new MetaDataActionEventImpl((Object)Action.INIT, (Object)this));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((Event)new MetaDataActionEventImpl((Object)Action.START, (Object)this));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((Event)new MetaDataActionEventImpl((Object)Action.STOP, (Object)this));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((Event)new MetaDataActionEventImpl((Object)Action.DESTROY, (Object)this));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((Event)new TestMessageEventImpl("1-2-3 Alert!", this));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theMessageObserver.getEventCount());
        EventBusObserver theInitObserver2 = (EventBusObserver)this._eventBus.removeHandle((Object)theInitHandle);
        Assertions.assertEquals((Object)theInitObserver, (Object)theInitObserver2);
        EventBusObserver theStartObserver2 = (EventBusObserver)this._eventBus.removeHandle((Object)theStartHandle);
        Assertions.assertEquals((Object)theStartObserver, (Object)theStartObserver2);
        EventBusObserver theStopObserver2 = (EventBusObserver)this._eventBus.removeHandle((Object)theStopHandle);
        Assertions.assertEquals((Object)theStopObserver, (Object)theStopObserver2);
        EventBusObserver theDestroyObserver2 = (EventBusObserver)this._eventBus.removeHandle((Object)theDestroyHandle);
        Assertions.assertEquals((Object)theDestroyObserver, (Object)theDestroyObserver2);
        EventBusObserver theMessageObserver2 = (EventBusObserver)this._eventBus.removeHandle((Object)theMessageHandle);
        Assertions.assertEquals((Object)theMessageObserver, (Object)theMessageObserver2);
    }

    private class TestMessageEventImpl
    extends MetaDataEventImpl<Object>
    implements MessageAccessor {
        String _message;

        public TestMessageEventImpl(String aMessage, Object aSource) {
            super("MESSAGE", aSource);
            this._message = aMessage;
        }

        public String getMessage() {
            return this._message;
        }
    }

    private class TestMessageObserverImpl
    implements EventBusObserver {
        private int _eventCount = 0;

        public void onEvent(MetaDataEvent<?> aEvent) {
            String theAction = null;
            if (aEvent instanceof MetaDataActionEvent) {
                theAction = ((MetaDataActionEvent)aEvent).getAction().toString();
            }
            LOGGER.info((Object)("Action = " + theAction + ", Name = " + ((EventMetaData)aEvent.getMetaData()).getName() + ", Group = " + ((EventMetaData)aEvent.getMetaData()).getGroup() + ", UID = " + ((EventMetaData)aEvent.getMetaData()).getUniversalId() + ", publisher type = " + ((EventMetaData)aEvent.getMetaData()).getPublisherType().getName()));
            if (!(aEvent instanceof TestMessageEventImpl)) {
                throw new IllegalArgumentException("Expected an event of type \"" + TestMessageEventImpl.class.getName() + "\" but received the event \"" + aEvent.getClass().getName() + "\".");
            }
            ++this._eventCount;
        }

        public int getEventCount() {
            return this._eventCount;
        }
    }

    private class TestActionObserverImpl
    implements EventBusObserver {
        private Action _action;
        private int _eventCount = 0;

        public TestActionObserverImpl(Action aAction) {
            this._action = aAction;
        }

        public void onEvent(MetaDataEvent<?> aEvent) {
            MetaDataActionEvent theEvent = (MetaDataActionEvent)aEvent;
            LOGGER.info((Object)("Action = " + ((Action)((Object)theEvent.getAction())).toString() + ", Name = " + ((EventMetaData)aEvent.getMetaData()).getName() + ", Group = " + ((EventMetaData)aEvent.getMetaData()).getGroup() + ", UID = " + ((EventMetaData)aEvent.getMetaData()).getUniversalId() + ", publisher type = " + ((EventMetaData)aEvent.getMetaData()).getPublisherType().getName()));
            if (this._action != theEvent.getAction()) {
                throw new IllegalArgumentException("Expected an action <" + (Object)((Object)this._action) + "> but received the action <" + theEvent.getAction() + ">.");
            }
            ++this._eventCount;
        }

        public int getEventCount() {
            return this._eventCount;
        }
    }

    private static enum Action {
        INIT,
        START,
        STOP,
        DESTROY;

    }
}

