/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.eventbus;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.LifeCycleStatus;
import org.refcodes.eventbus.BusEvent;
import org.refcodes.eventbus.BusEventImpl;
import org.refcodes.eventbus.BusMatcher;
import org.refcodes.eventbus.BusMatcherSugar;
import org.refcodes.eventbus.BusObserver;
import org.refcodes.eventbus.EventBus;
import org.refcodes.eventbus.EventBusImpl;
import org.refcodes.mixin.MessageAccessor;
import org.refcodes.observer.EventMatcher;
import org.refcodes.observer.EventMetaData;
import org.refcodes.observer.GenericEvent;
import org.refcodes.observer.Observer;

public class EventBusTest {
    private static final boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private EventBusImpl _eventBus = new EventBusImpl();
    private int _typeEventCount = 0;

    @Test
    public void testChannel() {
        BusMatcher theSportsMatcher = BusMatcherSugar.or((BusMatcher[])new BusMatcher[]{BusMatcherSugar.channelEqualWith((String)"Soccer"), BusMatcherSugar.channelEqualWith((String)"Football")});
        BusMatcher thePoliticsMatcher = BusMatcherSugar.or((BusMatcher[])new BusMatcher[]{BusMatcherSugar.channelEqualWith((String)"War"), BusMatcherSugar.channelEqualWith((String)"Education")});
        BusObserver theSportsObserver = new BusObserver(){

            public void onEvent(BusEvent aEvent) {
                if (IS_LOG_TESTS) {
                    System.out.println("Got a sports event on channel <" + ((EventMetaData)aEvent.getMetaData()).getChannel() + ">");
                }
            }
        };
        BusObserver thePoliticsObserver = new BusObserver(){

            public void onEvent(BusEvent aEvent) {
                if (IS_LOG_TESTS) {
                    System.out.println("Got a politics event on channel <" + ((EventMetaData)aEvent.getMetaData()).getChannel() + ">");
                }
            }
        };
        EventBusImpl theEventBus = new EventBusImpl();
        theEventBus.subscribe((EventMatcher)theSportsMatcher, (Observer)theSportsObserver);
        theEventBus.subscribe((EventMatcher)thePoliticsMatcher, (Observer)thePoliticsObserver);
        theEventBus.publishEvent((GenericEvent)new BusEventImpl("Soccer", (EventBus)theEventBus));
        theEventBus.publishEvent((GenericEvent)new BusEventImpl("Education", (EventBus)theEventBus));
        theEventBus.publishEvent((GenericEvent)new BusEventImpl("Football", (EventBus)theEventBus));
        theEventBus.publishEvent((GenericEvent)new BusEventImpl("War", (EventBus)theEventBus));
        theEventBus.publishEvent((GenericEvent)new BusEventImpl("Formular 1", (EventBus)theEventBus));
        theEventBus.publishEvent((GenericEvent)new BusEventImpl("Top Secret", (EventBus)theEventBus));
        Assertions.assertFalse((boolean)theEventBus.isMatching((GenericEvent)new BusEventImpl("Top Secret", (EventBus)theEventBus)));
        Assertions.assertTrue((boolean)theEventBus.isMatching((GenericEvent)new BusEventImpl("Soccer", (EventBus)theEventBus)));
        Assertions.assertTrue((boolean)theEventBus.isMatching((GenericEvent)new BusEventImpl("Education", (EventBus)theEventBus)));
    }

    @Test
    public void testEventBus() {
        BusMatcher theInitMatcher = BusMatcherSugar.and((BusMatcher[])new BusMatcher[]{BusMatcherSugar.aliasEqualWith((String)"EventBusTest"), BusMatcherSugar.channelEqualWith((String)"org.refcodes.eventbus"), BusMatcherSugar.actionEqualWith((Object)LifeCycleStatus.INITIALIZED)});
        TestActionObserverImpl theInitObserver = new TestActionObserverImpl(LifeCycleStatus.INITIALIZED);
        String theInitHandle = (String)this._eventBus.subscribe((EventMatcher)theInitMatcher, (Observer)theInitObserver);
        BusMatcher theStartMatcher = BusMatcherSugar.and((BusMatcher[])new BusMatcher[]{BusMatcherSugar.aliasEqualWith((String)"EventBusTest"), BusMatcherSugar.channelEqualWith((String)"org.refcodes.eventbus"), BusMatcherSugar.actionEqualWith((Object)LifeCycleStatus.STARTED)});
        TestActionObserverImpl theStartObserver = new TestActionObserverImpl(LifeCycleStatus.STARTED);
        String theStartHandle = (String)this._eventBus.subscribe((EventMatcher)theStartMatcher, (Observer)theStartObserver);
        BusMatcher theStopMatcher = BusMatcherSugar.and((BusMatcher[])new BusMatcher[]{BusMatcherSugar.aliasEqualWith((String)"EventBusTest"), BusMatcherSugar.channelEqualWith((String)"org.refcodes.eventbus"), BusMatcherSugar.actionEqualWith((Object)LifeCycleStatus.STOPPED)});
        TestActionObserverImpl theStopObserver = new TestActionObserverImpl(LifeCycleStatus.STOPPED);
        String theStopHandle = (String)this._eventBus.subscribe((EventMatcher)theStopMatcher, (Observer)theStopObserver);
        BusMatcher theDestroyMatcher = BusMatcherSugar.and((BusMatcher[])new BusMatcher[]{BusMatcherSugar.aliasEqualWith((String)"EventBusTest"), BusMatcherSugar.channelEqualWith((String)"org.refcodes.eventbus"), BusMatcherSugar.actionEqualWith((Object)LifeCycleStatus.DESTROYED)});
        TestActionObserverImpl theDestroyObserver = new TestActionObserverImpl(LifeCycleStatus.DESTROYED);
        String theDestroyHandle = (String)this._eventBus.subscribe((EventMatcher)theDestroyMatcher, (Observer)theDestroyObserver);
        BusMatcher theMessageMatcher = BusMatcherSugar.and((BusMatcher[])new BusMatcher[]{BusMatcherSugar.aliasEqualWith((String)"EventBusTest"), BusMatcherSugar.channelEqualWith((String)"org.refcodes.eventbus"), BusMatcherSugar.isAssignableFrom(TestMessageEventImpl.class)});
        TestMessageObserverImpl theMessageObserver = new TestMessageObserverImpl();
        String theMessageHandle = (String)this._eventBus.subscribe((EventMatcher)theMessageMatcher, (Observer)theMessageObserver);
        this._eventBus.publishEvent((GenericEvent)new BusEventImpl((Enum)LifeCycleStatus.INITIALIZED, "EventBusTest", null, "org.refcodes.eventbus", null, null, (EventBus)this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((GenericEvent)new BusEventImpl((Enum)LifeCycleStatus.STARTED, "EventBusTest", null, "org.refcodes.eventbus", null, null, (EventBus)this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((GenericEvent)new BusEventImpl((Enum)LifeCycleStatus.STOPPED, "EventBusTest", null, "org.refcodes.eventbus", null, null, (EventBus)this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((GenericEvent)new BusEventImpl((Enum)LifeCycleStatus.DESTROYED, "EventBusTest", null, "org.refcodes.eventbus", null, null, (EventBus)this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((GenericEvent)new TestMessageEventImpl("EventBusTest", "org.refcodes.eventbus", "1-2-3 Alert!", (EventBus)this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theMessageObserver.getEventCount());
        Observer theInitObserver2 = this._eventBus.removeHandle((Object)theInitHandle);
        Assertions.assertEquals((Object)theInitObserver, (Object)theInitObserver2);
        Observer theStartObserver2 = this._eventBus.removeHandle((Object)theStartHandle);
        Assertions.assertEquals((Object)theStartObserver, (Object)theStartObserver2);
        Observer theStopObserver2 = this._eventBus.removeHandle((Object)theStopHandle);
        Assertions.assertEquals((Object)theStopObserver, (Object)theStopObserver2);
        Observer theDestroyObserver2 = this._eventBus.removeHandle((Object)theDestroyHandle);
        Assertions.assertEquals((Object)theDestroyObserver, (Object)theDestroyObserver2);
        Observer theMessageObserver2 = this._eventBus.removeHandle((Object)theMessageHandle);
        Assertions.assertEquals((Object)theMessageObserver, (Object)theMessageObserver2);
    }

    @Test
    public void testOnType() {
        EventBusImpl theEventBus = new EventBusImpl();
        theEventBus.onType(TypeEvent.class, this::onTypeEvent);
        theEventBus.publishEvent((GenericEvent)new TypeEvent((EventBus)theEventBus));
        Assertions.assertEquals((int)1, (int)this._typeEventCount);
    }

    public void onTypeEvent(TypeEvent aEvent) {
        if (IS_LOG_TESTS) {
            System.out.println("Received an event of type <" + (Object)((Object)aEvent) + "> ...");
        }
        ++this._typeEventCount;
    }

    private class TestMessageEventImpl
    extends BusEventImpl
    implements MessageAccessor {
        String _message;

        public TestMessageEventImpl(String aName, String aChannel, String aMessage, EventBus aSource) {
            super(aName, null, aChannel, null, null, aSource);
            this._message = aMessage;
        }

        public String getMessage() {
            return this._message;
        }
    }

    private class TestMessageObserverImpl
    implements BusObserver {
        private int _eventCount = 0;

        public void onEvent(BusEvent aEvent) {
            Enum theAction = (Enum)aEvent.getAction();
            if (IS_LOG_TESTS) {
                System.out.println("LifeCycleStatus = " + theAction + ", Name = " + ((EventMetaData)aEvent.getMetaData()).getAlias() + ", Group = " + ((EventMetaData)aEvent.getMetaData()).getGroup() + ", UID = " + ((EventMetaData)aEvent.getMetaData()).getUniversalId() + ", publisher type = " + (((EventMetaData)aEvent.getMetaData()).getPublisherType() != null ? ((EventMetaData)aEvent.getMetaData()).getPublisherType().getName() : null));
            }
            if (!(aEvent instanceof TestMessageEventImpl)) {
                throw new IllegalArgumentException("Expected an event of type \"" + TestMessageEventImpl.class.getName() + "\" but received the event \"" + aEvent.getClass().getName() + "\".");
            }
            ++this._eventCount;
        }

        public int getEventCount() {
            return this._eventCount;
        }
    }

    private class TestActionObserverImpl
    implements BusObserver {
        private LifeCycleStatus _action;
        private int _eventCount = 0;

        public TestActionObserverImpl(LifeCycleStatus aAction) {
            this._action = aAction;
        }

        public void onEvent(BusEvent aEvent) {
            if (IS_LOG_TESTS) {
                System.out.println("LifeCycleStatus = " + aEvent.getAction() + ", Alias = " + ((EventMetaData)aEvent.getMetaData()).getAlias() + ", Group = " + ((EventMetaData)aEvent.getMetaData()).getGroup() + ", UID = " + ((EventMetaData)aEvent.getMetaData()).getUniversalId() + ", publisher type = " + (((EventMetaData)aEvent.getMetaData()).getPublisherType() != null ? ((EventMetaData)aEvent.getMetaData()).getPublisherType().getName() : null));
            }
            if (!this._action.equals(aEvent.getAction())) {
                throw new IllegalArgumentException("Expected an action <" + this._action + "> but received the action <" + aEvent.getAction() + ">.");
            }
            ++this._eventCount;
        }

        public int getEventCount() {
            return this._eventCount;
        }
    }

    private class TypeEvent
    extends BusEventImpl {
        public TypeEvent(EventBus aSource) {
            super(aSource);
        }
    }
}

