/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.eventbus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.eventbus.DispatchStrategy;
import org.refcodes.eventbus.EventBus;
import org.refcodes.eventbus.EventBusEvent;
import org.refcodes.observer.Event;
import org.refcodes.runtime.SystemProperty;

public class DisptachStrategyTest {
    @Test
    public void testDispatchStrategies() {
        for (DispatchStrategy eStrategy : DispatchStrategy.values()) {
            this.testDispatchStrategy(eStrategy, 25);
        }
    }

    @Disabled
    @Test
    public void testDispatchCascade() {
        this.testDispatchStrategy(DispatchStrategy.CASCADE, 1000);
    }

    @Disabled
    @Test
    public void testDispatchSequential() {
        this.testDispatchStrategy(DispatchStrategy.SEQUENTIAL, 1000);
    }

    @Disabled
    @Test
    public void testDispatchParallel() {
        this.testDispatchStrategy(DispatchStrategy.PARALLEL, 1000);
    }

    @Disabled
    @Test
    public void testDispatchAsync() {
        this.testDispatchStrategy(DispatchStrategy.ASYNC, 1000);
    }

    private void testDispatchStrategy(DispatchStrategy aDispatchStrategy, int aLoops) {
        EventBus theEventBusImpl = new EventBus(aDispatchStrategy);
        List<EventBusEvent> theEvents = Collections.synchronizedList(new ArrayList());
        theEventBusImpl.onAction((Enum)LEVEL._1, aEvent -> {
            EventBusEvent theEvent = new EventBusEvent((Enum)LEVEL._2, theEventBusImpl);
            List list = theEvents;
            synchronized (list) {
                theEvents.add((EventBusEvent)aEvent);
            }
            for (int i = 0; i < 10; ++i) {
                theEventBusImpl.publishEvent((Event)theEvent);
            }
        });
        theEventBusImpl.onAction((Enum)LEVEL._2, aEvent -> {
            EventBusEvent theEvent = new EventBusEvent((Enum)LEVEL._3, theEventBusImpl);
            List list = theEvents;
            synchronized (list) {
                theEvents.add((EventBusEvent)aEvent);
            }
            for (int i = 0; i < 10; ++i) {
                theEventBusImpl.publishEvent((Event)theEvent);
            }
        });
        theEventBusImpl.onAction((Enum)LEVEL._3, aEvent -> {
            EventBusEvent theEvent = new EventBusEvent((Enum)LEVEL._4, theEventBusImpl);
            List list = theEvents;
            synchronized (list) {
                theEvents.add((EventBusEvent)aEvent);
            }
            for (int i = 0; i < 10; ++i) {
                theEventBusImpl.publishEvent((Event)theEvent);
            }
        });
        theEventBusImpl.onAction((Enum)LEVEL._4, aEvent -> {
            List list = theEvents;
            synchronized (list) {
                theEvents.add((EventBusEvent)aEvent);
            }
        });
        for (int n = 0; n < aLoops; ++n) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("--------------------------------------------------------------------------------");
            }
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("Iteration <" + n + "> with strategy <" + aDispatchStrategy + "> ...");
            }
            theEventBusImpl.publishEvent((Event)new EventBusEvent((Enum)LEVEL._1, theEventBusImpl));
            this.waitFor(1111, theEvents);
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("Events received := " + theEvents.size());
            }
            theEvents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(int aSize, List<EventBusEvent> theEvents) {
        int theCount = 0;
        do {
            if (theCount == 10) {
                Assertions.fail((String)("Did not get expected number of <" + aSize + "> events!"));
            }
            Predicate<EventBusEvent> predicate1 = e -> e.getAction() == LEVEL._1;
            Predicate<EventBusEvent> predicate2 = e -> e.getAction() == LEVEL._2;
            Predicate<EventBusEvent> predicate3 = e -> e.getAction() == LEVEL._3;
            Predicate<EventBusEvent> predicate4 = e -> e.getAction() == LEVEL._4;
            List<EventBusEvent> list = theEvents;
            synchronized (list) {
                long ones = theEvents.stream().filter(predicate1).count();
                long twos = theEvents.stream().filter(predicate2).count();
                long threes = theEvents.stream().filter(predicate3).count();
                long fours = theEvents.stream().filter(predicate4).count();
                if (SystemProperty.LOG_TESTS.isEnabled()) {
                    System.out.println("Events received := " + theEvents.size() + ", _1 := " + ones + ", _2 := " + twos + ", _3 := " + threes + ", _4 := " + fours);
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++theCount;
        } while (theEvents.size() < aSize);
    }

    static enum LEVEL {
        _1,
        _2,
        _3,
        _4,
        _5;

    }
}

