/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.eventbus;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.component.LifecycleStatus;
import org.refcodes.eventbus.EventBrokerEvent;
import org.refcodes.eventbus.EventBrokerEventMatcher;
import org.refcodes.eventbus.EventBus;
import org.refcodes.eventbus.EventBusEvent;
import org.refcodes.eventbus.EventBusEventMatcher;
import org.refcodes.eventbus.EventBusObserver;
import org.refcodes.eventbus.EventBusSugar;
import org.refcodes.mixin.MessageAccessor;
import org.refcodes.observer.Event;
import org.refcodes.observer.Observer;
import org.refcodes.runtime.SystemProperty;

public class EventBusTest {
    private final EventBus _eventBus = new EventBus();
    private int _typeEventCount = 0;

    @Test
    public void testEventMatcherSchema() {
        EventBusEventMatcher theSportsMatcher = EventBusSugar.or((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.channelEqualWith((String)"Soccer"), EventBusSugar.channelEqualWith((String)"Football")});
        EventBusEventMatcher thePoliticsMatcher = EventBusSugar.or((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.channelEqualWith((String)"War"), EventBusSugar.channelEqualWith((String)"Education")});
        EventBusEventMatcher theMediaMatcher = EventBusSugar.or((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.channelEqualWith((String)"TV"), EventBusSugar.channelEqualWith((String)"Streaming")});
        EventBusEventMatcher theEntertainmentMatcher = EventBusSugar.or((EventBusEventMatcher[])new EventBusEventMatcher[]{theSportsMatcher, theMediaMatcher});
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println(theSportsMatcher.toSchema());
            System.out.println();
            System.out.println(thePoliticsMatcher.toSchema());
            System.out.println();
            System.out.println(theMediaMatcher.toSchema());
            System.out.println();
            System.out.println(theEntertainmentMatcher.toSchema());
            System.out.println();
        }
    }

    @Test
    public void testChannel() {
        EventBusEventMatcher theSportsMatcher = EventBusSugar.or((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.channelEqualWith((String)"Soccer"), EventBusSugar.channelEqualWith((String)"Football")});
        EventBusEventMatcher thePoliticsMatcher = EventBusSugar.or((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.channelEqualWith((String)"War"), EventBusSugar.channelEqualWith((String)"Education")});
        EventBusObserver theSportsObserver = aEvent -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("Got a sports event on channel <" + aEvent.getMetaData().getChannel() + ">");
            }
        };
        EventBusObserver thePoliticsObserver = aEvent -> {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("Got a politics event on channel <" + aEvent.getMetaData().getChannel() + ">");
            }
        };
        EventBus theEventBus = new EventBus();
        theEventBus.subscribe((EventBrokerEventMatcher)theSportsMatcher, (Observer)theSportsObserver);
        theEventBus.subscribe((EventBrokerEventMatcher)thePoliticsMatcher, (Observer)thePoliticsObserver);
        theEventBus.publishEvent((Event)new EventBusEvent("Soccer", theEventBus));
        theEventBus.publishEvent((Event)new EventBusEvent("Education", theEventBus));
        theEventBus.publishEvent((Event)new EventBusEvent("Football", theEventBus));
        theEventBus.publishEvent((Event)new EventBusEvent("War", theEventBus));
        theEventBus.publishEvent((Event)new EventBusEvent("Formular 1", theEventBus));
        theEventBus.publishEvent((Event)new EventBusEvent("Top Secret", theEventBus));
        Assertions.assertFalse((boolean)theEventBus.isMatching((EventBrokerEvent)new EventBusEvent("Top Secret", theEventBus)));
        Assertions.assertTrue((boolean)theEventBus.isMatching((EventBrokerEvent)new EventBusEvent("Soccer", theEventBus)));
        Assertions.assertTrue((boolean)theEventBus.isMatching((EventBrokerEvent)new EventBusEvent("Education", theEventBus)));
    }

    @Test
    public void testEventBus() {
        EventBusEventMatcher theInitMatcher = EventBusSugar.and((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.aliasEqualWith((String)"EventBusTest"), EventBusSugar.channelEqualWith((String)"org.refcodes.eventbus"), EventBusSugar.actionEqualWith((Object)LifecycleStatus.INITIALIZED)});
        TestActionObserverImpl theInitObserver = new TestActionObserverImpl(LifecycleStatus.INITIALIZED);
        String theInitHandle = (String)this._eventBus.subscribe((EventBrokerEventMatcher)theInitMatcher, (Observer)theInitObserver);
        EventBusEventMatcher theStartMatcher = EventBusSugar.and((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.aliasEqualWith((String)"EventBusTest"), EventBusSugar.channelEqualWith((String)"org.refcodes.eventbus"), EventBusSugar.actionEqualWith((Object)LifecycleStatus.STARTED)});
        TestActionObserverImpl theStartObserver = new TestActionObserverImpl(LifecycleStatus.STARTED);
        String theStartHandle = (String)this._eventBus.subscribe((EventBrokerEventMatcher)theStartMatcher, (Observer)theStartObserver);
        EventBusEventMatcher theStopMatcher = EventBusSugar.and((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.aliasEqualWith((String)"EventBusTest"), EventBusSugar.channelEqualWith((String)"org.refcodes.eventbus"), EventBusSugar.actionEqualWith((Object)LifecycleStatus.STOPPED)});
        TestActionObserverImpl theStopObserver = new TestActionObserverImpl(LifecycleStatus.STOPPED);
        String theStopHandle = (String)this._eventBus.subscribe((EventBrokerEventMatcher)theStopMatcher, (Observer)theStopObserver);
        EventBusEventMatcher theDestroyMatcher = EventBusSugar.and((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.aliasEqualWith((String)"EventBusTest"), EventBusSugar.channelEqualWith((String)"org.refcodes.eventbus"), EventBusSugar.actionEqualWith((Object)LifecycleStatus.DESTROYED)});
        TestActionObserverImpl theDestroyObserver = new TestActionObserverImpl(LifecycleStatus.DESTROYED);
        String theDestroyHandle = (String)this._eventBus.subscribe((EventBrokerEventMatcher)theDestroyMatcher, (Observer)theDestroyObserver);
        EventBusEventMatcher theMessageMatcher = EventBusSugar.and((EventBusEventMatcher[])new EventBusEventMatcher[]{EventBusSugar.aliasEqualWith((String)"EventBusTest"), EventBusSugar.channelEqualWith((String)"org.refcodes.eventbus"), EventBusSugar.isAssignableFrom(TestMessageEventImpl.class)});
        TestMessageObserver theMessageObserver = new TestMessageObserver();
        String theMessageHandle = (String)this._eventBus.subscribe((EventBrokerEventMatcher)theMessageMatcher, (Observer)theMessageObserver);
        this._eventBus.publishEvent((Event)new EventBusEvent((Enum)LifecycleStatus.INITIALIZED, "EventBusTest", null, "org.refcodes.eventbus", null, null, this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((Event)new EventBusEvent((Enum)LifecycleStatus.STARTED, "EventBusTest", null, "org.refcodes.eventbus", null, null, this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((Event)new EventBusEvent((Enum)LifecycleStatus.STOPPED, "EventBusTest", null, "org.refcodes.eventbus", null, null, this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((Event)new EventBusEvent((Enum)LifecycleStatus.DESTROYED, "EventBusTest", null, "org.refcodes.eventbus", null, null, this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)0, (int)theMessageObserver.getEventCount());
        this._eventBus.publishEvent((Event)new TestMessageEventImpl("EventBusTest", "org.refcodes.eventbus", "1-2-3 Alert!", this._eventBus));
        Assertions.assertEquals((int)1, (int)theInitObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStartObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theStopObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theDestroyObserver.getEventCount());
        Assertions.assertEquals((int)1, (int)theMessageObserver.getEventCount());
        Observer theInitObserver2 = this._eventBus.removeHandle((Object)theInitHandle);
        Assertions.assertEquals((Object)theInitObserver, (Object)theInitObserver2);
        Observer theStartObserver2 = this._eventBus.removeHandle((Object)theStartHandle);
        Assertions.assertEquals((Object)theStartObserver, (Object)theStartObserver2);
        Observer theStopObserver2 = this._eventBus.removeHandle((Object)theStopHandle);
        Assertions.assertEquals((Object)theStopObserver, (Object)theStopObserver2);
        Observer theDestroyObserver2 = this._eventBus.removeHandle((Object)theDestroyHandle);
        Assertions.assertEquals((Object)theDestroyObserver, (Object)theDestroyObserver2);
        Observer theMessageObserver2 = this._eventBus.removeHandle((Object)theMessageHandle);
        Assertions.assertEquals((Object)theMessageObserver, (Object)theMessageObserver2);
    }

    @Test
    public void testOnType() {
        EventBus theEventBus = new EventBus();
        theEventBus.onType(TypeEvent.class, this::onTypeEvent);
        theEventBus.publishEvent((Event)new TypeEvent(theEventBus));
        Assertions.assertEquals((int)1, (int)this._typeEventCount);
    }

    public void onTypeEvent(TypeEvent aEvent) {
        if (SystemProperty.LOG_TESTS.isEnabled()) {
            System.out.println("Received an event of type <" + aEvent + "> ...");
        }
        ++this._typeEventCount;
    }

    private class TestActionObserverImpl
    implements EventBusObserver {
        private final LifecycleStatus _action;
        private int _eventCount = 0;

        public TestActionObserverImpl(LifecycleStatus aAction) {
            this._action = aAction;
        }

        public void onEvent(EventBusEvent aEvent) {
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("LifeCycleStatus = " + aEvent.getAction() + ", Alias = " + aEvent.getMetaData().getAlias() + ", Group = " + aEvent.getMetaData().getGroup() + ", UID = " + aEvent.getMetaData().getUniversalId() + ", publisher type = " + (aEvent.getMetaData().getPublisherType() != null ? aEvent.getMetaData().getPublisherType().getName() : null));
            }
            if (!this._action.equals(aEvent.getAction())) {
                throw new IllegalArgumentException("Expected an action <" + this._action + "> but received the action <" + aEvent.getAction() + ">.");
            }
            ++this._eventCount;
        }

        public int getEventCount() {
            return this._eventCount;
        }
    }

    private class TestMessageEventImpl
    extends EventBusEvent
    implements MessageAccessor {
        String _message;

        public TestMessageEventImpl(String aName, String aChannel, String aMessage, EventBus aSource) {
            super(aName, null, aChannel, null, null, aSource);
            this._message = aMessage;
        }

        public String getMessage() {
            return this._message;
        }
    }

    private class TestMessageObserver
    implements EventBusObserver {
        private int _eventCount = 0;

        public void onEvent(EventBusEvent aEvent) {
            Enum theAction = (Enum)aEvent.getAction();
            if (SystemProperty.LOG_TESTS.isEnabled()) {
                System.out.println("LifeCycleStatus = " + theAction + ", Name = " + aEvent.getMetaData().getAlias() + ", Group = " + aEvent.getMetaData().getGroup() + ", UID = " + aEvent.getMetaData().getUniversalId() + ", publisher type = " + (aEvent.getMetaData().getPublisherType() != null ? aEvent.getMetaData().getPublisherType().getName() : null));
            }
            if (!(aEvent instanceof TestMessageEventImpl)) {
                throw new IllegalArgumentException("Expected an event of type \"" + TestMessageEventImpl.class.getName() + "\" but received the event \"" + aEvent.getClass().getName() + "\".");
            }
            ++this._eventCount;
        }

        public int getEventCount() {
            return this._eventCount;
        }
    }

    public class TypeEvent
    extends EventBusEvent {
        public TypeEvent(EventBus aSource) {
            super(aSource);
        }
    }
}

