/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.factory.alt.spring;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.refcodes.data.Encoding;
import org.refcodes.factory.BeanFactory;
import org.refcodes.factory.InstantiationRuntimeException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringBeanFactory
implements BeanFactory<String> {
    private URI[] _confFileURIs = null;
    private URI[] _propertyFileURIs = null;
    private Map<String, String> _properties = null;
    private FileSystemXmlApplicationContext _applicationContext;

    public SpringBeanFactory(URI[] aConfigurationFiles) throws MalformedURLException {
        this.doInitialize(aConfigurationFiles, null, null);
    }

    public SpringBeanFactory(URI[] aConfigurationFiles, URI[] aPropertyFiles) throws MalformedURLException {
        this.doInitialize(aConfigurationFiles, aPropertyFiles, null);
    }

    public SpringBeanFactory(URI[] aConfigurationFiles, Map<String, String> aProperties) throws MalformedURLException {
        this.doInitialize(aConfigurationFiles, null, aProperties);
    }

    public SpringBeanFactory(URI[] aConfigurationFiles, URI[] aPropertyFiles, Map<String, String> aProperties) throws MalformedURLException {
        this.doInitialize(aConfigurationFiles, aPropertyFiles, aProperties);
        this._confFileURIs = aConfigurationFiles;
        this._propertyFileURIs = aPropertyFiles;
        this._properties = aProperties;
    }

    private void doInitialize(URI[] aConfigurationFiles, URI[] aPropertyFiles, Map<String, String> aProperties) throws MalformedURLException {
        this._confFileURIs = aConfigurationFiles;
        this._propertyFileURIs = aPropertyFiles;
        this._properties = aProperties;
        String[] configLocations = new String[aConfigurationFiles.length];
        int i = 0;
        while (i < aConfigurationFiles.length) {
            try {
                configLocations[i] = URLDecoder.decode(aConfigurationFiles[i].toString(), Encoding.UTF_8.getCode());
            }
            catch (UnsupportedEncodingException e) {
                throw new MalformedURLException("Unsupported encoding in URI \"" + aConfigurationFiles[i].toString() + "\": " + e.getMessage());
            }
            ++i;
        }
        this._applicationContext = new FileSystemXmlApplicationContext();
        this._applicationContext.setValidating(false);
        PropertySourcesPlaceholderConfigurer placeholderConfigurer = null;
        if (aProperties != null) {
            if (placeholderConfigurer == null) {
                placeholderConfigurer = new PropertySourcesPlaceholderConfigurer();
            }
            placeholderConfigurer.setProperties(this.toProperties(aProperties));
        }
        if (aPropertyFiles != null) {
            Resource[] propertyLocations = new Resource[aPropertyFiles.length];
            int i2 = 0;
            while (i2 < aPropertyFiles.length) {
                try {
                    propertyLocations[i2] = new UrlResource(URLDecoder.decode(aPropertyFiles[i2].toString(), Encoding.UTF_8.getCode()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new MalformedURLException("Unsupported encoding in URI \"" + aPropertyFiles[i2].toString() + "\": " + e.getMessage());
                }
                ++i2;
            }
            if (placeholderConfigurer == null) {
                placeholderConfigurer = new PropertySourcesPlaceholderConfigurer();
            }
            placeholderConfigurer.setLocations(propertyLocations);
        }
        if (placeholderConfigurer != null) {
            this._applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)placeholderConfigurer);
        }
        this._applicationContext.setConfigLocations(configLocations);
        this._applicationContext.refresh();
    }

    public <T> T create(String aIdentifier) {
        return (T)this._applicationContext.getBean(aIdentifier);
    }

    public <T> T create(String aIdentifier, Map<String, String> aProperties) {
        try {
            HashMap<String, String> theProperties = new HashMap<String, String>();
            if (this._properties != null) {
                theProperties.putAll(this._properties);
            }
            theProperties.putAll(aProperties);
            SpringBeanFactory theSpringFactory = new SpringBeanFactory(this._confFileURIs, this._propertyFileURIs, theProperties);
            T instance = theSpringFactory.create(aIdentifier);
            return instance;
        }
        catch (MalformedURLException e) {
            throw new InstantiationRuntimeException((Throwable)e);
        }
    }

    public <T> Set<T> create(Class<?> aType) {
        Map theBeansOfType = this._applicationContext.getBeansOfType(aType, true, true);
        return new HashSet(theBeansOfType.values());
    }

    public <T> Set<T> toInstances(Class<?> aType, Map<String, String> aProperties) {
        try {
            HashMap<String, String> theProperties = new HashMap<String, String>();
            if (this._properties != null) {
                theProperties.putAll(this._properties);
            }
            theProperties.putAll(aProperties);
            SpringBeanFactory theSpringFactory = new SpringBeanFactory(this._confFileURIs, this._propertyFileURIs, theProperties);
            Map theBeansOfType = theSpringFactory._applicationContext.getBeansOfType(aType, true, true);
            return new HashSet(theBeansOfType.values());
        }
        catch (MalformedURLException e) {
            throw new InstantiationRuntimeException((Throwable)e);
        }
    }

    private Properties toProperties(Map<String, String> aProperties) {
        Properties theProperties = new Properties();
        theProperties.putAll(aProperties);
        return theProperties;
    }
}

