/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem.alt.s3.tests;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileSystem;
import org.refcodes.filesystem.alt.s3.impls.AbstractS3Client;
import org.refcodes.filesystem.alt.s3.impls.S3FileSystemImpl;
import org.refcodes.filesystem.traps.ConcurrentAccessException;
import org.refcodes.filesystem.traps.FileAlreadyExistsException;
import org.refcodes.filesystem.traps.IllegalFileHandleException;
import org.refcodes.filesystem.traps.IllegalKeyException;
import org.refcodes.filesystem.traps.IllegalNameException;
import org.refcodes.filesystem.traps.IllegalPathException;
import org.refcodes.filesystem.traps.NoCreateAccessException;
import org.refcodes.filesystem.traps.NoDeleteAccessException;
import org.refcodes.filesystem.traps.NoListAccessException;
import org.refcodes.filesystem.traps.NoReadAccessException;
import org.refcodes.filesystem.traps.NoWriteAccessException;
import org.refcodes.filesystem.traps.UnknownFileException;
import org.refcodes.filesystem.traps.UnknownFileSystemException;
import org.refcodes.filesystem.traps.UnknownKeyException;
import org.refcodes.filesystem.traps.UnknownPathException;
import org.refcodes.filesystem.utils.FileSystemUtility;

public class S3FileSystemTest {
    private static final String S3_BUCKET_NAME = S3FileSystemTest.class.getPackage().getName();
    private static final String S3_ACCESS_KEY = "ACCESSKEY";
    private static final String S3_SECRET_KEY = "SECRETKEY";
    private FileSystem _fileSystem;
    private AmazonS3 _amazonS3;

    @Before
    public void setUp() throws IOException {
        if (this._amazonS3 == null) {
            this._amazonS3 = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(S3_ACCESS_KEY, S3_SECRET_KEY));
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AbstractS3Client.createBucket((AmazonS3)this._amazonS3, (String)S3_BUCKET_NAME);
        if (this._fileSystem == null) {
            this._fileSystem = new S3FileSystemImpl(S3_BUCKET_NAME, S3_ACCESS_KEY, S3_SECRET_KEY);
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @After
    public void tearDown() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AbstractS3Client.deleteBucket((AmazonS3)this._amazonS3, (String)S3_BUCKET_NAME);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testHasFileString() throws IOException, FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IllegalKeyException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        boolean exists = this._fileSystem.hasFile(theFileHandle.toKey());
        Assert.assertTrue((boolean)exists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testHasFileStringString() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        this.createRecord(path, name, content);
        boolean exists = this._fileSystem.hasFile(path, name);
        Assert.assertTrue((boolean)exists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testHasFile() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        boolean exists = this._fileSystem.hasFile(theFileHandle);
        Assert.assertTrue((boolean)exists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testCreateFileString() throws FileAlreadyExistsException, NoCreateAccessException, IllegalKeyException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this._fileSystem.createFile(FileSystemUtility.toKey((String)path, (String)name));
        Assert.assertNotNull((Object)theFileHandle);
        OutputStream out = this._fileSystem.toFile(theFileHandle);
        out.write(content.getBytes());
        out.flush();
        out.close();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean exists = this._fileSystem.hasFile(theFileHandle);
        Assert.assertTrue((boolean)exists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testCreateFileStringString() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        boolean exists = this._fileSystem.hasFile(theFileHandle);
        Assert.assertTrue((boolean)exists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testGetFileString() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, IllegalKeyException, IllegalFileHandleException, UnknownKeyException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        FileHandle getFile = this._fileSystem.getFileHandle(theFileHandle.toKey());
        Assert.assertEquals((Object)theFileHandle.getName(), (Object)getFile.getName());
        Assert.assertEquals((Object)theFileHandle.getPath(), (Object)getFile.getPath());
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testGetFileStringString() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, IllegalFileHandleException, UnknownKeyException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        FileHandle getFile = this._fileSystem.getFileHandle(path, name);
        Assert.assertEquals((Object)theFileHandle.getName(), (Object)getFile.getName());
        Assert.assertEquals((Object)theFileHandle.getPath(), (Object)getFile.getPath());
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testFromFileOutputStream() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoReadAccessException, ConcurrentAccessException, UnknownFileException, NoWriteAccessException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this._fileSystem.fromFile(theFileHandle, (OutputStream)outputStream);
        Assert.assertEquals((Object)content, (Object)outputStream.toString());
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testFromFile() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoReadAccessException, ConcurrentAccessException, UnknownFileException, NoWriteAccessException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        InputStream inputStream = this._fileSystem.fromFile(theFileHandle);
        String readContent = IOUtils.toString((InputStream)inputStream);
        Assert.assertEquals((Object)content, (Object)readContent.toString());
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testToFileInputStream() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, NoReadAccessException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        String newContent = "Changed test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        Assert.assertNotNull((Object)theFileHandle);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(newContent.getBytes());
        this._fileSystem.toFile(theFileHandle, (InputStream)inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this._fileSystem.fromFile(theFileHandle, (OutputStream)outputStream);
        Assert.assertEquals((Object)newContent, (Object)outputStream.toString());
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testToFile() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, NoReadAccessException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        InputStream inputStream = this._fileSystem.fromFile(theFileHandle);
        String readContent = IOUtils.toString((InputStream)inputStream);
        Assert.assertEquals((Object)content, (Object)readContent);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testRenameFileString() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoDeleteAccessException, UnknownFileException, ConcurrentAccessException, NoWriteAccessException, NoReadAccessException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        String newName = "newfile.txt";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        theFileHandle = this._fileSystem.renameFile(theFileHandle, newName);
        Assert.assertEquals((Object)newName, (Object)theFileHandle.getName());
        Assert.assertEquals((Object)path, (Object)theFileHandle.getPath());
        InputStream inputStream = this._fileSystem.fromFile(theFileHandle);
        String readContent = IOUtils.toString((InputStream)inputStream);
        Assert.assertEquals((Object)content, (Object)readContent.toString());
        boolean oldRecordExists = this._fileSystem.hasFile(path, name);
        Assert.assertFalse((boolean)oldRecordExists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testMoveFileString() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, NoDeleteAccessException, IllegalKeyException, NoReadAccessException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        String newName = "newfile.txt";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        theFileHandle = this._fileSystem.moveFile(theFileHandle, FileSystemUtility.toKey((String)path, (String)newName));
        Assert.assertEquals((Object)newName, (Object)theFileHandle.getName());
        Assert.assertEquals((Object)path, (Object)theFileHandle.getPath());
        InputStream inputStream = this._fileSystem.fromFile(theFileHandle);
        String readContent = IOUtils.toString((InputStream)inputStream);
        Assert.assertEquals((Object)content, (Object)readContent.toString());
        boolean oldRecordExists = this._fileSystem.hasFile(path, name);
        Assert.assertFalse((boolean)oldRecordExists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testDeleteFile() throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, NoDeleteAccessException, IllegalFileHandleException {
        String path = "/unit/test";
        String name = "testfile.txt";
        String content = "Test file";
        FileHandle theFileHandle = this.createRecord(path, name, content);
        this._fileSystem.deleteFile(theFileHandle);
        boolean oldRecordExists = this._fileSystem.hasFile(path, name);
        Assert.assertFalse((boolean)oldRecordExists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testHasFilesStringBoolean() throws NoWriteAccessException, FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, ConcurrentAccessException, UnknownFileException, IOException, IllegalFileHandleException {
        String path1 = "/unit/test";
        String name1 = "testfile1.txt";
        String content1 = "Test file 1";
        this.createRecord(path1, name1, content1);
        String path2 = "/unit/test";
        String name2 = "testfile2.txt";
        String content2 = "Test file 2";
        this.createRecord(path2, name2, content2);
        String path3 = "/unit/test";
        String name3 = "testfile3.txt";
        String content3 = "Test file 3";
        this.createRecord(path3, name3, content3);
        String path4 = "/unit/test/sub";
        String name4 = "testfile4.txt";
        String content4 = "Test file 4";
        this.createRecord(path4, name4, content4);
        boolean exists = this._fileSystem.hasFiles(path1, true);
        Assert.assertTrue((boolean)exists);
        exists = this._fileSystem.hasFiles(path1, false);
        Assert.assertTrue((boolean)exists);
        exists = this._fileSystem.hasFiles(path4, true);
        Assert.assertTrue((boolean)exists);
        exists = this._fileSystem.hasFiles(path4, false);
        Assert.assertTrue((boolean)exists);
        exists = this._fileSystem.hasFiles(path4 + "filler", true);
        Assert.assertFalse((boolean)exists);
        exists = this._fileSystem.hasFiles(path4 + "filler", false);
        Assert.assertFalse((boolean)exists);
    }

    @Test
    @Ignore(value="Deactivate beacause of the slowness of Amazon S3!")
    public void testGetFilesStringBoolean() throws NoWriteAccessException, FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, ConcurrentAccessException, UnknownFileException, IOException, UnknownPathException, IllegalFileHandleException {
        String path1 = "/unit/test";
        String name1 = "testfile1.txt";
        String content1 = "Test file 1";
        FileHandle theFileHandle1 = this.createRecord(path1, name1, content1);
        String path2 = "/unit/test";
        String name2 = "testfile2.txt";
        String content2 = "Test file 2";
        FileHandle theFileHandle2 = this.createRecord(path2, name2, content2);
        String path3 = "/unit/test";
        String name3 = "testfile3.txt";
        String content3 = "Test file 3";
        FileHandle theFileHandle3 = this.createRecord(path3, name3, content3);
        String path4 = "/unit/test/sub";
        String name4 = "testfile4.txt";
        String content4 = "Test file 4";
        FileHandle theFileHandle4 = this.createRecord(path4, name4, content4);
        List theFileHandles = this._fileSystem.getFileHandles(path1, false);
        Assert.assertEquals((long)3L, (long)theFileHandles.size());
        theFileHandles = this._fileSystem.getFileHandles(path4, false);
        Assert.assertEquals((long)1L, (long)theFileHandles.size());
        theFileHandles = this._fileSystem.getFileHandles(path1, true);
        Assert.assertEquals((long)4L, (long)theFileHandles.size());
        for (FileHandle theFileHandle : theFileHandles) {
            if ((theFileHandle.getName().equals(theFileHandle1.getName()) || theFileHandle.getName().equals(theFileHandle2.getName()) || theFileHandle.getName().equals(theFileHandle3.getName()) || theFileHandle.getName().equals(theFileHandle4.getName())) && (theFileHandle.getPath().equals(theFileHandle1.getPath()) || theFileHandle.getPath().equals(theFileHandle2.getPath()) || theFileHandle.getPath().equals(theFileHandle3.getPath()) || theFileHandle.getPath().equals(theFileHandle4.getPath()))) continue;
            Assert.fail();
        }
    }

    private FileHandle createRecord(String aPath, String aName, String aContent) throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, NoListAccessException, IOException, NoWriteAccessException, ConcurrentAccessException, UnknownFileException, IllegalFileHandleException {
        FileHandle theFileHandle = this._fileSystem.createFile(aPath, aName);
        Assert.assertNotNull((Object)theFileHandle);
        OutputStream outputStream = this._fileSystem.toFile(theFileHandle);
        outputStream.write(aContent.getBytes());
        outputStream.flush();
        outputStream.close();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return theFileHandle;
    }
}

