/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem.alt.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.Region;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

abstract class AbstractS3Client {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final int THREAD_POOL_SIZE = 20;
    private static final String DEFAULT_REGION = "s3-eu-west-1.amazonaws.com";
    private AmazonS3Client _amazonS3Client = null;
    private String _amazonS3BucketName = null;

    public AbstractS3Client(String aBucketName, String aAccessKey, String aSecretKey) {
        this(aBucketName, aAccessKey, aSecretKey, DEFAULT_REGION);
    }

    public AbstractS3Client(String aBucketName, String aAccessKey, String aSecretKey, String aEndPoint) {
        if (aEndPoint == null) {
            aEndPoint = DEFAULT_REGION;
        }
        this._amazonS3Client = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(aAccessKey, aSecretKey));
        this._amazonS3Client.setEndpoint(aEndPoint);
        this._amazonS3BucketName = aBucketName;
    }

    protected String getAmazonS3BucketName() {
        return this._amazonS3BucketName;
    }

    protected void setAmazonS3BucketName(String aAmazonS3BucketName) {
        this._amazonS3BucketName = aAmazonS3BucketName;
    }

    protected AmazonS3Client getAmazonS3Client() {
        return this._amazonS3Client;
    }

    public static void createBucket(AmazonS3 aAmazonS3, String aBucketId) {
        aAmazonS3.createBucket(aBucketId, Region.EU_Ireland);
    }

    protected static void createBucket(AmazonS3 aAmazonS3, String aBucketId, String aRegion) {
        aAmazonS3.createBucket(aBucketId, aRegion);
    }

    protected static void clearBucket(AmazonS3 aAmazonS3, String aBucketId) {
        ObjectListing theObjectListing = aAmazonS3.listObjects(aBucketId);
        while (theObjectListing.getObjectSummaries() != null && !theObjectListing.getObjectSummaries().isEmpty()) {
            List theObjectSummaries = theObjectListing.getObjectSummaries();
            AbstractS3Client.deleteS3Objects(aAmazonS3, aBucketId, theObjectSummaries);
            theObjectListing = aAmazonS3.listNextBatchOfObjects(theObjectListing);
        }
    }

    public static void deleteBucket(AmazonS3 aAmazonS3, String aBucketId) {
        AbstractS3Client.clearBucket(aAmazonS3, aBucketId);
        aAmazonS3.deleteBucket(aBucketId);
    }

    protected static AmazonS3 createAmazonS3(String aAccessKey, String aSecretKey) {
        return new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(aAccessKey, aSecretKey));
    }

    protected static void deleteS3Objects(final AmazonS3 aAmazonS3, final String aBucketId, List<S3ObjectSummary> aS3SummaryObjects) {
        ExecutorService theExecutorService = Executors.newFixedThreadPool(20);
        final CountDownLatch theCountDownLatch = new CountDownLatch(aS3SummaryObjects.size());
        for (final S3ObjectSummary eSummary : aS3SummaryObjects) {
            theExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        aAmazonS3.deleteObject(aBucketId, eSummary.getKey());
                    }
                    catch (Exception e) {
                        LOGGER.warn(ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                    }
                    finally {
                        theCountDownLatch.countDown();
                    }
                }
            });
        }
        try {
            theCountDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        theExecutorService.shutdown();
    }

    protected static AmazonS3Client getAmazonS3Client(File aConfigFile) throws IOException {
        Properties theProperties = new Properties();
        theProperties.load(new FileInputStream(aConfigFile));
        AmazonS3Client theAmazonS3Client = new AmazonS3Client((AWSCredentials)new PropertiesCredentials(aConfigFile));
        return theAmazonS3Client;
    }
}

