/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem.alt.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.filesystem.ConcurrentAccessException;
import org.refcodes.filesystem.FileAlreadyExistsException;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileHandleImpl;
import org.refcodes.filesystem.FileSystem;
import org.refcodes.filesystem.FileSystemUtility;
import org.refcodes.filesystem.IllegalFileHandleException;
import org.refcodes.filesystem.IllegalKeyException;
import org.refcodes.filesystem.IllegalNameException;
import org.refcodes.filesystem.IllegalPathException;
import org.refcodes.filesystem.NoCreateAccessException;
import org.refcodes.filesystem.NoDeleteAccessException;
import org.refcodes.filesystem.NoListAccessException;
import org.refcodes.filesystem.NoReadAccessException;
import org.refcodes.filesystem.NoWriteAccessException;
import org.refcodes.filesystem.UnknownFileException;
import org.refcodes.filesystem.UnknownFileSystemException;
import org.refcodes.filesystem.UnknownKeyException;
import org.refcodes.filesystem.UnknownPathException;
import org.refcodes.filesystem.alt.s3.AbstractS3Client;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.time.DateFormat;

public class S3FileSystemImpl
extends AbstractS3Client
implements FileSystem {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static String METADATA_CREATED_DATE = "CreatedDate";
    private HashSet<Thread> _threadCache = new HashSet();

    public S3FileSystemImpl(String aBucketName, String aAccessKey, String aSecretKey) {
        super(aBucketName, aAccessKey, aSecretKey);
    }

    public S3FileSystemImpl(String aBucketName, String aAccessKey, String aSecretKey, String aEndPoint) {
        super(aBucketName, aAccessKey, aSecretKey, aEndPoint);
    }

    public boolean hasFile(String aKey) throws IllegalKeyException, NoListAccessException, UnknownFileSystemException, IOException {
        if (StringUtils.isEmpty((String)aKey)) {
            throw new IllegalKeyException(aKey, "The provided key is invalid.");
        }
        try {
            this.getAmazonS3Client().getObjectMetadata(this.getAmazonS3BucketName(), aKey);
        }
        catch (AmazonClientException e) {
            return false;
        }
        return true;
    }

    public boolean hasFile(String aPath, String aName) throws IllegalPathException, IllegalNameException, NoListAccessException, UnknownFileSystemException, IOException {
        if (StringUtils.isEmpty((String)aPath)) {
            throw new IllegalPathException(aPath, "The provided path is invalid.");
        }
        if (StringUtils.isEmpty((String)aName)) {
            throw new IllegalNameException(aName, "The provided name is invalid.");
        }
        boolean result = false;
        try {
            result = this.hasFile(FileSystemUtility.toKey((String)aPath, (String)aName));
        }
        catch (IllegalKeyException e) {
            throw new IOException(ExceptionUtility.toMessage((Throwable)e), e);
        }
        return result;
    }

    public boolean hasFile(FileHandle aFileHandle) throws NoListAccessException, UnknownFileSystemException, IOException, IllegalFileHandleException {
        boolean result = false;
        try {
            result = this.hasFile(aFileHandle.toKey());
        }
        catch (IllegalKeyException e) {
            throw new IOException(ExceptionUtility.toMessage((Throwable)e), e);
        }
        return result;
    }

    public FileHandle createFile(String aKey) throws FileAlreadyExistsException, NoCreateAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException {
        if (StringUtils.isEmpty((String)aKey)) {
            throw new IllegalKeyException(aKey, "The provided key is invalid.");
        }
        if (this.hasFile(aKey)) {
            throw new FileAlreadyExistsException(aKey, "A file handle with the given key \"" + aKey + "\" already exists.");
        }
        String path = FileSystemUtility.getPath((String)aKey);
        String name = FileSystemUtility.getName((String)aKey);
        FileHandleImpl fileHandle = new FileHandleImpl(path, name, 0L, new Date(), new Date());
        return fileHandle;
    }

    public FileHandle createFile(String aPath, String aName) throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, NoListAccessException {
        if (StringUtils.isEmpty((String)aPath)) {
            throw new IllegalPathException(aPath, "The provided path is invalid.");
        }
        if (StringUtils.isEmpty((String)aName)) {
            throw new IllegalNameException(aName, "The provided name is invalid.");
        }
        FileHandleImpl fileHandle = new FileHandleImpl(aPath, aName, 0L, new Date(), new Date());
        if (this.hasFile(aPath, aName)) {
            throw new FileAlreadyExistsException(fileHandle.toKey(), "A file handle with the given path \"" + aPath + "\" and name \"" + aName + "\" (key = \"" + FileSystemUtility.toKey((String)aPath, (String)aName) + "\") already exists.");
        }
        return fileHandle;
    }

    public FileHandle getFileHandle(String aKey) throws NoListAccessException, IllegalKeyException, UnknownFileSystemException, IOException, UnknownKeyException {
        if (StringUtils.isEmpty((String)aKey)) {
            throw new IllegalKeyException(aKey, "The provided key is invalid.");
        }
        if (!this.hasFile(aKey)) {
            throw new UnknownKeyException(aKey, "A file with the given key \"" + aKey + "\"does not exist!");
        }
        ObjectMetadata metadata = this.getAmazonS3Client().getObjectMetadata(this.getAmazonS3BucketName(), aKey);
        Date createdDate = this.getCreatedDate(metadata);
        String path = FileSystemUtility.getPath((String)aKey);
        String name = FileSystemUtility.getName((String)aKey);
        FileHandleImpl fileHandle = new FileHandleImpl(path, name, metadata.getContentLength(), createdDate, metadata.getLastModified());
        return fileHandle;
    }

    public FileHandle getFileHandle(String aPath, String aName) throws NoListAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, UnknownKeyException {
        if (StringUtils.isEmpty((String)aPath)) {
            throw new IllegalPathException(aPath, "The provided path is invalid.");
        }
        if (StringUtils.isEmpty((String)aName)) {
            throw new IllegalNameException(aName, "The provided name is invalid.");
        }
        if (!this.hasFile(aPath, aName)) {
            throw new UnknownKeyException(FileSystemUtility.toKey((String)aPath, (String)aName), "A filke with the given path \"" + aPath + "\" and name \"" + aName + "\" (= key \"" + FileSystemUtility.toKey((String)aPath, (String)aName) + "\") does not exists.");
        }
        String key = FileSystemUtility.toKey((String)aPath, (String)aName);
        ObjectMetadata metadata = this.getAmazonS3Client().getObjectMetadata(this.getAmazonS3BucketName(), key);
        Date createdDate = this.getCreatedDate(metadata);
        FileHandleImpl fileHandle = new FileHandleImpl(aPath, aName, metadata.getContentLength(), createdDate, metadata.getLastModified());
        return fileHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromFile(FileHandle aFromFileHandle, OutputStream aOutputStream) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aFromFileHandle)) {
            throw new UnknownFileException(aFromFileHandle, "The given \"from\" file handle was not found.");
        }
        S3Object s3Object = this.getAmazonS3Client().getObject(this.getAmazonS3BucketName(), aFromFileHandle.toKey());
        if (s3Object == null) {
            throw new UnknownFileException(aFromFileHandle, "The given \"from\" file handle was not found.");
        }
        try {
            IOUtils.copy((InputStream)s3Object.getObjectContent(), (OutputStream)aOutputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)s3Object.getObjectContent());
        }
    }

    public void toFile(FileHandle aToFileHandle, InputStream aInputStream) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        try {
            ObjectMetadata metadata = new ObjectMetadata();
            if (aToFileHandle.getCreatedDate() != null) {
                String createdDateString = DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.ofEpochMilli(aToFileHandle.getCreatedDate().getTime()));
                metadata.getUserMetadata().put(METADATA_CREATED_DATE, createdDateString);
            }
            this.getAmazonS3Client().putObject(this.getAmazonS3BucketName(), aToFileHandle.toKey(), aInputStream, metadata);
        }
        catch (AmazonClientException ase) {
            throw new IOException(ExceptionUtility.toMessage((Throwable)ase), ase);
        }
    }

    public InputStream fromFile(FileHandle aFromFileHandle) throws ConcurrentAccessException, UnknownFileException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aFromFileHandle)) {
            throw new UnknownFileException(aFromFileHandle, "The given \"from\" file handle was not found.");
        }
        S3Object s3Object = this.getAmazonS3Client().getObject(this.getAmazonS3BucketName(), aFromFileHandle.toKey());
        if (s3Object == null) {
            throw new UnknownFileException(aFromFileHandle, "The given \"from\" file handle was not found.");
        }
        return s3Object.getObjectContent();
    }

    public OutputStream toFile(final FileHandle aToFileHandle) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, IllegalFileHandleException {
        final PipedInputStream thePipedInputStream = new PipedInputStream();
        PipedOutputStream thePipedOutputStream = new PipedOutputStream(thePipedInputStream);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ObjectMetadata metadata = new ObjectMetadata();
                    if (aToFileHandle.getCreatedDate() != null) {
                        String createdDateString = DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.ofEpochMilli(aToFileHandle.getCreatedDate().getTime()));
                        metadata.getUserMetadata().put(METADATA_CREATED_DATE, createdDateString);
                    }
                    S3FileSystemImpl.this.getAmazonS3Client().putObject(S3FileSystemImpl.this.getAmazonS3BucketName(), aToFileHandle.toKey(), (InputStream)thePipedInputStream, metadata);
                }
                finally {
                    S3FileSystemImpl.this._threadCache.remove(this);
                }
            }
        };
        t.setDaemon(true);
        this._threadCache.add(t);
        t.start();
        return thePipedOutputStream;
    }

    public void fromFile(FileHandle aFileHandle, File aToFile) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aFileHandle)) {
            throw new UnknownFileException(aFileHandle, "The given file handle was not found.");
        }
        S3Object s3Object = this.getAmazonS3Client().getObject(this.getAmazonS3BucketName(), aFileHandle.toKey());
        if (s3Object == null) {
            throw new UnknownFileException(aFileHandle, "The given file handle was not found.");
        }
        S3ObjectInputStream theInputStream = s3Object.getObjectContent();
        FileOutputStream theOutputStream = new FileOutputStream(aToFile);
        IOUtils.copy((InputStream)theInputStream, (OutputStream)theOutputStream);
    }

    public void toFile(FileHandle aFileHandle, File aFile) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        this.getAmazonS3Client().putObject(this.getAmazonS3BucketName(), aFileHandle.toKey(), aFile);
    }

    public void toFile(FileHandle aFileHandle, byte[] aBuffer) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        ObjectMetadata theMetadata = new ObjectMetadata();
        if (aFileHandle.getCreatedDate() != null) {
            String createdDateString = DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.ofEpochMilli(aFileHandle.getCreatedDate().getTime()));
            theMetadata.getUserMetadata().put(METADATA_CREATED_DATE, createdDateString);
        }
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(aBuffer);
        theMetadata.setContentLength((long)aBuffer.length);
        this.getAmazonS3Client().putObject(this.getAmazonS3BucketName(), aFileHandle.toKey(), (InputStream)theInputStream, theMetadata);
    }

    public FileHandle renameFile(FileHandle aFileHandle, String aNewName) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalNameException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (StringUtils.isEmpty((String)aNewName)) {
            throw new IllegalNameException(aNewName, "The provided new name \"" + aFileHandle + "\" is invalid.");
        }
        FileHandle fileHandle = null;
        try {
            fileHandle = this.moveFile(aFileHandle, FileSystemUtility.toKey((String)aFileHandle.getPath(), (String)aNewName));
        }
        catch (IllegalKeyException e) {
            throw new IllegalNameException(aNewName, "The provided new name \"" + aNewName + "\" is invalid.");
        }
        return fileHandle;
    }

    public FileHandle moveFile(FileHandle aFileHandle, String aNewKey) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (StringUtils.isEmpty((String)aNewKey)) {
            throw new IllegalKeyException(aNewKey, "The provided new key \"" + aNewKey + "\" is invalid.");
        }
        if (!this.hasFile(aFileHandle)) {
            throw new UnknownFileException(aFileHandle, "The given file handle handle was not found.");
        }
        if (this.hasFile(aNewKey)) {
            throw new FileAlreadyExistsException(aNewKey, "A file handle with the given new key \"" + aNewKey + "\" already exists.");
        }
        this.getAmazonS3Client().copyObject(this.getAmazonS3BucketName(), aFileHandle.toKey(), this.getAmazonS3BucketName(), aNewKey);
        this.deleteFile(aFileHandle);
        FileHandle theNewFileHandle = null;
        try {
            theNewFileHandle = this.getFileHandle(aNewKey);
        }
        catch (UnknownKeyException unknownKeyException) {
            // empty catch block
        }
        if (theNewFileHandle == null) {
            LOGGER.warn("The file handle which moved from \"" + aFileHandle.toKey() + "\" to  \"" + aFileHandle.getName() + "\" does not exist any more at it's target location! This should never happen (we probably have encountered a thread race condition).");
            FileHandle.MutableFileHandle theMutableNewFileHandle = aFileHandle.toMutableFileHandle();
            theMutableNewFileHandle.setPath(FileSystemUtility.getPath((String)aNewKey));
            theMutableNewFileHandle.setName(FileSystemUtility.getName((String)aNewKey));
            return theMutableNewFileHandle;
        }
        return theNewFileHandle;
    }

    public void deleteFile(FileHandle aFileHandle) throws ConcurrentAccessException, UnknownFileException, NoDeleteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aFileHandle)) {
            throw new UnknownFileException(aFileHandle, "The given file handle was not found.");
        }
        this.getAmazonS3Client().deleteObject(this.getAmazonS3BucketName(), aFileHandle.toKey());
    }

    public boolean hasFiles(String aPath, boolean isRecursively) throws NoListAccessException, IllegalPathException, UnknownFileSystemException, IOException {
        if (StringUtils.isEmpty((String)aPath)) {
            throw new IllegalPathException(aPath, "The provided path \"" + aPath + "\" is invalid.");
        }
        try {
            List<FileHandle> fileHandles = this.getFileHandles(aPath, isRecursively);
            return !fileHandles.isEmpty();
        }
        catch (UnknownPathException e) {
            return false;
        }
    }

    public List<FileHandle> getFileHandles(String aPath, boolean isRecursively) throws NoListAccessException, UnknownPathException, IllegalPathException, UnknownFileSystemException, IOException {
        if (StringUtils.isEmpty((String)aPath)) {
            throw new IllegalPathException(aPath, "The provided path \"" + aPath + "\" is invalid.");
        }
        if (!aPath.endsWith("" + FileSystem.PATH_DELIMITER)) {
            aPath = aPath + FileSystem.PATH_DELIMITER;
        }
        ArrayList<FileHandle> result = new ArrayList<FileHandle>();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(this.getAmazonS3BucketName());
        listObjectsRequest.setDelimiter("" + FileSystem.PATH_DELIMITER);
        listObjectsRequest.setPrefix(aPath);
        ObjectListing objectListing = this.getAmazonS3Client().listObjects(listObjectsRequest);
        while (objectListing.getObjectSummaries() != null && !objectListing.getObjectSummaries().isEmpty()) {
            List batchObjects = objectListing.getObjectSummaries();
            for (S3ObjectSummary summary : batchObjects) {
                if (aPath.equals(summary.getKey())) continue;
                ObjectMetadata metadata = this.getAmazonS3Client().getObjectMetadata(this.getAmazonS3BucketName(), summary.getKey());
                Date createdDate = this.getCreatedDate(metadata);
                FileHandleImpl fileHandle = new FileHandleImpl(FileSystemUtility.getPath((String)summary.getKey()), FileSystemUtility.getName((String)summary.getKey()), metadata.getContentLength(), createdDate, summary.getLastModified());
                result.add((FileHandle)fileHandle);
            }
            if (isRecursively) {
                for (String prefix : objectListing.getCommonPrefixes()) {
                    result.addAll(this.getFileHandles(prefix, isRecursively));
                }
            }
            objectListing = this.getAmazonS3Client().listNextBatchOfObjects(objectListing);
        }
        return result;
    }

    public void destroy() {
        LOGGER.debug("Destroying the S3 file system...");
        while (!this._threadCache.isEmpty()) {
            LOGGER.info("Waiting for destroying the S3 file system because some threads aren't finished yet.");
            try {
                Thread.sleep(LoopSleepTime.NORM.getMilliseconds());
            }
            catch (InterruptedException interruptedException) {}
        }
        LOGGER.debug("Destroyed the S3 file system.");
    }

    private Date getCreatedDate(ObjectMetadata aMetadata) {
        String theCreatedDateString = (String)aMetadata.getUserMetadata().get(METADATA_CREATED_DATE);
        Date theCreatedDate = null;
        if (theCreatedDateString != null) {
            try {
                Instant theInstant = Instant.from(DateFormat.NORM_DATE_FORMAT.getFormatter().parse(theCreatedDateString));
                theCreatedDate = new Date(theInstant.toEpochMilli());
            }
            catch (DateTimeException e) {
                theCreatedDate = null;
            }
        }
        return theCreatedDate;
    }
}

