/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem.alt.s3;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.exception.ExceptionUtility;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;

abstract class AbstractS3Client {
    private static Logger LOGGER = Logger.getLogger(AbstractS3Client.class.getName());
    private static final int THREAD_POOL_SIZE = 20;
    private static final String DEFAULT_REGION = "s3-eu-west-1.amazonaws.com";
    private S3Client _amazonS3Client = null;
    private String _amazonS3BucketName = null;

    public AbstractS3Client(String aBucketName, String aAccessKey, String aSecretKey) {
        this(aBucketName, aAccessKey, aSecretKey, DEFAULT_REGION);
    }

    public AbstractS3Client(String aBucketName, String aAccessKey, String aSecretKey, String aRegion) {
        if (aRegion == null) {
            aRegion = DEFAULT_REGION;
        }
        this._amazonS3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)aAccessKey, (String)aSecretKey)))).region(Region.of((String)aRegion))).build();
        this._amazonS3BucketName = aBucketName;
    }

    protected String getAmazonS3BucketName() {
        return this._amazonS3BucketName;
    }

    protected void setAmazonS3BucketName(String aAmazonS3BucketName) {
        this._amazonS3BucketName = aAmazonS3BucketName;
    }

    protected S3Client getAmazonS3Client() {
        return this._amazonS3Client;
    }

    public static void createBucket(S3Client aAmazonS3, String aBucketId) {
        CreateBucketRequest theCreateBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(aBucketId).build();
        aAmazonS3.createBucket(theCreateBucketRequest);
    }

    protected static void clearBucket(S3Client aAmazonS3, String aBucketId) {
        ListObjectsV2Request theListObjectsRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(aBucketId).build();
        ListObjectsV2Response theObjectListing = aAmazonS3.listObjectsV2(theListObjectsRequest);
        while (theObjectListing.contents() != null && !theObjectListing.contents().isEmpty()) {
            List theObjectSummaries = theObjectListing.contents();
            AbstractS3Client.deleteS3Objects(aAmazonS3, aBucketId, theObjectSummaries);
            String eNextToken = theObjectListing.nextContinuationToken();
            theListObjectsRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(aBucketId).continuationToken(eNextToken).build();
            theObjectListing = aAmazonS3.listObjectsV2(theListObjectsRequest);
        }
    }

    public static void deleteBucket(S3Client aAmazonS3, String aBucketId) {
        AbstractS3Client.clearBucket(aAmazonS3, aBucketId);
        DeleteBucketRequest theDeleteBucketRequest = (DeleteBucketRequest)DeleteBucketRequest.builder().bucket(aBucketId).build();
        aAmazonS3.deleteBucket(theDeleteBucketRequest);
    }

    protected static S3Client createAmazonS3(String aAccessKey, String aSecretKey) {
        return (S3Client)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)aAccessKey, (String)aSecretKey)))).build();
    }

    protected static void deleteS3Objects(final S3Client aAmazonS3, final String aBucketId, List<S3Object> aS3SummaryObjects) {
        ExecutorService theExecutorService = Executors.newFixedThreadPool(20);
        final CountDownLatch theCountDownLatch = new CountDownLatch(aS3SummaryObjects.size());
        for (final S3Object eSummary : aS3SummaryObjects) {
            theExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            DeleteObjectRequest theDeleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(aBucketId).key(eSummary.key()).build();
                            aAmazonS3.deleteObject(theDeleteObjectRequest);
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, ExceptionUtility.toMessage((Throwable)e), e);
                            theCountDownLatch.countDown();
                        }
                    }
                    finally {
                        theCountDownLatch.countDown();
                    }
                }
            });
        }
        try {
            theCountDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        theExecutorService.shutdown();
    }

    protected static S3Client getAmazonS3Client(File aConfigFile) throws IOException {
        Properties theProperties = new Properties();
        theProperties.load(new FileInputStream(aConfigFile));
        return (S3Client)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.builder().profileFile(ProfileFile.builder().content(aConfigFile.toPath()).build()).build())).build();
    }
}

