/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem.alt.s3;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.filesystem.ConcurrentAccessException;
import org.refcodes.filesystem.FileAlreadyExistsException;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileHandleImpl;
import org.refcodes.filesystem.FileSystem;
import org.refcodes.filesystem.FileSystemUtility;
import org.refcodes.filesystem.IllegalFileHandleException;
import org.refcodes.filesystem.IllegalKeyException;
import org.refcodes.filesystem.IllegalNameException;
import org.refcodes.filesystem.IllegalPathException;
import org.refcodes.filesystem.NoCreateAccessException;
import org.refcodes.filesystem.NoDeleteAccessException;
import org.refcodes.filesystem.NoListAccessException;
import org.refcodes.filesystem.NoReadAccessException;
import org.refcodes.filesystem.NoWriteAccessException;
import org.refcodes.filesystem.UnknownFileException;
import org.refcodes.filesystem.UnknownFileSystemException;
import org.refcodes.filesystem.UnknownKeyException;
import org.refcodes.filesystem.UnknownPathException;
import org.refcodes.filesystem.alt.s3.AbstractS3Client;
import org.refcodes.time.DateFormat;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.S3Object;

public class S3FileSystem
extends AbstractS3Client
implements FileSystem {
    private static Logger LOGGER = Logger.getLogger(S3FileSystem.class.getName());
    private static String METADATA_CREATED_DATE = "CreatedDate";
    private HashSet<Thread> _threadCache = new HashSet();

    public S3FileSystem(String aBucketName, String aAccessKey, String aSecretKey) {
        super(aBucketName, aAccessKey, aSecretKey);
    }

    public S3FileSystem(String aBucketName, String aAccessKey, String aSecretKey, String aEndPoint) {
        super(aBucketName, aAccessKey, aSecretKey, aEndPoint);
    }

    public boolean hasFile(String aKey) throws IllegalKeyException, NoListAccessException, UnknownFileSystemException, IOException {
        if (aKey == null || aKey.length() == 0) {
            throw new IllegalKeyException(aKey, "The provided key is invalid.");
        }
        try {
            HeadObjectRequest theHeadObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aKey).build();
            this.getAmazonS3Client().headObject(theHeadObjectRequest);
        }
        catch (SdkServiceException e) {
            return false;
        }
        return true;
    }

    public boolean hasFile(String aPath, String aName) throws IllegalPathException, IllegalNameException, NoListAccessException, UnknownFileSystemException, IOException {
        if (aPath == null || aPath.length() == 0) {
            throw new IllegalPathException(aPath, "The provided path is invalid.");
        }
        if (aName == null || aName.length() == 0) {
            throw new IllegalNameException(aName, "The provided name is invalid.");
        }
        boolean result = false;
        try {
            result = this.hasFile(FileSystemUtility.toKey((String)aPath, (String)aName));
        }
        catch (IllegalKeyException e) {
            throw new IOException(ExceptionUtility.toMessage((Throwable)e), e);
        }
        return result;
    }

    public boolean hasFile(FileHandle aFileHandle) throws NoListAccessException, UnknownFileSystemException, IOException, IllegalFileHandleException {
        boolean result = false;
        try {
            result = this.hasFile(aFileHandle.toKey());
        }
        catch (IllegalKeyException e) {
            throw new IOException(ExceptionUtility.toMessage((Throwable)e), e);
        }
        return result;
    }

    public FileHandle createFile(String aKey) throws FileAlreadyExistsException, NoCreateAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException {
        if (aKey == null || aKey.length() == 0) {
            throw new IllegalKeyException(aKey, "The provided key is invalid.");
        }
        if (this.hasFile(aKey)) {
            throw new FileAlreadyExistsException(aKey, "A file handle with the given key \"" + aKey + "\" already exists.");
        }
        String path = FileSystemUtility.getPath((String)aKey);
        String name = FileSystemUtility.getName((String)aKey);
        FileHandleImpl fileHandle = new FileHandleImpl(path, name, 0L, new Date(), new Date());
        return fileHandle;
    }

    public FileHandle createFile(String aPath, String aName) throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, NoListAccessException {
        if (aPath == null || aPath.length() == 0) {
            throw new IllegalPathException(aPath, "The provided path is invalid.");
        }
        if (aName == null || aName.length() == 0) {
            throw new IllegalNameException(aName, "The provided name is invalid.");
        }
        FileHandleImpl fileHandle = new FileHandleImpl(aPath, aName, 0L, new Date(), new Date());
        if (this.hasFile(aPath, aName)) {
            throw new FileAlreadyExistsException(fileHandle.toKey(), "A file handle with the given path \"" + aPath + "\" and name \"" + aName + "\" (key = \"" + FileSystemUtility.toKey((String)aPath, (String)aName) + "\") already exists.");
        }
        return fileHandle;
    }

    public FileHandle getFileHandle(String aKey) throws NoListAccessException, IllegalKeyException, UnknownFileSystemException, IOException, UnknownKeyException {
        if (aKey == null || aKey.length() == 0) {
            throw new IllegalKeyException(aKey, "The provided key is invalid.");
        }
        if (!this.hasFile(aKey)) {
            throw new UnknownKeyException(aKey, "A file with the given key \"" + aKey + "\"does not exist!");
        }
        HeadObjectRequest theHeadObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aKey).build();
        HeadObjectResponse theHeadObjectResponse = this.getAmazonS3Client().headObject(theHeadObjectRequest);
        Date createdDate = this.getCreatedDate(theHeadObjectResponse.metadata());
        String path = FileSystemUtility.getPath((String)aKey);
        String name = FileSystemUtility.getName((String)aKey);
        FileHandleImpl fileHandle = new FileHandleImpl(path, name, theHeadObjectResponse.contentLength().longValue(), createdDate, Date.from(theHeadObjectResponse.lastModified()));
        return fileHandle;
    }

    public FileHandle getFileHandle(String aPath, String aName) throws NoListAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, UnknownKeyException {
        if (aPath == null || aPath.length() == 0) {
            throw new IllegalPathException(aPath, "The provided path is invalid.");
        }
        if (aName == null || aName.length() == 0) {
            throw new IllegalNameException(aName, "The provided name is invalid.");
        }
        if (!this.hasFile(aPath, aName)) {
            throw new UnknownKeyException(FileSystemUtility.toKey((String)aPath, (String)aName), "A filke with the given path \"" + aPath + "\" and name \"" + aName + "\" (= key \"" + FileSystemUtility.toKey((String)aPath, (String)aName) + "\") does not exists.");
        }
        String key = FileSystemUtility.toKey((String)aPath, (String)aName);
        HeadObjectRequest theHeadObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(key).build();
        HeadObjectResponse theHeadObjectResponse = this.getAmazonS3Client().headObject(theHeadObjectRequest);
        Date createdDate = this.getCreatedDate(theHeadObjectResponse.metadata());
        FileHandleImpl fileHandle = new FileHandleImpl(aPath, aName, theHeadObjectResponse.contentLength().longValue(), createdDate, Date.from(theHeadObjectResponse.lastModified()));
        return fileHandle;
    }

    public void fromFile(FileHandle aFromFileHandle, OutputStream aOutputStream) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aFromFileHandle)) {
            throw new UnknownFileException(aFromFileHandle, "The given \"from\" file handle was not found.");
        }
        GetObjectRequest theGetObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aFromFileHandle.toKey()).build();
        ResponseInputStream s3Object = this.getAmazonS3Client().getObject(theGetObjectRequest);
        if (s3Object == null) {
            throw new UnknownFileException(aFromFileHandle, "The given \"from\" file handle was not found.");
        }
        try {
            s3Object.transferTo(aOutputStream);
        }
        finally {
            try {
                s3Object.close();
            }
            catch (Exception exception) {}
        }
    }

    public void toFile(FileHandle aToFileHandle, InputStream aInputStream) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        try {
            HashMap<String, String> metadata = new HashMap<String, String>();
            if (aToFileHandle.getCreatedDate() != null) {
                String createdDateString = DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.ofEpochMilli(aToFileHandle.getCreatedDate().getTime()));
                metadata.put(METADATA_CREATED_DATE, createdDateString);
            }
            PutObjectRequest thePutObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aToFileHandle.toKey()).metadata(metadata).build();
            this.getAmazonS3Client().putObject(thePutObjectRequest, RequestBody.fromBytes((byte[])aInputStream.readAllBytes()));
        }
        catch (AwsServiceException ase) {
            throw new IOException(ExceptionUtility.toMessage((Throwable)ase), ase);
        }
    }

    public InputStream fromFile(FileHandle aFromFileHandle) throws ConcurrentAccessException, UnknownFileException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aFromFileHandle)) {
            throw new UnknownFileException(aFromFileHandle, "The given \"from\" file handle was not found.");
        }
        GetObjectRequest theGetObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aFromFileHandle.toKey()).build();
        ResponseInputStream s3Object = this.getAmazonS3Client().getObject(theGetObjectRequest);
        if (s3Object == null) {
            throw new UnknownFileException(aFromFileHandle, "The given \"from\" file handle was not found.");
        }
        return s3Object;
    }

    public OutputStream toFile(final FileHandle aToFileHandle) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, IllegalFileHandleException {
        final PipedInputStream thePipedInputStream = new PipedInputStream();
        final PipedOutputStream thePipedOutputStream = new PipedOutputStream(thePipedInputStream);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        HashMap<String, String> metadata = new HashMap<String, String>();
                        if (aToFileHandle.getCreatedDate() != null) {
                            String createdDateString = DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.ofEpochMilli(aToFileHandle.getCreatedDate().getTime()));
                            metadata.put(METADATA_CREATED_DATE, createdDateString);
                        }
                        PutObjectRequest thePutObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(S3FileSystem.this.getAmazonS3BucketName()).key(aToFileHandle.toKey()).metadata(metadata).build();
                        S3FileSystem.this.getAmazonS3Client().putObject(thePutObjectRequest, RequestBody.fromBytes((byte[])thePipedInputStream.readAllBytes()));
                    }
                    catch (IOException | AwsServiceException | SdkClientException e) {
                        LOGGER.log(Level.SEVERE, "Unable to issue the PUT object request for bucket <" + e, String.valueOf(S3FileSystem.this.getAmazonS3BucketName()) + "> and key \"" + aToFileHandle.toKey() + "\", now closing the output stream: " + e.getMessage());
                        try {
                            thePipedOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        S3FileSystem.this._threadCache.remove(this);
                    }
                }
                finally {
                    S3FileSystem.this._threadCache.remove(this);
                }
            }
        };
        t.setDaemon(true);
        this._threadCache.add(t);
        t.start();
        return thePipedOutputStream;
    }

    public void fromFile(FileHandle aFileHandle, File aToFile) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aFileHandle)) {
            throw new UnknownFileException(aFileHandle, "The given file handle was not found.");
        }
        GetObjectRequest theGetObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aFileHandle.toKey()).build();
        ResponseInputStream s3Object = this.getAmazonS3Client().getObject(theGetObjectRequest);
        if (s3Object == null) {
            throw new UnknownFileException(aFileHandle, "The given file handle was not found.");
        }
        FileOutputStream theOutputStream = new FileOutputStream(aToFile);
        s3Object.transferTo((OutputStream)theOutputStream);
    }

    public void toFile(FileHandle aFileHandle, File aFile) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        PutObjectRequest thePutObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aFileHandle.toKey()).build();
        this.getAmazonS3Client().putObject(thePutObjectRequest, RequestBody.fromFile((File)aFile));
    }

    public void toFile(FileHandle aFileHandle, byte[] aBuffer) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (aFileHandle.getCreatedDate() != null) {
            String createdDateString = DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.ofEpochMilli(aFileHandle.getCreatedDate().getTime()));
            metadata.put(METADATA_CREATED_DATE, createdDateString);
        }
        PutObjectRequest thePutObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aFileHandle.toKey()).metadata(metadata).build();
        this.getAmazonS3Client().putObject(thePutObjectRequest, RequestBody.fromBytes((byte[])aBuffer));
    }

    public FileHandle renameFile(FileHandle aFileHandle, String aNewName) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalNameException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (aNewName == null || aNewName.length() == 0) {
            throw new IllegalNameException(aNewName, "The provided new name \"" + aFileHandle + "\" is invalid.");
        }
        FileHandle fileHandle = null;
        try {
            fileHandle = this.moveFile(aFileHandle, FileSystemUtility.toKey((String)aFileHandle.getPath(), (String)aNewName));
        }
        catch (IllegalKeyException e) {
            throw new IllegalNameException(aNewName, "The provided new name \"" + aNewName + "\" is invalid.");
        }
        return fileHandle;
    }

    public FileHandle moveFile(FileHandle aFileHandle, String aNewKey) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (aNewKey == null || aNewKey.length() == 0) {
            throw new IllegalKeyException(aNewKey, "The provided new key \"" + aNewKey + "\" is invalid.");
        }
        if (!this.hasFile(aFileHandle)) {
            throw new UnknownFileException(aFileHandle, "The given file handle handle was not found.");
        }
        if (this.hasFile(aNewKey)) {
            throw new FileAlreadyExistsException(aNewKey, "A file handle with the given new key \"" + aNewKey + "\" already exists.");
        }
        String theSource = URLEncoder.encode(String.valueOf(this.getAmazonS3BucketName()) + "/" + aFileHandle.toKey(), StandardCharsets.UTF_8.name());
        CopyObjectRequest theCopyObjectRequest = (CopyObjectRequest)CopyObjectRequest.builder().copySource(theSource).destinationBucket(this.getAmazonS3BucketName()).destinationKey(aNewKey).build();
        this.getAmazonS3Client().copyObject(theCopyObjectRequest);
        this.deleteFile(aFileHandle);
        FileHandle theNewFileHandle = null;
        try {
            theNewFileHandle = this.getFileHandle(aNewKey);
        }
        catch (UnknownKeyException unknownKeyException) {
            // empty catch block
        }
        if (theNewFileHandle == null) {
            LOGGER.log(Level.WARNING, "The file handle which moved from \"" + aFileHandle.toKey() + "\" to  \"" + aFileHandle.getName() + "\" does not exist any more at it's target location! This should never happen (we probably have encountered a thread race condition).");
            FileHandle.MutableFileHandle theMutableNewFileHandle = aFileHandle.toMutableFileHandle();
            theMutableNewFileHandle.setPath(FileSystemUtility.getPath((String)aNewKey));
            theMutableNewFileHandle.setName(FileSystemUtility.getName((String)aNewKey));
            return theMutableNewFileHandle;
        }
        return theNewFileHandle;
    }

    public void deleteFile(FileHandle aFileHandle) throws ConcurrentAccessException, UnknownFileException, NoDeleteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aFileHandle)) {
            throw new UnknownFileException(aFileHandle, "The given file handle was not found.");
        }
        DeleteObjectRequest theDeleteObjectRequest = (DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(aFileHandle.toKey()).build();
        this.getAmazonS3Client().deleteObject(theDeleteObjectRequest);
    }

    public boolean hasFiles(String aPath, boolean isRecursively) throws NoListAccessException, IllegalPathException, UnknownFileSystemException, IOException {
        if (aPath == null || aPath.length() == 0) {
            throw new IllegalPathException(aPath, "The provided path \"" + aPath + "\" is invalid.");
        }
        try {
            List<FileHandle> fileHandles = this.getFileHandles(aPath, isRecursively);
            return !fileHandles.isEmpty();
        }
        catch (UnknownPathException e) {
            return false;
        }
    }

    public List<FileHandle> getFileHandles(String aPath, boolean isRecursively) throws NoListAccessException, UnknownPathException, IllegalPathException, UnknownFileSystemException, IOException {
        if (aPath == null || aPath.length() == 0) {
            throw new IllegalPathException(aPath, "The provided path \"" + aPath + "\" is invalid.");
        }
        if (!aPath.endsWith("" + FileSystem.PATH_DELIMITER)) {
            aPath = String.valueOf(aPath) + FileSystem.PATH_DELIMITER;
        }
        ArrayList<FileHandle> eResult = new ArrayList<FileHandle>();
        ListObjectsV2Request eListObjectsRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.getAmazonS3BucketName()).delimiter("" + FileSystem.PATH_DELIMITER).prefix(aPath).build();
        ListObjectsV2Response eObjectListing = this.getAmazonS3Client().listObjectsV2(eListObjectsRequest);
        while (eObjectListing.contents() != null && !eObjectListing.contents().isEmpty()) {
            List batchObjects = eObjectListing.contents();
            for (S3Object summary : batchObjects) {
                if (aPath.equals(summary.key())) continue;
                HeadObjectRequest eHeadObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.getAmazonS3BucketName()).key(summary.key()).build();
                HeadObjectResponse eHeadObjectResponse = this.getAmazonS3Client().headObject(eHeadObjectRequest);
                Date createdDate = this.getCreatedDate(eHeadObjectResponse.metadata());
                FileHandleImpl fileHandle = new FileHandleImpl(FileSystemUtility.getPath((String)summary.key()), FileSystemUtility.getName((String)summary.key()), eHeadObjectResponse.contentLength().longValue(), createdDate, Date.from(summary.lastModified()));
                eResult.add((FileHandle)fileHandle);
            }
            if (isRecursively) {
                for (CommonPrefix prefix : eObjectListing.commonPrefixes()) {
                    eResult.addAll(this.getFileHandles(prefix.prefix(), isRecursively));
                }
            }
            String eNextToken = eObjectListing.nextContinuationToken();
            eListObjectsRequest = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.getAmazonS3BucketName()).continuationToken(eNextToken).build();
            eObjectListing = this.getAmazonS3Client().listObjectsV2(eListObjectsRequest);
        }
        return eResult;
    }

    public void destroy() {
        LOGGER.log(Level.FINE, "Destroying the S3 file system...");
        while (!this._threadCache.isEmpty()) {
            LOGGER.info("Waiting for destroying the S3 file system because some threads aren't finished yet.");
            try {
                Thread.sleep(SleepLoopTime.NORM.getTimeMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.log(Level.FINE, "Destroyed the S3 file system.");
    }

    private Date getCreatedDate(Map<String, String> aMetadata) {
        String theCreatedDateString = aMetadata != null ? aMetadata.get(METADATA_CREATED_DATE) : null;
        Date theCreatedDate = null;
        if (theCreatedDateString != null) {
            try {
                Instant theInstant = Instant.from(DateFormat.NORM_DATE_FORMAT.getFormatter().parse(theCreatedDateString));
                theCreatedDate = new Date(theInstant.toEpochMilli());
            }
            catch (DateTimeException e) {
                theCreatedDate = null;
            }
        }
        return theCreatedDate;
    }
}

